#!/usr/bin/perl -w
use strict;
use Getopt::Std;

my %options;
getopts('dto:F:N:', \%options);
my $tsumero_mode = $options{'t'};
my $disproof_mode = $options{'d'};
my $output_base = "tmp/";
$output_base = $options{'o'}
    if $options{'o'};
my $max_id = 240000;
$max_id = $options{'N'}
    if $options{'N'};
my $skip_first = 0;
$skip_first = $options{'F'}
    if $options{'F'};
$max_id += $skip_first;

sub make_filename ($$) {
    my ($record_id, $state_id) = @_;
    my $mode = "";
    $mode = "tsumero"
	if ($tsumero_mode);
    $mode = "disproof"
	if ($disproof_mode);
    return sprintf("%s%s-%s-%s.csa", 
		   $output_base, $mode, $record_id, $state_id);
}

my $extract_program = "./extract";
my $kisen_record = "../../data/kisen/01.kif";

while (<STDIN>) {
    my ($record_id, $state_id, $defense_p, $defense_d,
	$attack_p, $attack_d, $tsumero_p, $tsumero_d) = split(/\s+/);
    last
	if ($record_id >= $max_id);
    if ($tsumero_mode) {
	next
	    unless ($state_id % 2==0); # ˵ͤä̤Ȥ ()
	if ($tsumero_p > 0) {
	    my $output = &make_filename($record_id, $state_id);
	    print STDERR "$output\n";
	    system($extract_program, "-c", "-o", $output,
		   "-k", $kisen_record, $record_id, $state_id);
	}
    } elsif ($disproof_mode) {
	next
	    unless ($state_id % 2==1); # 
	if ($attack_d > 1) {
	    my $output = &make_filename($record_id, $state_id);
	    print STDERR "$output\n";
	    system($extract_program, "-o", $output,
		   "-k", $kisen_record, $record_id, $state_id);
	}
    }
}
