#!/usr/bin/perl -w
use strict;
use File::Basename;

my @files = @ARGV;
my @data;
my @statistics;
my @results;

sub parse ($){
    my ($line) = @_;
    $line =~ s/^\s+//;
    my ($record, $move, $proof, $disproof, $tree_size, $uniq_node,
	$cycles, $total_node) = split(/\s+/, $line);
    my $result =
    {
     record => $record,
     move => $move,
     proof => $proof,
     disproof => $disproof,
     uniq_node => $uniq_node,
     total_node => $total_node,
     tree_size => $tree_size,
     cycles => $cycles,
     result => "unknown",
    };
    if ($proof == 1){
	$result->{result} = "proof";
    } elsif ($disproof == 1){
	$result->{result} = "disproof";
    }
    return $result;
}

sub make_statistics($) {
    my ($cur_data) = @_;
    my $proof_positions = 0;
    my $disproof_positions = 0;
    my $proof_uniqs = 0.0;
    my $proof_totals = 0.0;
    my $disproof_uniqs = 0.0;
    my $disproof_totals = 0.0;
    foreach my $id (0.. $#{$cur_data}) {
	my $entry = $cur_data->[$id];
	if ($entry->{result} eq "proof") {
	    ++$proof_positions;
	    $proof_uniqs = $entry->{uniq_node};
	    $proof_totals = $entry->{total_node};
	    $results[$id]->{proof} += 1;
	} elsif ($entry->{result} eq "disproof") {
	    ++$disproof_positions;
	    $disproof_uniqs = $entry->{uniq_node};
	    $disproof_totals = $entry->{total_node};
	    $results[$id]->{disproof} += 1;
	} else {
	    $results[$id]->{unknown} += 1;
	}
    }
    my $result =
    {
     proofs => $proof_positions,
     disproofs => $disproof_positions,
     # 򤱤̤Ѥ (i.e., ꥻåȤۤʤ) ·פȤäɤ
     proof_uniqs => $proof_uniqs,
     proof_totals => $proof_totals,
     disproof_uniqs => $disproof_uniqs,
     disproof_totals => $disproof_totals,
    };
    return $result;
}

foreach my $file (@files) {
    my $cur_data = [];
    open IN, $file
	|| die $!;
    @$cur_data = map { &parse($_) } <IN>;
    close IN;
    push(@data, $cur_data);
    my $stat = make_statistics($cur_data);
    push(@statistics, $stat);
}


foreach my $id (0 .. $#files) {
    my $file = $files[$id];
    my $stat = $statistics[$id];
    print "$file $stat->{proofs} $stat->{disproofs} "
	. (1000 - $stat->{proofs} - $stat->{disproofs}). "\n";
}

sub extract ($){
    my ($file) = @_;
    $file =~ s/^validation-attack-//;
    $file =~ s/\.[^.]+$//;
    return $file;
}

sub scatter_filename ($$$){
    my ($id1, $id2, $prefix) = @_;
    my $file1 = basename $files[$id1];
    my $file2 = basename $files[$id2];
    $file1 = &extract($file1);
    $file2 = &extract($file2);
    return "validation-$prefix+$file1+$file2.scat";
}


my %statistics2;
sub report_statistics2($$$$$$) {
    my ($result, $id, $count, $uniq_sum, $total_sum, $cycles) = @_;
    my $key = $result ."-". $id;
    return
	if ($statistics2{$key});
    $statistics2{$key} = 1;
    print STDERR "$result $files[$id] ";
    printf STDERR " %6.1f", $uniq_sum/$count;
    printf STDERR " %7.1f", $total_sum/$count;
    printf STDERR " %10.1f", $cycles/$total_sum;
    printf STDERR " %12.1f", $cycles/$count;
    print STDERR "\n";
}

sub make_scatter ($$$) {
    # ڤĤǤ˸ġפȤ
    my ($data_id1, $data_id2, $result) = @_;
    my $data1 = $data[$data_id1];
    my $data2 = $data[$data_id2];
    my $uniq_sum1 = 0.0;
    my $uniq_sum2 = 0.0;
    my $total_sum1 = 0.0;
    my $total_sum2 = 0.0;
    my $cycles1 = 0.0;
    my $cycles2 = 0.0;
    my $count = 0;
    my $file = &scatter_filename($data_id1, $data_id2, $result);
    open OUT, "> $file"
	|| die $!;
    foreach my $id (0 .. $#{$data2}) {
	my $entry1 = $data1->[$id];
	my $entry2 = $data2->[$id];
	# ƤμˡפΤΤ߻
	next
	    unless (keys %{$results[$id]} == 1);
	next
	    unless (defined $results[$id]->{$result});
	++$count;
	$uniq_sum1 += $entry1->{uniq_node};
	$uniq_sum2 += $entry2->{uniq_node};
	$total_sum1 += $entry1->{total_node};
	$total_sum2 += $entry2->{total_node};
	$cycles1 += $entry1->{cycles};
	$cycles2 += $entry2->{cycles};
	print OUT "$entry1->{uniq_node}\t$entry2->{uniq_node}"
	    . "\t$entry1->{total_node}\t$entry2->{total_node}"
	    . "\t$entry1->{cycles}\t$entry2->{cycles}"
		. "\n"
    }
    print OUT "#";
    printf OUT " %6.3f", $uniq_sum1/$count;
    printf OUT " %6.3f", $uniq_sum2/$count;
    printf OUT " %6.3f", $total_sum1/$count;
    printf OUT " %6.3f", $total_sum2/$count;
    printf OUT " %6.3f", $cycles1/$total_sum1;
    printf OUT " %6.3f", $cycles2/$total_sum2;
    print OUT "\n";
    close OUT;
    report_statistics2($result, $data_id1, $count, $uniq_sum1, $total_sum1, $cycles1);
    report_statistics2($result, $data_id2, $count, $uniq_sum2, $total_sum2, $cycles2);
}


foreach my $id1 (0 .. $#files) {
    next
	unless ($files[$id1] =~ /null/);
    foreach my $id2 (0 .. $#files) {
	next
	    if ($id1 == $id2);
	&make_scatter($id1, $id2, "proof");
	&make_scatter($id1, $id2, "disproof");
    }
}
