/* ANSI-C code produced by gperf version 2.7.2 */
/* Command-line: gperf -L ANSI-C -t -N lookup_type types.gperf  */
struct Type { char *name; GQL::SQLType::TypeCode typecode; };

#define TOTAL_KEYWORDS 17
#define MIN_WORD_LENGTH 3
#define MAX_WORD_LENGTH 9
#define MIN_HASH_VALUE 4
#define MAX_HASH_VALUE 39
/* maximum key range = 36, duplicates = 0 */

#ifdef __GNUC__
__inline
#else
#ifdef __cplusplus
inline
#endif
#endif
static unsigned int
hash (register const char *str, register unsigned int len)
{
  static unsigned char asso_values[] =
    {
      40, 40, 40, 40, 40, 40, 40, 40, 40, 40,
      40, 40, 40, 40, 40, 40, 40, 40, 40, 40,
      40, 40, 40, 40, 40, 40, 40, 40, 40, 40,
      40, 40, 40, 40, 40, 40, 40, 40, 40, 40,
      40, 40, 40, 40, 40, 40, 40, 40, 40, 40,
      15, 40,  5, 40, 40, 40, 25, 40, 40, 40,
      40, 40, 40, 40, 40, 40, 40, 40, 40, 40,
      40, 40, 40, 40, 40, 40, 40, 40, 40, 40,
      40, 40, 40, 40, 40, 40, 40, 40, 40, 40,
      40, 40, 40, 40, 40, 40, 40, 40, 20, 10,
      30,  0,  0, 40, 40,  0, 40, 40,  0,  0,
       0,  0, 30, 40,  0, 40,  0, 40,  0, 40,
      40,  0,  0, 40, 40, 40, 40, 40, 40, 40,
      40, 40, 40, 40, 40, 40, 40, 40, 40, 40,
      40, 40, 40, 40, 40, 40, 40, 40, 40, 40,
      40, 40, 40, 40, 40, 40, 40, 40, 40, 40,
      40, 40, 40, 40, 40, 40, 40, 40, 40, 40,
      40, 40, 40, 40, 40, 40, 40, 40, 40, 40,
      40, 40, 40, 40, 40, 40, 40, 40, 40, 40,
      40, 40, 40, 40, 40, 40, 40, 40, 40, 40,
      40, 40, 40, 40, 40, 40, 40, 40, 40, 40,
      40, 40, 40, 40, 40, 40, 40, 40, 40, 40,
      40, 40, 40, 40, 40, 40, 40, 40, 40, 40,
      40, 40, 40, 40, 40, 40, 40, 40, 40, 40,
      40, 40, 40, 40, 40, 40, 40, 40, 40, 40,
      40, 40, 40, 40, 40, 40
    };
  return len + asso_values[(unsigned char)str[len - 1]] + asso_values[(unsigned char)str[0]];
}

#ifdef __GNUC__
__inline
#endif
struct Type *
lookup_type (register const char *str, register unsigned int len)
{
  static struct Type wordlist[] =
    {
      {""}, {""}, {""}, {""},
      {"time",           SQLType::TIME},
      {"money",          SQLType::DECIMAL},
      {"timetz",         SQLType::TIME_WITH_TZ},
      {"varchar",        SQLType::CHARACTER_VARYING},
      {"interval",       SQLType::INTERVAL},
      {"int4",           SQLType::INTEGER},
      {""},
      {"float4",         SQLType::FLOAT},
      {""}, {""},
      {"char",           SQLType::CHARACTER},
      {""}, {""},
      {"numeric",        SQLType::NUMERIC},
      {""},
      {"int2",           SQLType::SMALLINT},
      {""}, {""}, {""}, {""},
      {"bool",           SQLType::BOOLEAN},
      {""}, {""}, {""}, {""},
      {"int8",           SQLType::INTEGER},
      {""},
      {"float8",         SQLType::FLOAT},
      {""},
      {"oid",		SQLType::BLOB},
      {"date",           SQLType::DATE},
      {""}, {""},
      {"decimal",        SQLType::DECIMAL},
      {""},
      {"timestamp",      SQLType::TIMESTAMP_WITH_TZ}
    };

  if (len <= MAX_WORD_LENGTH && len >= MIN_WORD_LENGTH)
    {
      register int key = hash (str, len);

      if (key <= MAX_HASH_VALUE && key >= 0)
        {
          register const char *s = wordlist[key].name;

          if (*str == *s && !strcmp (str + 1, s + 1))
            return &wordlist[key];
        }
    }
  return 0;
}
