// -*- c++ -*-
// generated by glade--
//------------------------------------------------------------------------------
// $Id: SchedulingPrefs.cpp,v 1.7 2006/06/14 02:34:38 vlg Exp $
//------------------------------------------------------------------------------
//                            SchedulingPref.h
//------------------------------------------------------------------------------
//  Copyright (c) 2004,2006 by Vladislav Grinchenko
//
//  This program is free software; you can redistribute it and/or 
//  modify it under the terms of the GNU General Public License   
//  as published by the Free Software Foundation; either version  
//  2 of the License, or (at your option) any later version.      
//------------------------------------------------------------------------------
//
// Date   : Sun May 30 21:09:23 EDT 2004
//
//------------------------------------------------------------------------------
#include <gtkmm/label.h>
#include <gtkmm/frame.h>
#include <gtkmm/scrolledwindow.h>

#include "GrappConf.h"
#include "SchedulingPrefs.h"
#include "PrefWindow.h"

#define SET_TITLE_LABEL(tl) \
	tl->set_alignment(0,0.5); \
	tl->set_padding(0,0); \
	tl->set_justify(Gtk::JUSTIFY_LEFT); \
	tl->set_line_wrap(false); \
	tl->set_use_markup(false); \
	tl->set_selectable(false);

#define SET_ENTRY(et) \
	et->set_flags (Gtk::CAN_FOCUS);    \
	et->set_visibility        (true);  \
	et->set_editable          (true);  \
	et->set_max_length        (0);     \
	et->set_has_frame         (true);  \
	et->set_activates_default (false); \
	et->set_width_chars       (2);

SchedulingPrefs::
SchedulingPrefs (PrefWindow& pwin_) :
	VBox(false, 0),
	m_pref_window (pwin_)
{  
	trace_with_mask("SchedulingPref::SchedulingPrefs",GUITRACE);
	int i;

	Gtk::Label* label_b01000 = Gtk::manage(new Gtk::Label(" weeks "));
	Gtk::Label* label_b02000 = Gtk::manage(new Gtk::Label(" weeks "));
	Gtk::Label* label_b03000 = Gtk::manage(new Gtk::Label(" weeks "));
	Gtk::Label* label_b04000 = Gtk::manage(new Gtk::Label(" weeks "));
	Gtk::Label* label_b05000 = Gtk::manage(new Gtk::Label(" weeks "));
	Gtk::Label* label_b00100 = Gtk::manage(new Gtk::Label(" days  "));
	Gtk::Label* label_b00200 = Gtk::manage(new Gtk::Label(" days  "));
	Gtk::Label* label_b00300 = Gtk::manage(new Gtk::Label(" days  "));
	Gtk::Label* label_b00400 = Gtk::manage(new Gtk::Label(" days  "));
	Gtk::Label* label_b00500 = Gtk::manage(new Gtk::Label(" days  "));
	Gtk::Label* label_b00010 = Gtk::manage(new Gtk::Label(" hours "));
	Gtk::Label* label_b00020 = Gtk::manage(new Gtk::Label(" hours "));
	Gtk::Label* label_b00030 = Gtk::manage(new Gtk::Label(" hours "));
	Gtk::Label* label_b00040 = Gtk::manage(new Gtk::Label(" hours "));
	Gtk::Label* label_b00050 = Gtk::manage(new Gtk::Label(" hours "));
	Gtk::Label* label_b00001 = Gtk::manage(new Gtk::Label(" mins  "));
	Gtk::Label* label_b00002 = Gtk::manage(new Gtk::Label(" mins  "));
	Gtk::Label* label_b00003 = Gtk::manage(new Gtk::Label(" mins  "));
	Gtk::Label* label_b00004 = Gtk::manage(new Gtk::Label(" mins  "));
	Gtk::Label* label_b00005 = Gtk::manage(new Gtk::Label(" mins  "));

	SET_TITLE_LABEL(label_b01000);
	SET_TITLE_LABEL(label_b02000);
	SET_TITLE_LABEL(label_b03000);
	SET_TITLE_LABEL(label_b04000);
	SET_TITLE_LABEL(label_b05000);
	SET_TITLE_LABEL(label_b00100);
	SET_TITLE_LABEL(label_b00200);
	SET_TITLE_LABEL(label_b00300);
	SET_TITLE_LABEL(label_b00400);
	SET_TITLE_LABEL(label_b00500);
	SET_TITLE_LABEL(label_b00010);
	SET_TITLE_LABEL(label_b00020);
	SET_TITLE_LABEL(label_b00030);
	SET_TITLE_LABEL(label_b00040);
	SET_TITLE_LABEL(label_b00050);
	SET_TITLE_LABEL(label_b00001);
	SET_TITLE_LABEL(label_b00002);
	SET_TITLE_LABEL(label_b00003);
	SET_TITLE_LABEL(label_b00004);
	SET_TITLE_LABEL(label_b00005);

	for (i = 0 ; i < CARD_BOX_SIZE; i++) {
		m_week_entry [i] = Gtk::manage(new Gtk::Entry());
		m_day_entry  [i] = Gtk::manage(new Gtk::Entry());
		m_hour_entry [i] = Gtk::manage(new Gtk::Entry());
		m_mins_entry [i] = Gtk::manage(new Gtk::Entry());
	}

	Gtk::Label* label_t100 = Gtk::manage(new Gtk::Label("In Box 1 after "));
	Gtk::Label* label_t200 = Gtk::manage(new Gtk::Label("In Box 2 after "));
	Gtk::Label* label_t300 = Gtk::manage(new Gtk::Label("In Box 3 after "));
	Gtk::Label* label_t400 = Gtk::manage(new Gtk::Label("In Box 4 after "));
	Gtk::Label* label_t500 = Gtk::manage(new Gtk::Label("In Box 5 after "));

	m_sched_table = Gtk::manage(new Gtk::Table(5, 10, false));
   
	Gtk::Label* frame_label = Gtk::manage(new Gtk::Label("Review Cards"));
	Gtk::Frame* m_frame     = Gtk::manage(new Gtk::Frame());


	for (i = 0; i < CARD_BOX_SIZE; i++) {
		SET_ENTRY(m_week_entry [i]);
		SET_ENTRY(m_day_entry  [i]);
		SET_ENTRY(m_hour_entry [i]);
		SET_ENTRY(m_mins_entry [i]);
	}

	SET_TITLE_LABEL(label_t100);
	SET_TITLE_LABEL(label_t200);
	SET_TITLE_LABEL(label_t300);
	SET_TITLE_LABEL(label_t400);
	SET_TITLE_LABEL(label_t500);

	m_sched_table->set_size_request(-1,-1);
	m_sched_table->set_row_spacings(3);
	m_sched_table->set_col_spacings(2);

	/** Attach labels (left, right, top, bottom)
	 */
	m_sched_table->attach(*label_b01000,2,3,0,1,
						  Gtk::FILL,Gtk::AttachOptions(),0,0);
	m_sched_table->attach(*label_b02000,2,3,1,2,
						  Gtk::FILL,Gtk::AttachOptions(),0,0);
	m_sched_table->attach(*label_b03000,2,3,2,3,
						  Gtk::FILL,Gtk::AttachOptions(),0,0);
	m_sched_table->attach(*label_b04000,2,3,3,4,
						  Gtk::FILL,Gtk::AttachOptions(),0,0);
	m_sched_table->attach(*label_b05000,2,3,4,5,
						  Gtk::FILL,Gtk::AttachOptions(),0,0);

	m_sched_table->attach(*label_b00100,4,5,0,1,
						  Gtk::FILL,Gtk::AttachOptions(),0,0);
	m_sched_table->attach(*label_b00200,4,5,1,2,
						  Gtk::FILL,Gtk::AttachOptions(),0,0);
	m_sched_table->attach(*label_b00300,4,5,2,3,
						  Gtk::FILL,Gtk::AttachOptions(),0,0);
	m_sched_table->attach(*label_b00400,4,5,3,4,
						  Gtk::FILL,Gtk::AttachOptions(),0,0);
	m_sched_table->attach(*label_b00500,4,5,4,5,
						  Gtk::FILL,Gtk::AttachOptions(),0,0);

	m_sched_table->attach(*label_b00010,6,7,0,1,
						  Gtk::FILL,Gtk::AttachOptions(),0,0);
	m_sched_table->attach(*label_b00020,6,7,1,2,
						  Gtk::FILL,Gtk::AttachOptions(),0,0);
	m_sched_table->attach(*label_b00030,6,7,2,3,
						  Gtk::FILL,Gtk::AttachOptions(),0,0);
	m_sched_table->attach(*label_b00040,6,7,3,4,
						  Gtk::FILL,Gtk::AttachOptions(),0,0);
	m_sched_table->attach(*label_b00050,6,7,4,5,
						  Gtk::FILL,Gtk::AttachOptions(),0,0);

	m_sched_table->attach(*label_b00001,8,9,0,1,
						  Gtk::FILL,Gtk::AttachOptions(),0,0);
	m_sched_table->attach(*label_b00002,8,9,1,2,
						  Gtk::FILL,Gtk::AttachOptions(),0,0);
	m_sched_table->attach(*label_b00003,8,9,2,3,
						  Gtk::FILL,Gtk::AttachOptions(),0,0);
	m_sched_table->attach(*label_b00004,8,9,3,4,
						  Gtk::FILL,Gtk::AttachOptions(),0,0);
	m_sched_table->attach(*label_b00005,8,9,4,5,
						  Gtk::FILL,Gtk::AttachOptions(),0,0);

	for (i = 0; i < CARD_BOX_SIZE; i++) {
		m_sched_table->attach(*m_week_entry [i],  1,2,i,i+1,
							  Gtk::EXPAND|Gtk::FILL,Gtk::AttachOptions(),0,0);

		m_sched_table->attach(*m_day_entry [i], 3,4,i,i+1,
							  Gtk::EXPAND|Gtk::FILL,Gtk::AttachOptions(),0,0);

		m_sched_table->attach(*m_hour_entry [i], 5,6,i,i+1,
							  Gtk::EXPAND|Gtk::FILL,Gtk::AttachOptions(),0,0);

		m_sched_table->attach(*m_mins_entry [i], 7,8,i,i+1,
							  Gtk::EXPAND|Gtk::FILL,Gtk::AttachOptions(),0,0);
	}

	m_sched_table->attach(*label_t100,0,1,0,1,
						  Gtk::FILL,Gtk::AttachOptions(),4,0);
	m_sched_table->attach(*label_t200,0,1,1,2,
						  Gtk::FILL,Gtk::AttachOptions(),4,0);
	m_sched_table->attach(*label_t300,0,1,2,3,
						  Gtk::FILL,Gtk::AttachOptions(),4,0);
	m_sched_table->attach(*label_t400,0,1,3,4,
						  Gtk::FILL,Gtk::AttachOptions(),4,0);
	m_sched_table->attach(*label_t500,0,1,4,5,
						  Gtk::FILL,Gtk::AttachOptions(),4,0);

	frame_label->set_alignment(0.5,0.5);
	frame_label->set_padding(0,0);
	frame_label->set_justify(Gtk::JUSTIFY_LEFT);
	frame_label->set_line_wrap(false);
	frame_label->set_use_markup(false);
	frame_label->set_selectable(false);

	m_frame->set_size_request(-1,-1);
	m_frame->set_shadow_type(Gtk::SHADOW_ETCHED_IN);
	m_frame->set_label_align(0,0.5);
	m_frame->set_label_widget(*frame_label);

#ifdef IS_HILDON
	Gtk::ScrolledWindow* scrollw = Gtk::manage (new Gtk::ScrolledWindow);
	scrollw->set_flags (Gtk::CAN_FOCUS);
	scrollw->set_shadow_type (Gtk::SHADOW_NONE);
	scrollw->set_policy (Gtk::POLICY_AUTOMATIC , Gtk::POLICY_ALWAYS);
	scrollw->property_window_placement ().set_value (Gtk::CORNER_TOP_LEFT);

	scrollw->add (*m_sched_table);
	m_frame->add(*scrollw);

#else  // Desktop
	m_frame->add(*m_sched_table);
#endif

	for (i = 0; i < CARD_BOX_SIZE; i++) {
		m_week_entry [i]->signal_changed().connect (
			sigc::mem_fun (m_pref_window, &PrefWindow::changed_cb));

		m_day_entry [i]->signal_changed().connect (
			sigc::mem_fun (m_pref_window, &PrefWindow::changed_cb));

		m_hour_entry [i]->signal_changed().connect (
			sigc::mem_fun (m_pref_window, &PrefWindow::changed_cb));

		m_mins_entry [i]->signal_changed().connect (
			sigc::mem_fun (m_pref_window, &PrefWindow::changed_cb));

		m_week_entry [i]->show ();
		m_day_entry  [i]->show ();
		m_hour_entry [i]->show ();
		m_mins_entry [i]->show ();

	}

	set_border_width(18);
	m_frame->show_all();
	pack_start(*m_frame);
}

void
SchedulingPrefs::
changed_cb () 
{
	m_pref_window.changed ();
}

void
SchedulingPrefs::
load_from_config ()
{
	trace_with_mask("SchedulingPrefs::load_from_config",GUITRACE);

	for (int i = 0; i < CARD_BOX_SIZE; i++) {
		m_week_entry [i]->set_text (CONFIG->get_sched_review_weeks (i));
		m_day_entry  [i]->set_text (CONFIG->get_sched_review_days  (i));
		m_hour_entry [i]->set_text (CONFIG->get_sched_review_hours (i));
		m_mins_entry [i]->set_text (CONFIG->get_sched_review_mins  (i));
	}
}

void
SchedulingPrefs::
save_to_config ()
{
	trace_with_mask("SchedulingPrefs::save_to_config",GUITRACE);

	for (int i = 0; i < CARD_BOX_SIZE; i++) {
		CONFIG->set_sched_review_weeks (i, m_week_entry [i]->get_text ());
		CONFIG->set_sched_review_days  (i, m_day_entry  [i]->get_text ());
		CONFIG->set_sched_review_hours (i, m_hour_entry [i]->get_text ());
		CONFIG->set_sched_review_mins  (i, m_mins_entry [i]->get_text ());
	}
}
