/*
 * Groach 'theme' header
 *
 * GroTheme is managed by reference count.
 * Owned by Controller or theme selector(property-box),
 * but aa persistent instance is typically owned by Controller.
 *
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */
#ifndef __GRO_THEME_H__
#define __GRO_THEME_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/* Theme file name.
   Directory name is passed to gro_theme_load(),
   and search this file in the directory. */
#define THEME_FILE_NAME		"config"

/* Theme load mode */
typedef enum {
	THEME_LOAD_NORMAL,	/* Load every information */
	THEME_LOAD_PREVIEW,	/* Small size pixmaps */
	THEME_LOAD_ONLYINFO	/* Load little information.
						   For example, load no pixmap. */
} ThemeLoadMode;


/* Module functions */
/* Symbol names */
#define THEME_INIT_SYM		"theme_init"
#define MOVE_INIT_SYM		"move_init"
#define MOVE_COMPUTE_SYM	"move_compute"
#define MOVE_FINALIZE_SYM	"move_finalize"
#define THEME_FINALIZE_SYM	"theme_finalize"

/* Return value	from GroThemeMoveCompute callback function.
   GRO_RET_MOVE includes the case that don't move but just advance the frame,
   in which case GroVector's ix and iy are zero values. */
typedef enum {
	GRO_RET_MOVE,
	GRO_RET_DONT_MOVE,
	GRO_RET_HIDDEN
} GroMoveRet;


/* Function type definitions */
/* GroThemeInit and GroThemeFinalize are called once for a theme.
   On the other hand, GroThemeMoveInit, GroThemeMoveCompute and
   GroThemeMoveFinalize are called for each GroMove. */
/* XXX: Meaning of return values of GroThemeMoveInit and GroThemeMoveFinalize
   is not decided yet. */
typedef gint (*GroThemeInit)(const GroController *controller);
typedef gint (*GroThemeMoveInit)(const GroController *controller, GroMove *gmove);
typedef GroMoveRet (*GroThemeMoveCompute)(const GroController *controller, GroMove *gmove, const GdkRegion *vis_region, GroVector *ret_vec);
typedef gint (*GroThemeMoveFinalize)(const GroController *controller, GroMove *gmove);
typedef gint (*GroThemeFinalize)(const GroController *controller);


/* Data structure definition */
/* Private stuff */
typedef struct _GroThemePrivate GroThemePrivate;

struct _GroTheme {
	gchar *name;
	gchar *description;
	gchar *author;

	gchar *module_name;	/* shared library */
	
	guint num_gstat;	/* Number of states */
	guint num_direct;	/* Number of directions */
	guint pix_width;	/* Pixel of width */
	guint pix_height;	/* Pixel of height */

	guint step_pixel;	/* aka leap pixel for one step.
						   It's up to move_compute logic how to use this. */
	
	/* Array of GroPixmap*.
	   Although these frames are kept in this data structure,
	   they are mainly referred to by GroMove instances,
	   This implementation intends to lower memory consumption. */
	/* This is a complex data structure.
	   frames[gstat][direct] is GPtrArray of GroPixmap.
	   GPtrArray *frames[DEFAULT_GRO_NUM_STAT][DEFAULT_GRO_NUM_DIRECT]; */
	GPtrArray ***frames;

	/* callback functions */
	GroThemeInit theme_init;
	GroThemeMoveInit move_init;
	GroThemeMoveCompute move_compute;
	GroThemeMoveFinalize move_finalize;
	GroThemeFinalize theme_finalize;
	
	GroThemePrivate *privat;
};

/* Returned from GroThemeMoveCompute callback function.
   The values, ix and iy, are incremental values,
   and minus values are acceptable. */
struct _GroVector {
	gint16 ix;
	gint16 iy;
};


/* Global function declarations */
extern GroTheme* gro_theme_load(const char *theme_dirname, ThemeLoadMode lmode);
extern void gro_theme_ref(GroTheme *theme);
extern void gro_theme_unref(GroTheme *theme);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __GRO_THEME_H__ */
