/*
 * Grouch.app				Copyright (C) 2006 Andy Sveikauskas
 * ------------------------------------------------------------------------
 * This program is free software under the GNU General Public License
 * --
 * Convert the junk strings and cryptic binary that is OSCAR into
 * an NSStringEncoding.  Or at least try to.
 */

#import <Foundation/NSString.h>

@interface OscarEncoding : NSObject

/****************************************************************/
// Get encoding for profile or chat room text
+ (NSStringEncoding)get:(NSString*)str;

// Get encoding for channel 1 Instant Message
+ (NSStringEncoding)getForChannel1:(int)set withSub:(int)sub;

/****************************************************************/
+ (void)encodeString:(NSString*)str
	encodingName:(NSString**)encoding	// oscar-style encoding name
	encodingID:(NSStringEncoding*)enc
	intFlag:(int*)r and:(int*)s;			// for channel1 msgs 

@end
