/*
 * Grouch.app				Copyright (C) 2006 Andy Sveikauskas
 * ------------------------------------------------------------------------
 * This program is free software under the GNU General Public License
 * --
 * Handshaking common to all Oscar FLAP connections (except auth)
 * goes here.
 *
 * If you want to make your FLAP do something special on sign-on,
 * extend OscarSnac00010002 and implement -pre: (called before the
 * client sends "Ready to go online" SNAC) and/or -post: (called after).
 * See OscarBos.m, which does this.
 */

#import <Oscar/OscarHandlers.h>
#import <Oscar/OscarBuffer.h>
#import <Oscar/OscarFlap.h>
#import <Oscar/OscarIncomingSnac.h>
#import <Foundation/NSEnumerator.h>

/*
 * Server welcome/supported snacs
 */
@interface OscarSnac00010003 : NSObject <OscarSnacHandler>
- (void)handleSnacForClient:(OscarFlap*)flap
		ofFamily:(int)family andType:(int)type
		withFlags:(int)flags andTag:tag
		buffer:(OscarIncomingSnac*)buf;
@end
@implementation OscarSnac00010003
- (void)handleSnacForClient:(OscarFlap*)flap
		ofFamily:(int)family andType:(int)type
		withFlags:(int)flags andTag:tag
		buffer:(OscarIncomingSnac*)buf
{
	OscarBuffer *out = [OscarBuffer snacWithFamily:0x01 andType:0x17
					 andTag:nil];
	OscarSnacHandler *h = [flap snacHandler];
	OscarSnacFamilyHandler *f;
	NSEnumerator *e;

	e = [h familyEnumerator];

	while( (f=[e nextObject]) )
	{
		[out addInt16:[f family]];
		[out addInt16:[f version]];
	}

	[flap write:out];
	[out release];
}
@end

/*
 * Server accepted above request.
 */
@interface OscarSnac00010018 : NSObject <OscarSnacHandler>
- (void)handleSnacForClient:(OscarFlap*)flap
		ofFamily:(int)family andType:(int)type
		withFlags:(int)flags andTag:tag
		buffer:(OscarIncomingSnac*)buf;
@end
@implementation OscarSnac00010018
- (void)handleSnacForClient:(OscarFlap*)flap
		ofFamily:(int)family andType:(int)type
		withFlags:(int)flags andTag:tag
		buffer:(OscarIncomingSnac*)buf
{
	OscarBuffer *out = [OscarBuffer snacWithFamily:0x01 andType:0x06
			   andTag:nil];
	[flap write:out];
	[out release];
}
@end

/*
 * Server reply to the above.
 */
@interface OscarSnac00010007 : NSObject <OscarSnacHandler>
- (void)handleSnacForClient:(OscarFlap*)flap
		ofFamily:(int)family andType:(int)type
		withFlags:(int)flags andTag:tag
		buffer:(OscarIncomingSnac*)buf;
@end
@implementation OscarSnac00010007
- (void)handleSnacForClient:(OscarFlap*)flap
		ofFamily:(int)family andType:(int)type
		withFlags:(int)flags andTag:tag
		buffer:(OscarIncomingSnac*)buf
{
	OscarBuffer *out = [OscarBuffer snacWithFamily:0x01 andType:0x08
			   andTag:nil];
	static const int sizeof_class = 35;
	int n = [buf readInt16];
	while( n-- && [buf bytesRemaining] )
	{
		[out addInt16:[buf readInt16]];
		[buf skipBytes:sizeof_class-2];
	}
	[flap write:out];
	[out release];

	// Ask to send a SNAC 01,02
	[flap handleSnacForClient:flap ofFamily:0x01 andType:0x02 withFlags:0
	      andTag:nil buffer:nil];
}
@end

@implementation OscarSnac00010002Base
- (void)handleSnacForClient:(OscarFlap*)flap
		ofFamily:(int)family andType:(int)type
		withFlags:(int)flags andTag:tag
		buffer:(OscarIncomingSnac*)buf
{
	OscarSnacFamilyHandler *h;
	OscarBuffer *out;
	NSEnumerator *e;

	[self pre:flap];
	out = [OscarBuffer snacWithFamily:0x01 andType:0x02 andTag:nil];
	e = [[flap snacHandler] familyEnumerator];
	while( (h=[e nextObject]) )
	{
		[out addInt16:[h family]];
		[out addInt16:[h version]];
		[out addInt16:0x0110];		// Fake WinAIM version number
		[out addInt16:[h dll]];
	}
	[flap write:out];
	[out release];
	[self post:flap];
	[flap welcome];
}

- (void)pre:(OscarFlap*)flap {} - (void)post:(OscarFlap*)flap {}
@end

@implementation OscarServiceHandler

+ get
{
	static id r = nil;
	if( r )
		return r;
	else
		return r = [OscarServiceHandler new];
}

- init
{
	[super init];
	[super initForFamily:0x01 andVersion:0x03 andDLL:0x0629];
	[self addHandler:[OscarErrorHandler get] forType:0x01];
	[self addHandler:[OscarSnac00010003 new] forType:0x03];
	[self addHandler:[OscarSnac00010018 new] forType:0x18];
	[self addHandler:[OscarSnac00010007 new] forType:0x07];
	[self addHandler:[OscarSnac00010002Base new] forType:0x02];
	return self;
}

@end
