/* -*-objc-*-
 *
 * Grr - Guenther's RSS Reader
 * Copyright (C) 2004-2006 Guenther Noack
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation;
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <AppKit/AppKit.h>
#include "PreferencesController.h"

@implementation PreferencesController

- (void) bringUpWindow: (id)sender
{
  [webBrowserField
    setStringValue:
      [[NSUserDefaults standardUserDefaults] stringForKey: @"WebBrowser"] ];
  
  [preferencesWindow orderFront: self];
}


- (void) testWebBrowser: (id)sender
{
  [[NSWorkspace sharedWorkspace]
    openURL:
      [NSURL URLWithString: @"http://www.unix-ag.uni-kl.de/~guenther/"]];
}


- (void) setWebBrowser: (id)sender
{
  [[NSUserDefaults standardUserDefaults]
    setObject: [webBrowserField stringValue]
    forKey: @"WebBrowser"];
}

@end
