/**************************************************************************
 *                                                                        *
 *   Copyright (C) 2001 Grub, Inc.                                        *
 *                                                                        *
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 1, or (at your option)  *
 *   any later version.                                                   *
 *                                                                        *
 *   This program is distributed in the hope that it will be useful,      *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *   GNU General Public License for more details.                         *
 *                                                                        *
 *   You should have received a copy of the GNU General Public License    *
 *   along with this program; if not, write to the Free Software          *
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 *                                                                        *
 *                                                                        *
 **************************************************************************/  

/* Project: 	GRUB-CLIENT <http://www.grub.org>
 * module: 	Archive (crawler)
 * Author: 	Ledio Ago(lajesus@grub.org)
 * Date:	Feb 13, 2001	
 * File: 	ServerDB.cpp
 */

#include "ServerDB.h"

ServerDB::ServerDB(char *file_db) : 
	UtilDB( file_db ),
	col_URL("URL"),
	col_CRC("CRC"),
	col_size("size") 
{
	/* Creating a database table */
	db_tbl = db_storage.GetAs(
		"DB_TABLE[URL:S,size:I,CRC:I]");

	db_storage.Commit();
	tbl_size = db_tbl.GetSize();
	tbl_index = 0;
}

ServerDB::~ServerDB() {}

/*
 * Method: 	GetServedUrl
 * Description:	It will access the information stored in the
 *		first record of the served urls table.  After
 *		the information is obtained, the record will
 *		be deleted.  The user of this method must
 *		allocate and deallocate the memory for handle.
 * Return:	It will return a structure with the obtained 
 *		information.
 */	
void ServerDB::GetServedUrl( URLHandler *handle ) 
	throw (GrubExp)
{
	char *tmp = NULL;

	assert( handle != NULL );
	
	tmp = (char*)col_URL.Get(db_tbl.ElementAt(tbl_index));
	if ( !tmp ) {
		throw GrubExp("GetServedUrl: Failed to get URL from "
			"served_urls table!");
	}
	handle->URL = new char[strlen(tmp)+1];
	if ( !handle->URL ) {
		throw GrubExp("GetServedUrl: Failed to allocate memory!");
	}
	else {
		strcpy( handle->URL, tmp );
	}

	handle->size = (unsigned long)col_size.Get(db_tbl.ElementAt(tbl_index));
	handle->CRC = (unsigned long)col_CRC.Get(db_tbl.ElementAt(tbl_index));

	tbl_size--;
	tbl_index++;

	if ( tbl_size == 0 ) {

		db_tbl.RemoveAll();
		Commit();
		tbl_index = 0;
	}
}
/*
 * Method:	InsertServedUrl
 * Description:	It will insert a record in served urls table.
 */
void ServerDB::InsertServedUrl( URLHandler *handle )
{
	assert( handle != NULL );

	db_tbl.Add (
			col_URL[handle->URL] + 
			col_CRC[(int)handle->CRC] +
			col_size[(int)handle->size]
	);
	Commit();
	tbl_size++;
}

