#include "zstream.h"

/* DEFLATE */

z_stream *zstream_deflate_init( int compr_level )
{
	z_stream *z = NULL;

	z = (z_stream *)malloc( sizeof( z_stream ) );

	memset( z, 0, sizeof( z_stream ) );

	z->zalloc = (alloc_func)0;
	z->zfree = (free_func)0;
	z->opaque = NULL;

	if ( deflateInit( z, compr_level ) != Z_OK ) {

		free( z );
		z = NULL;
	}

	return z;
}

int zwrite( z_stream *z, char *zbuf, int zbuflen,
	int fd, const char *buf, int buflen, void *arg,
	output_func output, int *output_ret )
{
	int ret;

	z->next_in = (char *)buf;
	z->avail_in = buflen;

	while ( z->avail_in > 0 ) {
		int status;
		int bytes_written = 0;

		z->next_out = zbuf;
		z->avail_out = zbuflen;

		status = deflate( z, Z_SYNC_FLUSH );
		switch (status) {
		case Z_OK:
			break;
		case Z_STREAM_ERROR:
			clog_c(GCLOG_CRIT, "Z_STREAM_ERROR: fatal error");
			exit(1);
		case Z_STREAM_END:
			clog_c(GCLOG_CRIT, "Z_STREAM_END: fatal error");
			exit(1);
		case Z_BUF_ERROR:
			clog_c(GCLOG_CRIT, "Z_BUF_ERROR: fatal error");
			exit(1);
		default:
			return ZS_ERROR;
		}  /* end switch */

		while ( zbuflen - z->avail_out > bytes_written ) {
			ret = output( fd, zbuf + bytes_written,
				zbuflen - z->avail_out - bytes_written,
				arg
			);
			*output_ret = ret;
			if ( ret < 0 )
				return ZS_CALLBACK;

			bytes_written += ret;
		}
	}

	return ZS_OK;
}

#if 0
int zwrite( z_stream *z, char *zbuf, int zbuflen,
	int fd, const char *buf, int buflen, void *arg,
	output_func output, int *output_ret )
{
	int ret;
	int bytes_written = 0;

	z->next_in = (char *)buf;
	z->avail_in = buflen;

	while ( z->avail_in > 0 ) {
		int status;

		z->next_out = zbuf;
		z->avail_out = zbuflen;

		status = deflate( z, Z_SYNC_FLUSH );
		switch (status) {
		case Z_OK:
			break;
		case Z_STREAM_ERROR:
			printf("Z_STREAM_ERROR: fatal error\n");
			exit(1);
		case Z_STREAM_END:
			printf("Z_STREAM_END: fatal error\n");
			exit(1);
		case Z_BUF_ERROR:
			printf("Z_BUF_ERROR: fatal error\n");
			exit(1);
		default:
			return ZS_ERROR;
		}  /* end switch */

		while ( zbuflen - z->avail_out > bytes_written ) {
			ret = output( fd, zbuf + bytes_written,
				zbuflen - z->avail_out - bytes_written,
				arg
			);
			*output_ret = ret;
			if ( ret < 0 )
				return ZS_CALLBACK;

			bytes_written += ret;
		}
	}

	return ZS_OK;
}
#endif

int zstream_deflate_end( z_stream *z )
{
	if ( z && deflateEnd( z ) != Z_OK ) {

		return 0;
	}

	return 0;
}


/* INFLATE */

z_stream *zstream_inflate_init()
{
	z_stream *z = NULL;

	z = (z_stream *)malloc( sizeof( z_stream ) );

	memset( z, 0, sizeof( z_stream ) );

	z->zalloc = (alloc_func)0;
	z->zfree = (free_func)0;

	if ( inflateInit( z ) != Z_OK ) {

		free( z );
		z = NULL;
	}

	return z;
}

int zread( z_stream *z, char *zbuf, int zbuflen,
	int fd, char *buf, int buflen, void *arg,
	input_func input, int *input_ret )
{
	int ret, status;

#if 0
	if ( buflen - z->avail_out > 0 ) {
		int copy_count =
			buflen > z->avail_out ?
			z->avail_out :
			buflen;

		memcpy( buf, z->next_out, copy_count );

		z->avail_out -= copy_count;
		z->next_out += copy_count;

		return copy_count;
	}
#endif

	z->next_out = buf;
	z->avail_out = buflen;

	if ( z->avail_in == 0 ) {

		ret = input( fd, zbuf, zbuflen, arg );
		*input_ret = ret;
		if ( ret <= 0 )
			return ZS_CALLBACK;
		else {

			z->next_in = zbuf;
			z->avail_in = ret;
		}
	}

	status = inflate( z, Z_SYNC_FLUSH );
	switch (status) {
	case Z_OK:
	case Z_STREAM_END:
		ret = buflen - z->avail_out;
		break;
	case Z_BUF_ERROR:
		return 0;
	case Z_STREAM_ERROR:
		clog_c(GCLOG_CRIT, "Z_STREAM_ERROR: fatal error");
		exit(1);
	case Z_DATA_ERROR:
		return ZS_STREAMERR;
	default:
		ret = ZS_ERROR;
	}  /* end switch */

	return ret;
}

int zstream_read_available( z_stream *z )
{
	return z->avail_out > 0;
}

int zstream_inflate_end( z_stream *z )
{
	if ( z && inflateEnd( z ) != Z_OK ) {

		return -1;
	}

	return 0;
}

