/**************************************************************************
 *                                                                        *
 *   Copyright (C) 2001 Grub, Inc.                                        *
 *                                                                        *
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 1, or (at your option)  *
 *   any later version.                                                   *
 *                                                                        *
 *   This program is distributed in the hope that it will be useful,      *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *   GNU General Public License for more details.                         *
 *                                                                        *
 *   You should have received a copy of the GNU General Public License    *
 *   along with this program; if not, write to the Free Software          *
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 *                                                                        *
 *                                                                        *
 **************************************************************************/
/* Project: GRUB
 * <http://www.grub.org>
 * module: CORD
 * Author: Kosta Damevski (Kosta42@hotmail.com)
 * Last revision: 16 Apr, 2001
 * Files: Coordinator.cpp Coordinator.h
 *
 *
 * The Coordinator class act as a global controler of the grub client. It
 * determines the proper action to be taken such as: CRAWL, GET or PUT and
 * it further invokes the necessary function to perform these actions.
 */


#ifndef _Coordinator_H_
#define _Coordinator_H_

#include <stdio.h>
#include <iostream.h>
#include <unistd.h>
#include <assert.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <Crawler.h>
#include <ClientTalk.h>
#include <ClientDB.h>
#include <ServerSettings.h>
#include <StatusInterface.h>
#include <lockfile.h>
#include <delay.h>
#include <Gui.h>
#include <clog.h>

extern "C" {
  #include <grubconf.h>
  #include <verbose.h>
}

#define COMM_ERR_RETRY 4		// number of seconds to wait if a comm error occurs
#define HUP_INTERVAL 30			// number of time to run through before reloading settings

class Coordinator
{
public:

	Coordinator();
	~Coordinator();
	
	void start();
	void hupSettings();
	int shutdown_gui();


private:

	int  ret;

	void *runCoordinator();

	// June 12, 2001: not exception-safe - should be wrapped by smart pointers
	// March 3, 2002; still not fixed - have no idea how either - kord
	Crawler    *Client_Crawler;		//Crawler 
	ClientTalk *Client_Protocol;		//Protocol 
	ClientDB   *Client_Data;		//Archive

	pid_t pid; /* has PID of forked process; or -1 if process is
	            * not yet forked or has died/was killed;
	            * or 0 if I am child */
};

#endif
