/**************************************************************************
 *                                                                        *
 *   Copyright (C) 2001 Grub, Inc.                                        *
 *                                                                        *
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 1, or (at your option)  *
 *   any later version.                                                   *
 *                                                                        *
 *   This program is distributed in the hope that it will be useful,      *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *   GNU General Public License for more details.                         *
 *                                                                        *
 *   You should have received a copy of the GNU General Public License    *
 *   along with this program; if not, write to the Free Software          *
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 *                                                                        *
 *                                                                        *
 **************************************************************************/  

#include "CrwStat.h"

using namespace std;

CrwStat::CrwStat(int psNum) { 
  this->psNum = psNum; 
  outfile = fopen(TIME_STAT_FILE,"a");  
  checkpt = 0;
}

CrwStat::~CrwStat() {
  fclose(outfile);
}

void CrwStat::go() {
  time(&checkpt);

}

void CrwStat::finish() {
  if (checkpt!=0) {
	time_t pt;
        float ratio;

	time(&pt);
	pt = pt - checkpt;
        ratio = (float) pt / psNum;
        fprintf(outfile,"Seconds to Crawl=%d   Per URL=%.3f\n",pt,ratio);
	checkpt=0;
  }
}


