// CConsoleFace.cpp : Implementation of CConsoleFace

#include "stdafx.h"
#include "GrubFace.h"
#include "CConsoleFace.h"
#include <wchar.h>

#define CONSOLE_DO_FIRE(event_name) Fire_##event_name

#define CONSOLE_STR(value) CComBSTR(value)

#define CONSOLE_INT(value) ((LONG)value)

// don't know about doubles; don't need them yet
//#define CONSOLE_DOUBLE(value) ((DOUBLE)value)

/////////////////////////////////////////////////////////////////////////////
// CConsoleFace

// Posts/Rings

STDMETHODIMP CConsoleFace::PostSetBandwidth(long Bandwidth)
{
	ConsoleFace::PostSetBandwidth((int)Bandwidth);

	return S_OK;
}

STDMETHODIMP CConsoleFace::PostSetCrawlerCount(long Count)
{
	ConsoleFace::PostSetCrawlerCount((int)Count);

	return S_OK;
}

STDMETHODIMP CConsoleFace::RingGetBandwidth()
{
	ConsoleFace::RingGetBandwidth();

	return S_OK;
}

STDMETHODIMP CConsoleFace::RingGetBandwidthLimit()
{
	ConsoleFace::RingGetBandwidthLimit();

	return S_OK;
}

STDMETHODIMP CConsoleFace::RingGetCrawlerCount()
{
	ConsoleFace::RingGetCrawlerCount();

	return S_OK;
}

STDMETHODIMP CConsoleFace::RingGetStatus()
{
	ConsoleFace::RingGetStatus();

	return S_OK;
}

// Events

void CConsoleFace::EventGetBandwidth(int Bandwidth)
{
	CONSOLE_DO_FIRE(GetBandwidth)(CONSOLE_INT(Bandwidth));
}

void CConsoleFace::EventGetBandwidthLimit(int Limit)
{
	CONSOLE_DO_FIRE(GetBandwidthLimit)(CONSOLE_INT(Limit));
}

void CConsoleFace::EventGetCrawlerCount(int Count)
{
	CONSOLE_DO_FIRE(GetCrawlerCount)(CONSOLE_INT(Count));
}

void CConsoleFace::EventGetStatus(int Status)
{
	CONSOLE_DO_FIRE(GetStatus)(CONSOLE_INT(Status));
}


void CConsoleFace::EventGettingBegin()
{
	CONSOLE_DO_FIRE(GettingBegin)();
}

void CConsoleFace::EventGettingURL(const char *URL, int Size, int CRC)
{
	CONSOLE_DO_FIRE(GettingURL)(CONSOLE_STR(URL), CONSOLE_INT(Size),
		CONSOLE_INT(CRC));
}

void CConsoleFace::EventGettingEnd()
{
	CONSOLE_DO_FIRE(GettingEnd)();
}

void CConsoleFace::EventCrawlingBegin()
{
	CONSOLE_DO_FIRE(CrawlingBegin)();
}

void CConsoleFace::EventCrawlingURL(
	const char *URL,
	const char *Status,
	int Size,
	int CRC,
	int Bandwidth)
{
	CONSOLE_DO_FIRE(CrawlingURL)(
		CONSOLE_STR(URL),
		CONSOLE_STR(Status),
		CONSOLE_INT(Size),
		CONSOLE_INT(CRC),
		CONSOLE_INT(Bandwidth)
	);
}

void CConsoleFace::EventCrawlingURLDone(const char *URL, const char *Status)
{
	CONSOLE_DO_FIRE(CrawlingURLDone)(CONSOLE_STR(URL), CONSOLE_STR(Status));
}

void CConsoleFace::EventCrawlingEnd()
{
	CONSOLE_DO_FIRE(CrawlingEnd)();
}

void CConsoleFace::EventPuttingBegin()
{
	CONSOLE_DO_FIRE(PuttingBegin)();
}

void CConsoleFace::EventPuttingURL(
	const char *URL,
	const char *Status,
	int Size,
	int CRC)
{
	CONSOLE_DO_FIRE(PuttingURL)(
		CONSOLE_STR(URL),
		CONSOLE_STR(Status),
		CONSOLE_INT(Size),
		CONSOLE_INT(CRC)
	);
}

void CConsoleFace::EventPuttingEnd()
{
	CONSOLE_DO_FIRE(PuttingEnd)();
}


void CConsoleFace::EventHostProtect()
{
	CONSOLE_DO_FIRE(HostProtect)();
}

void CConsoleFace::EventHostUnprotect()
{
	CONSOLE_DO_FIRE(HostUnprotect)();
}

void CConsoleFace::EventSleep(int Seconds)
{
	CONSOLE_DO_FIRE(Sleep)(CONSOLE_INT(Seconds));
}

// alias for EventError(Message)
void CConsoleFace::errorCallback(const char *Message)
{
	CONSOLE_DO_FIRE(Error)(CONSOLE_STR(Message));
}

// Methods

STDMETHODIMP CConsoleFace::Connect()
{
	ConsoleFace::Connect();

	return S_OK;
}

STDMETHODIMP CConsoleFace::Disconnect()
{
	ConsoleFace::Disconnect();

	return S_OK;
}

STDMETHODIMP CConsoleFace::Refresh()
{
	ConsoleFace::Refresh();

	return S_OK;
}

STDMETHODIMP CConsoleFace::IsConnected(BOOL *IsConn)
{
	*IsConn = (BOOL)(ConsoleFace::IsConnected());

	return S_OK;
}

// Properties

STDMETHODIMP CConsoleFace::get_Host(BSTR *pVal)
{
	CComBSTR bstr(ConsoleFace::GetHost());

	*pVal = bstr.Detach();

	return S_OK;
}

STDMETHODIMP CConsoleFace::put_Host(BSTR newVal)
{
	char *cstr;
	int len;

	len = (int)wcslen(newVal);
	cstr = new char[len + 2];

	// convert wide chars to plain ANSI chars; then set host
	wcstombs( cstr, newVal, len + 1 );
	ConsoleFace::SetHost(cstr);

	delete [] cstr;

	return S_OK;
}

STDMETHODIMP CConsoleFace::get_Port(long *pVal)
{
	*pVal = (long)ConsoleFace::GetPort();

	return S_OK;
}

STDMETHODIMP CConsoleFace::put_Port(long newVal)
{
	if ( newVal < 0 )
		ConsoleFace::SetPort(0);
	else if ( newVal > 65535 )
		ConsoleFace::SetPort(65535);
	else
		ConsoleFace::SetPort((unsigned short)newVal);

	return S_OK;
}

// functions

#ifndef GRUB_UNIX
// called just after the input thread begins
void threadinit_callback( SocketComm *scomm )
{
	// Initialize COM, MTA worker thread:
	HRESULT hRes = CoInitializeEx(NULL, COINIT_MULTITHREADED);
	// TODO: error checking?
}

// called just before the input thread exits
void threaduninit_callback( SocketComm *scomm )
{
	// Uninitialize COM
	CoUninitialize();
}
#endif
