#ifndef GRUB_UNIX
#include <winsock.h>
#endif
#include <cstdio>
#include <ctime>
#include <cstring>
#include <testgui.h>
#include <msgface.h>
#include <SocketComm.h>
#ifdef GRUB_UNIX
#include <sys/types.h>
#include <sys/socket.h>
#endif

#define PORTNUM 5123

#ifndef MSLEEP
// millisecond sleep
#ifdef GRUB_UNIX
#	define MSLEEP(t) \
	do { \
		if ( (int)t < 1000 ) \
			usleep(1000 * (int)t); \
		else \
			sleep( (int)t / 1000 ); \
	} while(0)
#else  /* GRUB_UNIX */
#	define MSLEEP(t) ::Sleep((int)t)
#endif  /* ! GRUB_UNIX */
#endif  /* MSLEEP */

void do_action(SOCKET);
void do_action2();
void do_action3();

int read_function( void *arg, const char *buf, unsigned int len )
{
	printf( "read_function(%d): '%s'\n", len, buf );
	return 0;
}

void error_function( void *ptr, const char *msg )
{
	printf("error_function: ptr (%p); msg '%s'\n", msg, msg );
}

/* code to establish a socket
 */
SOCKET establish(unsigned short portnum)
{	
	char myname[256];
	SOCKET s;
	struct sockaddr_in sa;
	struct hostent *hp;

	memset(&sa, 0, sizeof(struct sockaddr_in));
	gethostname(myname, sizeof(myname));
	hp = gethostbyname(myname);
	if (hp == NULL)
		return(INVALID_SOCKET);
	sa.sin_family = hp->h_addrtype;
	sa.sin_port = htons(portnum);
	s = socket(AF_INET, SOCK_STREAM, 0);
	if (s == INVALID_SOCKET)
		return INVALID_SOCKET;

	/* bind the socket to the internet address */
	if (bind(s, (struct sockaddr *)&sa, sizeof(struct sockaddr_in)) ==
		SOCKET_ERROR)
	{
		closesocket(s);
		return(INVALID_SOCKET);
	}
	listen(s, 3);

	return(s);
}


int main()
{
#ifndef GRUB_UNIX
	WSADATA info;
#endif
//	SOCKET s;

#ifndef GRUB_UNIX
	/* initialize the socket library */
	if (WSAStartup(MAKELONG(1, 1), &info) == SOCKET_ERROR) {
		return 1;
	}
#endif

#if 0
	if ((s = establish(PORTNUM)) == INVALID_SOCKET) { /* plug in the phone */
		perror("establish");
		exit(1);
	}

	for (;;) {														/* loop for phone calls */
		SOCKET new_sock = accept(s, NULL, NULL);
		if (s == INVALID_SOCKET) {
			fprintf(stderr, "Error waiting for new connection!\n");
			exit(1);
		}

		do_action(new_sock);

		closesocket(new_sock);
	}
#else

	// older tests
	// do_action2();

//	do_action3();
//	test_loop_MsgManager(0);
//	test_loop_ConsoleFace(0);
	test_server_simulator(0, "test.dat");
#endif

#ifndef GRUB_UNIX
	WSACleanup();
#endif

	return 0;
}


#if 0
#define G_SLEEP_MIN 1
#define G_SLEEP_MAX 5
#define G_DATASIZE_MIN 11
#define G_DATASIZE_MAX 19

enum GType { G_SLEEP, G_ACT, G_DATASIZE, G_SEND, G_RECV };

int main()
{
	void test_rand();

	test_rand();

	return 0;
}

int g_myrand( int top_limit )
{
	static int g_myrand_init = 0;

	if ( ! g_myrand_init ) {

		g_myrand_init = 1;
		srand( time( NULL ) );
	}

	return rand() / ( RAND_MAX / top_limit );
}

unsigned int g_rand( GType type )
{
	unsigned int ret = 0;
	switch (type) {
	case G_SLEEP:
		ret = g_myrand( G_SLEEP_MAX - G_SLEEP_MIN + 1 ) + G_SLEEP_MIN;
		break;
	case G_ACT:
		ret = (unsigned int)( ( g_myrand(2) == 0 ) ? G_SEND : G_RECV );
		break;
	case G_DATASIZE:
		ret = g_myrand( G_DATASIZE_MAX - G_DATASIZE_MIN + 1 ) +
			G_DATASIZE_MIN;
		break;
	}  /* end switch */

	return ret;
}

void test_rand()
{
	int g_myrand( int top_limit );

	for ( int i; i < 100; i++ )
		printf("SLEEP %4d ACT %4d DATASIZE %4d\n",
			g_rand(G_SLEEP), g_rand(G_ACT), g_rand(G_DATASIZE) );
}
#endif

void do_action(SOCKET s)
{
	gmsg_init(s);

	test_loop(0);

	gmsg_uninit();
}

void do_action2()
{
	int ret;
	SocketComm scomm(
INVALID_SOCKET,
		PORTNUM, read_function, error_function );

	scomm.initSock();

	MSLEEP(5000);
	ret = scomm.send( "second", 6 );
	if ( ret )
		printf( "send failed: %d: %s\n", ret, scomm.getError() );
	else
		printf( "send success\n" );

	MSLEEP(1000000);
}

void do_action3()
{
	test_loop2(0);
}
