/**************************************************************************
 *                                                                        *
 *   Copyright (C) 2001 Grub, Inc.                                        *
 *                                                                        *
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 1, or (at your option)  *
 *   any later version.                                                   *
 *                                                                        *
 *   This program is distributed in the hope that it will be useful,      *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *   GNU General Public License for more details.                         *
 *                                                                        *
 *   You should have received a copy of the GNU General Public License    *
 *   along with this program; if not, write to the Free Software          *
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 *                                                                        *
 *                                                                        *
 **************************************************************************/
/*
 * module: PROT
 * Author: Kosta Damevski (Kosta42@hotmail.com)
 * Last revision: 08 Feb, 2001
 * Files: ClientTalk.cpp ClientTalk.h
 *        GetProtocol.cpp GetProtocol.h
 *        PutProtocol.cpp PutProtocol.h
 *	  GetParser.cpp GetParser.h
 *
 *
 * ClientTalk is the main protocol class coordinates all aspect of 
 * the protocol between the client and the server. It does some parsing
 * of the protocol, but also invokes two separate classes PutProtocol and
 * GetProtocol which in turn coordinate the GET and PUT parts of the protocol.
 * (see also the protocol documentation file)
 */


//***********************************************************
#ifndef _ClientTalk_H_
#define _ClientTalk_H_

#include <iostream.h>
#include <stdio.h>
#include <Communication.h>
#include "Protocol.h"
#include "GetProtocol.h"
#include "PutProtocol.h"
#include <ClientDB.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/socket.h>
#include <unistd.h>
#include <connector.h>
extern "C" {
  #include <verbose.h>
}


/*Number of times the client should accept a NO-BYE
  response from the server. After this limit has been
  reached the client just disconnects*/
#define NO_MORE_BYES 5

/*Number of words and max length of line read from server*/
#define READ_LINE_LENGTH 5000
#define NUM_OF_READ_WORDS 10

/*Communication directives*/
#define HOST "brainbug.grub.org"

//Settings from the server overrule these
//#define PORT 3136
//#define PORT 12001

class ClientTalk
{
  public:
  	/*
  	ClientTalk::ClientTalk()
  	-- cDB - a linked list based database which holds client URLS and associated info
  	-- new_act - The action (GET or PUT) that we wan the protocol
  			to perform.
  	-- clientID - The client ID number
  	-- ver - The current version of the client software
 	-- log - a ptr to the logging class
  	*/
	ClientTalk(ClientDB *cDB, int new_act, unsigned int connectID, int PortNumber, double ver);
	
	~ClientTalk();
	
	/*
	start()
	
	This method has most of the protocol implemented in it.
	It uses a Communication class instance to establish
	communication with a server and subsequently does the outsets
	of both of the REQ and REP parts of the protocol. It instantiates
	classes which extend the class Protocol in order to work out the
	more specofic parts of the REQ and REP.
	*/
	void start() throw (ProtocolExp);
	
	/*
	end()
	
	Implements a way in which the the client will end
	a session with the server.
	*/
	void end();
	
	/*
	setAct(int )
	
	Used to assign an action to the protocol such as GET or PUT
	*/
	void setAct(int );

	/*
	int getURLCount();

	Used to get the number of URLs given this run
	*/
	int getURLCount();

	bool quit;	//Variable which if set to true indicates a time
			//to end the protocol	
  private:

	/*
	void reset()

	Reset the ClientDB as provided for in the protocol.
	Also closes the connection.
	*/
        void reset();   

	/*
	void delay()

	Delays a number of seconds as commanded by the server.
	Also closes the connection.
	*/
	void delay();
	
	/*
	void get()

	Parses the main get line. After that, it calls the GetProtocol
	class to parse and store the URLS.
	*/
	void get();

	/*
	void put()

	Conducts the beginning of the protocol when the client wants to put. 
	After that, the PutProtocol class puts the individual URL info.
	*/
	void put();

	/*
	open_comm()
	
	opens a communication channel to a host using its
	name and its port number.
	*/
        void open_comm(string host, int port);

        /*
        close_comm()

        close the communication channel which was opened by open_comm()
        */
        void close_comm();

        /*  	
        send(const char *)

        wrap function that uses the communication class'
        functions to send data.
        */
  	int send(const char *);
	
        /*  	
        recv()

        wrap function that uses the communication class'
        functions to recieve data. It reads the data word 
  	by word and puts it in the string array in_str[].
        */
	int recv();

	void okPut_Extras(string [], char *, char *, 	
			  char *, char *, char *);
	
	int connfd;	//a connection file descriptot	
	Protocol *prot;   //ptr to superclass protocol
	Communication *comm;  //communication module
	ClientDB *cDB;	//client DB used to store all URL info
	int act;  	//determines the current action

	unsigned int connectID;	//Unique identifier for a client connecting 

	double ver;	//version of the client
	string in_str[NUM_OF_READ_WORDS];  //a string array used to get input word by word 
	int url_count;  // URL count of the URLs processed by the last action
	int PortNumber;	// the port number
};

#endif
