/**************************************************************************
 *                                                                        *
 *   Copyright (C) 2001 Grub, Inc.                                        *
 *                                                                        *
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 1, or (at your option)  *
 *   any later version.                                                   *
 *                                                                        *
 *   This program is distributed in the hope that it will be useful,      *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *   GNU General Public License for more details.                         *
 *                                                                        *
 *   You should have received a copy of the GNU General Public License    *
 *   along with this program; if not, write to the Free Software          *
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 *                                                                        *
 *                                                                        *
 **************************************************************************/  

#include "Parser.h"

using namespace std;

// CLASS ParseExp - PUBLIC

ParseExp::ParseExp() throw() : GrubExp("Parse exception"), code(0) { }

ParseExp::ParseExp( const char *msg, int code = 0 ) throw() :
	GrubExp(msg), code(code) { }

ParseExp::ParseExp( const ParseExp& exp ) throw() :
	GrubExp(exp), code(exp.code) { }

ParseExp& ParseExp::operator=( const ParseExp& exp ) throw()
{
	if ( &exp != this ) {

		code = exp.code;
		GrubExp::operator=( exp );
	}

	return *this;
}

int ParseExp::getcode() throw()
{
	return code;
}

