/**************************************************************************
 *                                                                        *
 *   Copyright (C) 2001 Grub, Inc.                                        *
 *                                                                        *
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 1, or (at your option)  *
 *   any later version.                                                   *
 *                                                                        *
 *   This program is distributed in the hope that it will be useful,      *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *   GNU General Public License for more details.                         *
 *                                                                        *
 *   You should have received a copy of the GNU General Public License    *
 *   along with this program; if not, write to the Free Software          *
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 *                                                                        *
 *                                                                        *
 **************************************************************************/
/* Project: GRUB 
 * <http://www.grub.org>
 * module: CREP
 * Author: Kosta Damevski (Kosta42@hotmail.com)
 * Last revision: 08 Jan, 2001
 * Files: PutProtocol.cpp PutProtocol.h
 *
 * Part of the protocol used to report back all data to the
 * server. This class together with the PutParser class consist
 * this part of the protocol. The protocol() method of this class
 * is the one used to perform this function.
 */


//***********************************************************
#ifndef _PutProtocol_H_
#define _PutProtocol_H_

#include "PutParser.h"
#include "Protocol.h"
#include <ClientDB.h>
#include <time.h>
extern "C" {
  #include <verbose.h>
}

/*The max size of the line to send to server (excludes web page contents)*/
#define SEND_LINE_LENGTH 300

/*Logs the put statements to file putlog.log for debugging purposes*/
//#define LOG

/*Prints the contents of the archive to the log file*/
//#define DEBUG_PRINT_ARCH

class PutProtocol : public PutParser, public Protocol
{
  public:
  	PutProtocol(ClientDB *,Communication *,char *,char *,char *,char *,char *,char *);
	
	/*
	Puts extracted urls to the server
	  (NOT IMPLEMENTED YET) 
	*/  
	void putNewURL();

	/*
	Return web page together with its status and other
	information back to the server
	*/
	void putDueURL();  	

	/*
	Method used to start the protocol
	*/
        int protocol() throw (ProtocolExp);

   private:
  	int send(const char *, int);	//method to send data 
	void flush();		//method to flush data

  	ClientDB *cDB;		//Client database
  	Communication *comm;	//Communication module used by send()

  	//the specifications of the <ok-put> statament
  	char *contents;
  	char *tags;
  	char *new1;
	char *preprocess;
	char *redirects;

#ifdef LOG	
	FILE *log;
#endif
	
};

#endif
