/* $Id: dbl_list.c,v 1.2 2001/05/15 19:14:33 ozra Exp $ */

/**************************************************************************
 *                                                                        *
 *   Copyright (C) 2000 Grub, Inc.                                        *
 *                                                                        *
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 1, or (at your option)  *
 *   any later version.                                                   *
 *                                                                        *
 *   This program is distributed in the hope that it will be useful,      *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *   GNU General Public License for more details.                         *
 *                                                                        *
 *   You should have received a copy of the GNU General Public License    *
 *   along with this program; if not, write to the Free Software          *
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 *                                                                        *
 *   Author:  Igor Stojanovski - ozra   (email: ozra@grub.org)            *
 *                                                                        *
 **************************************************************************/

#include "dbl_list.h"


dbl_list_t *dbl_list_create() {
#ifndef __cplusplus
	dbl_list_t *lst = (dbl_list_t *)malloc( sizeof( dbl_list_t ) );
#else
	dbl_list_t *lst = new dbl_list_t;
#endif

	if ( lst ) {

		lst->front = lst->back = 0;
		lst->count = 0;
	}

	return lst;
}


void dbl_list_destroy( dbl_list_t *lst ) {

	while( lst->count > 0 )
		dbl_list_delete( lst, lst->front );

#ifndef __cplusplus
	free( lst );
#else
	delete lst;
#endif
}


dbl_list_node_t *dbl_list_append( dbl_list_t *lst, void *data ) {
#ifndef __cplusplus
	dbl_list_node_t *node = (dbl_list_node_t *)malloc(
			sizeof( dbl_list_node_t ) );
#else
	dbl_list_node_t *node = new dbl_list_node_t;
#endif

	if ( node ) {

		node->next = 0;
		node->data = data;

		if ( lst->count > 0 ) {

			lst->back->next = node;
			node->prev = lst->back;
		}
		else {

			node->prev = 0;
			lst->front = node;
		}

		lst->back = node;
		lst->count++;
	}

	return node;
}


void dbl_list_delete( dbl_list_t *lst, dbl_list_node_t *node ) {

	if ( lst->count == 1 ) {

		lst->front = lst->back = 0;
	}
	else if ( node == lst->front ) {

		lst->front = node->next;
		node->next->prev = 0;
	}
	else if ( node == lst->back ) {

		lst->back = node->prev;
		node->prev->next = 0;
	}
	else {

		node->prev->next = node->next;
		node->next->prev = node->prev;
	}

#ifndef __cplusplus
	free( node );
#else
	delete node;
#endif

	lst->count--;
}


dbl_list_node_t *dbl_list_front( dbl_list_t *lst ) {

	return lst->front;
}


dbl_list_node_t *dbl_list_next( dbl_list_node_t *node ) {

	return node->next;
}


void *dbl_list_data( dbl_list_node_t *node ) {

	return node->data;
}


int dbl_list_count( dbl_list_t *lst ) {

	return lst->count;
}

