//*****************************************************************************
//                                  PrcGWave.hpp                              *
//                                 --------------                             *
//  Description : Provides a programatic interface to the utility gwave which *
//                is a wave form viewer. The user can view the raw simulation *
//                data or envoke this utility which plots the data            *
//                graphically.                                                *
//  Started     : 29/03/2004                                                  *
//  Last Update : 22/01/2008                                                  *
//  Copyright   : (C) 2004 by MSWaters                                        *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef PRCGWAVE_HPP
#define PRCGWAVE_HPP

// System Includes

using  namespace  std;

#include <iostream>

// wxWindows Includes

#include <wx/wx.h>
#include <wx/tokenzr.h>

// Application Includes

#include "base/PrcBase.hpp"

// Local Constant Declarations


//*****************************************************************************

class PrcGWave : public PrcBase
{
  private:

    wxFileName  m_ofnResults; // The full simulator results file name

    // Functions for reformatting the results file for input to the viewer
    bool  bFormatFile ( void );
    bool  bFormatLine ( wxString & rosLine );
    bool  bFormatField( wxString & rosField );

  public:

    PrcGWave( void );
   ~PrcGWave( );

    bool  bSetResults( const wxString & rosFileName );

    const wxFileName & roGetResults( void ) { return( m_ofnResults ); }

    bool  bExec( void );
};

//*****************************************************************************

#endif // PRCGWAVE_HPP
