//*****************************************************************************
//                              CmdGnuCapDC.hpp                               *
//                             -----------------                              *
// Description : This class contains values associated with the GNU-Cap       *
//               DC command. It inherits from the class CmdBase.              *
// Started     : 29/01/2008                                                   *
// Last Update : 13/05/2009                                                   *
// Copyright   : (C) 2008 by M.S.Waters                                       *
// Email       : M.Waters@bom.gov.au                                          *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef CMDGNUCAPDC_HPP
#define CMDGNUCAPDC_HPP

// System Includes

using  namespace  std;

#include <iostream>
#include <climits>

// wxWidgets Includes

#include <wx/wx.h>
#include <wx/tokenzr.h>

// Application Includes

#include "base/CmdBase.hpp"
#include "ngspice/commands/CmdNgSpiceDC.hpp"
#include "utility/ConvertType.hpp"

struct CmdNgSpiceDC;

// Local Macro and Constant Declarations

//*****************************************************************************

struct CmdGnuCapDC : public CmdBase
{
  private :

    virtual  bool  bValidate( void );

  public :

    wxString    m_osStart;   // Sweep start value
    wxString    m_osStop;    // Sweep stop  value
    wxString    m_osStep;    // Sweep step  value
    eScaleType  m_eScale;    // Step scale
    wxString    m_osSource;  // Sweep source
    wxString    m_osTempC;   // Analysis temperature in Celcius

              CmdGnuCapDC( void );
    virtual  ~CmdGnuCapDC( );

    virtual  bool  bClear( void );

    virtual  bool  bParse ( void );
    virtual  bool  bFormat( void );

    CmdGnuCapDC & operator = ( const CmdNgSpiceDC & roCmdDC );

    void  Print( const wxString & rosPrefix=wxT("  ") );
};

//*****************************************************************************

#endif // CMDGNUCAPDC_HPP
