
/* autogenerated from video-orc.orc */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <glib.h>

#ifndef _ORC_INTEGER_TYPEDEFS_
#define _ORC_INTEGER_TYPEDEFS_
#if defined(__STDC_VERSION__) && __STDC_VERSION__ >= 199901L
#include <stdint.h>
typedef int8_t orc_int8;
typedef int16_t orc_int16;
typedef int32_t orc_int32;
typedef int64_t orc_int64;
typedef uint8_t orc_uint8;
typedef uint16_t orc_uint16;
typedef uint32_t orc_uint32;
typedef uint64_t orc_uint64;
#define ORC_UINT64_C(x) UINT64_C(x)
#elif defined(_MSC_VER)
typedef signed __int8 orc_int8;
typedef signed __int16 orc_int16;
typedef signed __int32 orc_int32;
typedef signed __int64 orc_int64;
typedef unsigned __int8 orc_uint8;
typedef unsigned __int16 orc_uint16;
typedef unsigned __int32 orc_uint32;
typedef unsigned __int64 orc_uint64;
#define ORC_UINT64_C(x) (x##Ui64)
#define inline __inline
#else
#include <limits.h>
typedef signed char orc_int8;
typedef short orc_int16;
typedef int orc_int32;
typedef unsigned char orc_uint8;
typedef unsigned short orc_uint16;
typedef unsigned int orc_uint32;
#if INT_MAX == LONG_MAX
typedef long long orc_int64;
typedef unsigned long long orc_uint64;
#define ORC_UINT64_C(x) (x##ULL)
#else
typedef long orc_int64;
typedef unsigned long orc_uint64;
#define ORC_UINT64_C(x) (x##UL)
#endif
#endif
typedef union
{
  orc_int16 i;
  orc_int8 x2[2];
} orc_union16;
typedef union
{
  orc_int32 i;
  float f;
  orc_int16 x2[2];
  orc_int8 x4[4];
} orc_union32;
typedef union
{
  orc_int64 i;
  double f;
  orc_int32 x2[2];
  float x2f[2];
  orc_int16 x4[4];
} orc_union64;
#endif
#ifndef ORC_RESTRICT
#if defined(__STDC_VERSION__) && __STDC_VERSION__ >= 199901L
#define ORC_RESTRICT restrict
#elif defined(__GNUC__) && __GNUC__ >= 4
#define ORC_RESTRICT __restrict__
#else
#define ORC_RESTRICT
#endif
#endif

#ifndef ORC_INTERNAL
#if defined(__SUNPRO_C) && (__SUNPRO_C >= 0x590)
#define ORC_INTERNAL __attribute__((visibility("hidden")))
#elif defined(__SUNPRO_C) && (__SUNPRO_C >= 0x550)
#define ORC_INTERNAL __hidden
#elif defined (__GNUC__)
#define ORC_INTERNAL __attribute__((visibility("hidden")))
#else
#define ORC_INTERNAL
#endif
#endif


#ifndef DISABLE_ORC
#include <orc/orc.h>
#endif
void video_orc_blend_little (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n);
void video_orc_blend_big (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n);
void video_orc_unpack_I420 (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2,
    const guint8 * ORC_RESTRICT s3, int n);
void video_orc_pack_I420 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2,
    guint8 * ORC_RESTRICT d3, const guint8 * ORC_RESTRICT s1, int n);
void video_orc_unpack_YUY2 (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n);
void video_orc_pack_YUY2 (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n);
void video_orc_pack_UYVY (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n);
void video_orc_unpack_UYVY (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n);
void video_orc_unpack_YVYU (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n);
void video_orc_pack_YVYU (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n);
void video_orc_unpack_YUV9 (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2,
    const guint8 * ORC_RESTRICT s3, int n);
void video_orc_unpack_Y42B (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2,
    const guint8 * ORC_RESTRICT s3, int n);
void video_orc_pack_Y42B (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2,
    guint8 * ORC_RESTRICT d3, const guint8 * ORC_RESTRICT s1, int n);
void video_orc_unpack_Y444 (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2,
    const guint8 * ORC_RESTRICT s3, int n);
void video_orc_pack_Y444 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2,
    guint8 * ORC_RESTRICT d3, const guint8 * ORC_RESTRICT s1, int n);
void video_orc_unpack_GRAY8 (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n);
void video_orc_pack_GRAY8 (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n);
void video_orc_unpack_BGRA (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n);
void video_orc_pack_BGRA (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n);
void video_orc_pack_RGBA (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n);
void video_orc_unpack_RGBA (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n);
void video_orc_unpack_ABGR (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n);
void video_orc_pack_ABGR (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n);
void video_orc_unpack_NV12 (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, int n);
void video_orc_pack_NV12 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2,
    const guint8 * ORC_RESTRICT s1, int n);
void video_orc_unpack_NV21 (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, int n);
void video_orc_pack_NV21 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2,
    const guint8 * ORC_RESTRICT s1, int n);
void video_orc_unpack_NV24 (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, int n);
void video_orc_pack_NV24 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2,
    const guint8 * ORC_RESTRICT s1, int n);
void video_orc_unpack_A420 (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2,
    const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4, int n);
void video_orc_pack_A420 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2,
    guint8 * ORC_RESTRICT d3, guint8 * ORC_RESTRICT d4,
    const guint8 * ORC_RESTRICT s1, int n);
void video_orc_resample_bilinear_u32 (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int p1, int p2, int n);
void video_orc_merge_linear_u8 (orc_uint8 * ORC_RESTRICT d1,
    const orc_uint8 * ORC_RESTRICT s1, const orc_uint8 * ORC_RESTRICT s2,
    int p1, int n);


/* begin Orc C target preamble */
#define ORC_CLAMP(x,a,b) ((x)<(a) ? (a) : ((x)>(b) ? (b) : (x)))
#define ORC_ABS(a) ((a)<0 ? -(a) : (a))
#define ORC_MIN(a,b) ((a)<(b) ? (a) : (b))
#define ORC_MAX(a,b) ((a)>(b) ? (a) : (b))
#define ORC_SB_MAX 127
#define ORC_SB_MIN (-1-ORC_SB_MAX)
#define ORC_UB_MAX 255
#define ORC_UB_MIN 0
#define ORC_SW_MAX 32767
#define ORC_SW_MIN (-1-ORC_SW_MAX)
#define ORC_UW_MAX 65535
#define ORC_UW_MIN 0
#define ORC_SL_MAX 2147483647
#define ORC_SL_MIN (-1-ORC_SL_MAX)
#define ORC_UL_MAX 4294967295U
#define ORC_UL_MIN 0
#define ORC_CLAMP_SB(x) ORC_CLAMP(x,ORC_SB_MIN,ORC_SB_MAX)
#define ORC_CLAMP_UB(x) ORC_CLAMP(x,ORC_UB_MIN,ORC_UB_MAX)
#define ORC_CLAMP_SW(x) ORC_CLAMP(x,ORC_SW_MIN,ORC_SW_MAX)
#define ORC_CLAMP_UW(x) ORC_CLAMP(x,ORC_UW_MIN,ORC_UW_MAX)
#define ORC_CLAMP_SL(x) ORC_CLAMP(x,ORC_SL_MIN,ORC_SL_MAX)
#define ORC_CLAMP_UL(x) ORC_CLAMP(x,ORC_UL_MIN,ORC_UL_MAX)
#define ORC_SWAP_W(x) ((((x)&0xffU)<<8) | (((x)&0xff00U)>>8))
#define ORC_SWAP_L(x) ((((x)&0xffU)<<24) | (((x)&0xff00U)<<8) | (((x)&0xff0000U)>>8) | (((x)&0xff000000U)>>24))
#define ORC_SWAP_Q(x) ((((x)&ORC_UINT64_C(0xff))<<56) | (((x)&ORC_UINT64_C(0xff00))<<40) | (((x)&ORC_UINT64_C(0xff0000))<<24) | (((x)&ORC_UINT64_C(0xff000000))<<8) | (((x)&ORC_UINT64_C(0xff00000000))>>8) | (((x)&ORC_UINT64_C(0xff0000000000))>>24) | (((x)&ORC_UINT64_C(0xff000000000000))>>40) | (((x)&ORC_UINT64_C(0xff00000000000000))>>56))
#define ORC_PTR_OFFSET(ptr,offset) ((void *)(((unsigned char *)(ptr)) + (offset)))
#define ORC_DENORMAL(x) ((x) & ((((x)&0x7f800000) == 0) ? 0xff800000 : 0xffffffff))
#define ORC_ISNAN(x) ((((x)&0x7f800000) == 0x7f800000) && (((x)&0x007fffff) != 0))
#define ORC_DENORMAL_DOUBLE(x) ((x) & ((((x)&ORC_UINT64_C(0x7ff0000000000000)) == 0) ? ORC_UINT64_C(0xfff0000000000000) : ORC_UINT64_C(0xffffffffffffffff)))
#define ORC_ISNAN_DOUBLE(x) ((((x)&ORC_UINT64_C(0x7ff0000000000000)) == ORC_UINT64_C(0x7ff0000000000000)) && (((x)&ORC_UINT64_C(0x000fffffffffffff)) != 0))
#ifndef ORC_RESTRICT
#if defined(__STDC_VERSION__) && __STDC_VERSION__ >= 199901L
#define ORC_RESTRICT restrict
#elif defined(__GNUC__) && __GNUC__ >= 4
#define ORC_RESTRICT __restrict__
#else
#define ORC_RESTRICT
#endif
#endif
/* end Orc C target preamble */



/* video_orc_blend_little */
#ifdef DISABLE_ORC
void
video_orc_blend_little (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union32 var39;
#else
  orc_union32 var39;
#endif
  orc_union32 var40;
  orc_union16 var41;
  orc_int8 var42;
  orc_union32 var43;
  orc_union64 var44;
  orc_union64 var45;
  orc_union64 var46;
  orc_union32 var47;
  orc_union64 var48;
  orc_union64 var49;
  orc_union64 var50;
  orc_union64 var51;
  orc_union64 var52;
  orc_union32 var53;
  orc_union32 var54;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_union32 *) s1;

  /* 14: loadpl */
  var39.i = (int) 0x000000ff;   /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var40 = ptr4[i];
    /* 1: convlw */
    var41.i = var40.i;
    /* 2: convwb */
    var42 = var41.i;
    /* 3: splatbl */
    var43.i =
        ((var42 & 0xff) << 24) | ((var42 & 0xff) << 16) | ((var42 & 0xff) << 8)
        | (var42 & 0xff);
    /* 4: convubw */
    var44.x4[0] = (orc_uint8) var43.x4[0];
    var44.x4[1] = (orc_uint8) var43.x4[1];
    var44.x4[2] = (orc_uint8) var43.x4[2];
    var44.x4[3] = (orc_uint8) var43.x4[3];
    /* 5: shruw */
    var45.x4[0] = ((orc_uint16) var44.x4[0]) >> 8;
    var45.x4[1] = ((orc_uint16) var44.x4[1]) >> 8;
    var45.x4[2] = ((orc_uint16) var44.x4[2]) >> 8;
    var45.x4[3] = ((orc_uint16) var44.x4[3]) >> 8;
    /* 6: convubw */
    var46.x4[0] = (orc_uint8) var40.x4[0];
    var46.x4[1] = (orc_uint8) var40.x4[1];
    var46.x4[2] = (orc_uint8) var40.x4[2];
    var46.x4[3] = (orc_uint8) var40.x4[3];
    /* 7: loadl */
    var47 = ptr0[i];
    /* 8: convubw */
    var48.x4[0] = (orc_uint8) var47.x4[0];
    var48.x4[1] = (orc_uint8) var47.x4[1];
    var48.x4[2] = (orc_uint8) var47.x4[2];
    var48.x4[3] = (orc_uint8) var47.x4[3];
    /* 9: subw */
    var49.x4[0] = var46.x4[0] - var48.x4[0];
    var49.x4[1] = var46.x4[1] - var48.x4[1];
    var49.x4[2] = var46.x4[2] - var48.x4[2];
    var49.x4[3] = var46.x4[3] - var48.x4[3];
    /* 10: mullw */
    var50.x4[0] = (var49.x4[0] * var45.x4[0]) & 0xffff;
    var50.x4[1] = (var49.x4[1] * var45.x4[1]) & 0xffff;
    var50.x4[2] = (var49.x4[2] * var45.x4[2]) & 0xffff;
    var50.x4[3] = (var49.x4[3] * var45.x4[3]) & 0xffff;
    /* 11: div255w */
    var51.x4[0] =
        ((orc_uint16) (((orc_uint16) (var50.x4[0] + 128)) +
            (((orc_uint16) (var50.x4[0] + 128)) >> 8))) >> 8;
    var51.x4[1] =
        ((orc_uint16) (((orc_uint16) (var50.x4[1] + 128)) +
            (((orc_uint16) (var50.x4[1] + 128)) >> 8))) >> 8;
    var51.x4[2] =
        ((orc_uint16) (((orc_uint16) (var50.x4[2] + 128)) +
            (((orc_uint16) (var50.x4[2] + 128)) >> 8))) >> 8;
    var51.x4[3] =
        ((orc_uint16) (((orc_uint16) (var50.x4[3] + 128)) +
            (((orc_uint16) (var50.x4[3] + 128)) >> 8))) >> 8;
    /* 12: addw */
    var52.x4[0] = var48.x4[0] + var51.x4[0];
    var52.x4[1] = var48.x4[1] + var51.x4[1];
    var52.x4[2] = var48.x4[2] + var51.x4[2];
    var52.x4[3] = var48.x4[3] + var51.x4[3];
    /* 13: convwb */
    var53.x4[0] = var52.x4[0];
    var53.x4[1] = var52.x4[1];
    var53.x4[2] = var52.x4[2];
    var53.x4[3] = var52.x4[3];
    /* 15: orl */
    var54.i = var53.i | var39.i;
    /* 16: storel */
    ptr0[i] = var54;
  }

}

#else
static void
_backup_video_orc_blend_little (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union32 var39;
#else
  orc_union32 var39;
#endif
  orc_union32 var40;
  orc_union16 var41;
  orc_int8 var42;
  orc_union32 var43;
  orc_union64 var44;
  orc_union64 var45;
  orc_union64 var46;
  orc_union32 var47;
  orc_union64 var48;
  orc_union64 var49;
  orc_union64 var50;
  orc_union64 var51;
  orc_union64 var52;
  orc_union32 var53;
  orc_union32 var54;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_union32 *) ex->arrays[4];

  /* 14: loadpl */
  var39.i = (int) 0x000000ff;   /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var40 = ptr4[i];
    /* 1: convlw */
    var41.i = var40.i;
    /* 2: convwb */
    var42 = var41.i;
    /* 3: splatbl */
    var43.i =
        ((var42 & 0xff) << 24) | ((var42 & 0xff) << 16) | ((var42 & 0xff) << 8)
        | (var42 & 0xff);
    /* 4: convubw */
    var44.x4[0] = (orc_uint8) var43.x4[0];
    var44.x4[1] = (orc_uint8) var43.x4[1];
    var44.x4[2] = (orc_uint8) var43.x4[2];
    var44.x4[3] = (orc_uint8) var43.x4[3];
    /* 5: shruw */
    var45.x4[0] = ((orc_uint16) var44.x4[0]) >> 8;
    var45.x4[1] = ((orc_uint16) var44.x4[1]) >> 8;
    var45.x4[2] = ((orc_uint16) var44.x4[2]) >> 8;
    var45.x4[3] = ((orc_uint16) var44.x4[3]) >> 8;
    /* 6: convubw */
    var46.x4[0] = (orc_uint8) var40.x4[0];
    var46.x4[1] = (orc_uint8) var40.x4[1];
    var46.x4[2] = (orc_uint8) var40.x4[2];
    var46.x4[3] = (orc_uint8) var40.x4[3];
    /* 7: loadl */
    var47 = ptr0[i];
    /* 8: convubw */
    var48.x4[0] = (orc_uint8) var47.x4[0];
    var48.x4[1] = (orc_uint8) var47.x4[1];
    var48.x4[2] = (orc_uint8) var47.x4[2];
    var48.x4[3] = (orc_uint8) var47.x4[3];
    /* 9: subw */
    var49.x4[0] = var46.x4[0] - var48.x4[0];
    var49.x4[1] = var46.x4[1] - var48.x4[1];
    var49.x4[2] = var46.x4[2] - var48.x4[2];
    var49.x4[3] = var46.x4[3] - var48.x4[3];
    /* 10: mullw */
    var50.x4[0] = (var49.x4[0] * var45.x4[0]) & 0xffff;
    var50.x4[1] = (var49.x4[1] * var45.x4[1]) & 0xffff;
    var50.x4[2] = (var49.x4[2] * var45.x4[2]) & 0xffff;
    var50.x4[3] = (var49.x4[3] * var45.x4[3]) & 0xffff;
    /* 11: div255w */
    var51.x4[0] =
        ((orc_uint16) (((orc_uint16) (var50.x4[0] + 128)) +
            (((orc_uint16) (var50.x4[0] + 128)) >> 8))) >> 8;
    var51.x4[1] =
        ((orc_uint16) (((orc_uint16) (var50.x4[1] + 128)) +
            (((orc_uint16) (var50.x4[1] + 128)) >> 8))) >> 8;
    var51.x4[2] =
        ((orc_uint16) (((orc_uint16) (var50.x4[2] + 128)) +
            (((orc_uint16) (var50.x4[2] + 128)) >> 8))) >> 8;
    var51.x4[3] =
        ((orc_uint16) (((orc_uint16) (var50.x4[3] + 128)) +
            (((orc_uint16) (var50.x4[3] + 128)) >> 8))) >> 8;
    /* 12: addw */
    var52.x4[0] = var48.x4[0] + var51.x4[0];
    var52.x4[1] = var48.x4[1] + var51.x4[1];
    var52.x4[2] = var48.x4[2] + var51.x4[2];
    var52.x4[3] = var48.x4[3] + var51.x4[3];
    /* 13: convwb */
    var53.x4[0] = var52.x4[0];
    var53.x4[1] = var52.x4[1];
    var53.x4[2] = var52.x4[2];
    var53.x4[3] = var52.x4[3];
    /* 15: orl */
    var54.i = var53.i | var39.i;
    /* 16: storel */
    ptr0[i] = var54;
  }

}

void
video_orc_blend_little (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 22, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 98, 108, 101,
        110, 100, 95, 108, 105, 116, 116, 108, 101, 11, 4, 4, 12, 4, 4, 14,
        4, 255, 0, 0, 0, 14, 4, 8, 0, 0, 0, 20, 4, 20, 2, 20,
        1, 20, 4, 20, 8, 20, 8, 20, 8, 113, 32, 4, 163, 33, 32, 157,
        34, 33, 152, 35, 34, 21, 2, 150, 38, 35, 21, 2, 95, 38, 38, 17,
        21, 2, 150, 37, 32, 113, 32, 0, 21, 2, 150, 36, 32, 21, 2, 98,
        37, 37, 36, 21, 2, 89, 37, 37, 38, 21, 2, 80, 37, 37, 21, 2,
        70, 36, 36, 37, 21, 2, 157, 32, 36, 123, 32, 32, 16, 128, 0, 32,
        2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_blend_little);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_blend_little");
      orc_program_set_backup_function (p, _backup_video_orc_blend_little);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 4, 0x000000ff, "c1");
      orc_program_add_constant (p, 4, 0x00000008, "c2");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 1, "t3");
      orc_program_add_temporary (p, 4, "t4");
      orc_program_add_temporary (p, 8, "t5");
      orc_program_add_temporary (p, 8, "t6");
      orc_program_add_temporary (p, 8, "t7");

      orc_program_append_2 (p, "loadl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convlw", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convwb", 0, ORC_VAR_T3, ORC_VAR_T2, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splatbl", 0, ORC_VAR_T4, ORC_VAR_T3, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 2, ORC_VAR_T7, ORC_VAR_T4, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shruw", 2, ORC_VAR_T7, ORC_VAR_T7, ORC_VAR_C2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 2, ORC_VAR_T6, ORC_VAR_T1, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "loadl", 0, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 2, ORC_VAR_T5, ORC_VAR_T1, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "subw", 2, ORC_VAR_T6, ORC_VAR_T6, ORC_VAR_T5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 2, ORC_VAR_T6, ORC_VAR_T6, ORC_VAR_T7,
          ORC_VAR_D1);
      orc_program_append_2 (p, "div255w", 2, ORC_VAR_T6, ORC_VAR_T6, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 2, ORC_VAR_T5, ORC_VAR_T5, ORC_VAR_T6,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convwb", 2, ORC_VAR_T1, ORC_VAR_T5, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "orl", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "storel", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_blend_big */
#ifdef DISABLE_ORC
void
video_orc_blend_big (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union32 var40;
#else
  orc_union32 var40;
#endif
  orc_union32 var41;
  orc_union32 var42;
  orc_union16 var43;
  orc_int8 var44;
  orc_union32 var45;
  orc_union64 var46;
  orc_union64 var47;
  orc_union64 var48;
  orc_union32 var49;
  orc_union64 var50;
  orc_union64 var51;
  orc_union64 var52;
  orc_union64 var53;
  orc_union64 var54;
  orc_union32 var55;
  orc_union32 var56;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_union32 *) s1;

  /* 15: loadpl */
  var40.i = (int) 0xff000000;   /* -16777216 or 2.11371e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var41 = ptr4[i];
    /* 1: shrul */
    var42.i = ((orc_uint32) var41.i) >> 24;
    /* 2: convlw */
    var43.i = var42.i;
    /* 3: convwb */
    var44 = var43.i;
    /* 4: splatbl */
    var45.i =
        ((var44 & 0xff) << 24) | ((var44 & 0xff) << 16) | ((var44 & 0xff) << 8)
        | (var44 & 0xff);
    /* 5: convubw */
    var46.x4[0] = (orc_uint8) var45.x4[0];
    var46.x4[1] = (orc_uint8) var45.x4[1];
    var46.x4[2] = (orc_uint8) var45.x4[2];
    var46.x4[3] = (orc_uint8) var45.x4[3];
    /* 6: shruw */
    var47.x4[0] = ((orc_uint16) var46.x4[0]) >> 8;
    var47.x4[1] = ((orc_uint16) var46.x4[1]) >> 8;
    var47.x4[2] = ((orc_uint16) var46.x4[2]) >> 8;
    var47.x4[3] = ((orc_uint16) var46.x4[3]) >> 8;
    /* 7: convubw */
    var48.x4[0] = (orc_uint8) var41.x4[0];
    var48.x4[1] = (orc_uint8) var41.x4[1];
    var48.x4[2] = (orc_uint8) var41.x4[2];
    var48.x4[3] = (orc_uint8) var41.x4[3];
    /* 8: loadl */
    var49 = ptr0[i];
    /* 9: convubw */
    var50.x4[0] = (orc_uint8) var49.x4[0];
    var50.x4[1] = (orc_uint8) var49.x4[1];
    var50.x4[2] = (orc_uint8) var49.x4[2];
    var50.x4[3] = (orc_uint8) var49.x4[3];
    /* 10: subw */
    var51.x4[0] = var48.x4[0] - var50.x4[0];
    var51.x4[1] = var48.x4[1] - var50.x4[1];
    var51.x4[2] = var48.x4[2] - var50.x4[2];
    var51.x4[3] = var48.x4[3] - var50.x4[3];
    /* 11: mullw */
    var52.x4[0] = (var51.x4[0] * var47.x4[0]) & 0xffff;
    var52.x4[1] = (var51.x4[1] * var47.x4[1]) & 0xffff;
    var52.x4[2] = (var51.x4[2] * var47.x4[2]) & 0xffff;
    var52.x4[3] = (var51.x4[3] * var47.x4[3]) & 0xffff;
    /* 12: div255w */
    var53.x4[0] =
        ((orc_uint16) (((orc_uint16) (var52.x4[0] + 128)) +
            (((orc_uint16) (var52.x4[0] + 128)) >> 8))) >> 8;
    var53.x4[1] =
        ((orc_uint16) (((orc_uint16) (var52.x4[1] + 128)) +
            (((orc_uint16) (var52.x4[1] + 128)) >> 8))) >> 8;
    var53.x4[2] =
        ((orc_uint16) (((orc_uint16) (var52.x4[2] + 128)) +
            (((orc_uint16) (var52.x4[2] + 128)) >> 8))) >> 8;
    var53.x4[3] =
        ((orc_uint16) (((orc_uint16) (var52.x4[3] + 128)) +
            (((orc_uint16) (var52.x4[3] + 128)) >> 8))) >> 8;
    /* 13: addw */
    var54.x4[0] = var50.x4[0] + var53.x4[0];
    var54.x4[1] = var50.x4[1] + var53.x4[1];
    var54.x4[2] = var50.x4[2] + var53.x4[2];
    var54.x4[3] = var50.x4[3] + var53.x4[3];
    /* 14: convwb */
    var55.x4[0] = var54.x4[0];
    var55.x4[1] = var54.x4[1];
    var55.x4[2] = var54.x4[2];
    var55.x4[3] = var54.x4[3];
    /* 16: orl */
    var56.i = var55.i | var40.i;
    /* 17: storel */
    ptr0[i] = var56;
  }

}

#else
static void
_backup_video_orc_blend_big (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union32 var40;
#else
  orc_union32 var40;
#endif
  orc_union32 var41;
  orc_union32 var42;
  orc_union16 var43;
  orc_int8 var44;
  orc_union32 var45;
  orc_union64 var46;
  orc_union64 var47;
  orc_union64 var48;
  orc_union32 var49;
  orc_union64 var50;
  orc_union64 var51;
  orc_union64 var52;
  orc_union64 var53;
  orc_union64 var54;
  orc_union32 var55;
  orc_union32 var56;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_union32 *) ex->arrays[4];

  /* 15: loadpl */
  var40.i = (int) 0xff000000;   /* -16777216 or 2.11371e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var41 = ptr4[i];
    /* 1: shrul */
    var42.i = ((orc_uint32) var41.i) >> 24;
    /* 2: convlw */
    var43.i = var42.i;
    /* 3: convwb */
    var44 = var43.i;
    /* 4: splatbl */
    var45.i =
        ((var44 & 0xff) << 24) | ((var44 & 0xff) << 16) | ((var44 & 0xff) << 8)
        | (var44 & 0xff);
    /* 5: convubw */
    var46.x4[0] = (orc_uint8) var45.x4[0];
    var46.x4[1] = (orc_uint8) var45.x4[1];
    var46.x4[2] = (orc_uint8) var45.x4[2];
    var46.x4[3] = (orc_uint8) var45.x4[3];
    /* 6: shruw */
    var47.x4[0] = ((orc_uint16) var46.x4[0]) >> 8;
    var47.x4[1] = ((orc_uint16) var46.x4[1]) >> 8;
    var47.x4[2] = ((orc_uint16) var46.x4[2]) >> 8;
    var47.x4[3] = ((orc_uint16) var46.x4[3]) >> 8;
    /* 7: convubw */
    var48.x4[0] = (orc_uint8) var41.x4[0];
    var48.x4[1] = (orc_uint8) var41.x4[1];
    var48.x4[2] = (orc_uint8) var41.x4[2];
    var48.x4[3] = (orc_uint8) var41.x4[3];
    /* 8: loadl */
    var49 = ptr0[i];
    /* 9: convubw */
    var50.x4[0] = (orc_uint8) var49.x4[0];
    var50.x4[1] = (orc_uint8) var49.x4[1];
    var50.x4[2] = (orc_uint8) var49.x4[2];
    var50.x4[3] = (orc_uint8) var49.x4[3];
    /* 10: subw */
    var51.x4[0] = var48.x4[0] - var50.x4[0];
    var51.x4[1] = var48.x4[1] - var50.x4[1];
    var51.x4[2] = var48.x4[2] - var50.x4[2];
    var51.x4[3] = var48.x4[3] - var50.x4[3];
    /* 11: mullw */
    var52.x4[0] = (var51.x4[0] * var47.x4[0]) & 0xffff;
    var52.x4[1] = (var51.x4[1] * var47.x4[1]) & 0xffff;
    var52.x4[2] = (var51.x4[2] * var47.x4[2]) & 0xffff;
    var52.x4[3] = (var51.x4[3] * var47.x4[3]) & 0xffff;
    /* 12: div255w */
    var53.x4[0] =
        ((orc_uint16) (((orc_uint16) (var52.x4[0] + 128)) +
            (((orc_uint16) (var52.x4[0] + 128)) >> 8))) >> 8;
    var53.x4[1] =
        ((orc_uint16) (((orc_uint16) (var52.x4[1] + 128)) +
            (((orc_uint16) (var52.x4[1] + 128)) >> 8))) >> 8;
    var53.x4[2] =
        ((orc_uint16) (((orc_uint16) (var52.x4[2] + 128)) +
            (((orc_uint16) (var52.x4[2] + 128)) >> 8))) >> 8;
    var53.x4[3] =
        ((orc_uint16) (((orc_uint16) (var52.x4[3] + 128)) +
            (((orc_uint16) (var52.x4[3] + 128)) >> 8))) >> 8;
    /* 13: addw */
    var54.x4[0] = var50.x4[0] + var53.x4[0];
    var54.x4[1] = var50.x4[1] + var53.x4[1];
    var54.x4[2] = var50.x4[2] + var53.x4[2];
    var54.x4[3] = var50.x4[3] + var53.x4[3];
    /* 14: convwb */
    var55.x4[0] = var54.x4[0];
    var55.x4[1] = var54.x4[1];
    var55.x4[2] = var54.x4[2];
    var55.x4[3] = var54.x4[3];
    /* 16: orl */
    var56.i = var55.i | var40.i;
    /* 17: storel */
    ptr0[i] = var56;
  }

}

void
video_orc_blend_big (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 19, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 98, 108, 101,
        110, 100, 95, 98, 105, 103, 11, 4, 4, 12, 4, 4, 14, 4, 0, 0,
        0, 255, 14, 4, 24, 0, 0, 0, 14, 4, 8, 0, 0, 0, 20, 4,
        20, 4, 20, 2, 20, 1, 20, 4, 20, 8, 20, 8, 20, 8, 113, 32,
        4, 126, 33, 32, 17, 163, 34, 33, 157, 35, 34, 152, 36, 35, 21, 2,
        150, 39, 36, 21, 2, 95, 39, 39, 18, 21, 2, 150, 38, 32, 113, 32,
        0, 21, 2, 150, 37, 32, 21, 2, 98, 38, 38, 37, 21, 2, 89, 38,
        38, 39, 21, 2, 80, 38, 38, 21, 2, 70, 37, 37, 38, 21, 2, 157,
        32, 37, 123, 32, 32, 16, 128, 0, 32, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_blend_big);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_blend_big");
      orc_program_set_backup_function (p, _backup_video_orc_blend_big);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 4, 0xff000000, "c1");
      orc_program_add_constant (p, 4, 0x00000018, "c2");
      orc_program_add_constant (p, 4, 0x00000008, "c3");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 2, "t3");
      orc_program_add_temporary (p, 1, "t4");
      orc_program_add_temporary (p, 4, "t5");
      orc_program_add_temporary (p, 8, "t6");
      orc_program_add_temporary (p, 8, "t7");
      orc_program_add_temporary (p, 8, "t8");

      orc_program_append_2 (p, "loadl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shrul", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_C2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convlw", 0, ORC_VAR_T3, ORC_VAR_T2, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convwb", 0, ORC_VAR_T4, ORC_VAR_T3, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splatbl", 0, ORC_VAR_T5, ORC_VAR_T4, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 2, ORC_VAR_T8, ORC_VAR_T5, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shruw", 2, ORC_VAR_T8, ORC_VAR_T8, ORC_VAR_C3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 2, ORC_VAR_T7, ORC_VAR_T1, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "loadl", 0, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 2, ORC_VAR_T6, ORC_VAR_T1, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "subw", 2, ORC_VAR_T7, ORC_VAR_T7, ORC_VAR_T6,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 2, ORC_VAR_T7, ORC_VAR_T7, ORC_VAR_T8,
          ORC_VAR_D1);
      orc_program_append_2 (p, "div255w", 2, ORC_VAR_T7, ORC_VAR_T7, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 2, ORC_VAR_T6, ORC_VAR_T6, ORC_VAR_T7,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convwb", 2, ORC_VAR_T1, ORC_VAR_T6, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "orl", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "storel", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_unpack_I420 */
#ifdef DISABLE_ORC
void
video_orc_unpack_I420 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
  const orc_int8 *ORC_RESTRICT ptr5;
  const orc_int8 *ORC_RESTRICT ptr6;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_int8 var36;
#else
  orc_int8 var36;
#endif
  orc_int8 var37;
  orc_union32 var38;
  orc_int8 var39;
  orc_int8 var40;
  orc_union16 var41;
  orc_union16 var42;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_int8 *) s1;
  ptr5 = (orc_int8 *) s2;
  ptr6 = (orc_int8 *) s3;

  /* 3: loadpb */
  var36 = (int) 0x000000ff;     /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadupdb */
    var39 = ptr5[i >> 1];
    /* 1: loadupdb */
    var40 = ptr6[i >> 1];
    /* 2: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var39;
      _dest.x2[1] = var40;
      var41.i = _dest.i;
    }
    /* 4: loadb */
    var37 = ptr4[i];
    /* 5: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var36;
      _dest.x2[1] = var37;
      var42.i = _dest.i;
    }
    /* 6: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var42.i;
      _dest.x2[1] = var41.i;
      var38.i = _dest.i;
    }
    /* 7: storel */
    ptr0[i] = var38;
  }

}

#else
static void
_backup_video_orc_unpack_I420 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
  const orc_int8 *ORC_RESTRICT ptr5;
  const orc_int8 *ORC_RESTRICT ptr6;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_int8 var36;
#else
  orc_int8 var36;
#endif
  orc_int8 var37;
  orc_union32 var38;
  orc_int8 var39;
  orc_int8 var40;
  orc_union16 var41;
  orc_union16 var42;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_int8 *) ex->arrays[4];
  ptr5 = (orc_int8 *) ex->arrays[5];
  ptr6 = (orc_int8 *) ex->arrays[6];

  /* 3: loadpb */
  var36 = (int) 0x000000ff;     /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadupdb */
    var39 = ptr5[i >> 1];
    /* 1: loadupdb */
    var40 = ptr6[i >> 1];
    /* 2: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var39;
      _dest.x2[1] = var40;
      var41.i = _dest.i;
    }
    /* 4: loadb */
    var37 = ptr4[i];
    /* 5: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var36;
      _dest.x2[1] = var37;
      var42.i = _dest.i;
    }
    /* 6: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var42.i;
      _dest.x2[1] = var41.i;
      var38.i = _dest.i;
    }
    /* 7: storel */
    ptr0[i] = var38;
  }

}

void
video_orc_unpack_I420 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 21, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 117, 110, 112,
        97, 99, 107, 95, 73, 52, 50, 48, 11, 4, 4, 12, 1, 1, 12, 1,
        1, 12, 1, 1, 14, 1, 255, 0, 0, 0, 20, 2, 20, 2, 20, 1,
        20, 1, 45, 34, 5, 45, 35, 6, 196, 32, 34, 35, 196, 33, 16, 4,
        195, 0, 33, 32, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_unpack_I420);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_unpack_I420");
      orc_program_set_backup_function (p, _backup_video_orc_unpack_I420);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_constant (p, 1, 0x000000ff, "c1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 1, "t3");
      orc_program_add_temporary (p, 1, "t4");

      orc_program_append_2 (p, "loadupdb", 0, ORC_VAR_T3, ORC_VAR_S2,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "loadupdb", 0, ORC_VAR_T4, ORC_VAR_S3,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T1, ORC_VAR_T3, ORC_VAR_T4,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T2, ORC_VAR_C1, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_T1,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->arrays[ORC_VAR_S2] = (void *) s2;
  ex->arrays[ORC_VAR_S3] = (void *) s3;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_pack_I420 */
#ifdef DISABLE_ORC
void
video_orc_pack_I420 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2,
    guint8 * ORC_RESTRICT d3, const guint8 * ORC_RESTRICT s1, int n)
{
  int i;
  orc_union16 *ORC_RESTRICT ptr0;
  orc_int8 *ORC_RESTRICT ptr1;
  orc_int8 *ORC_RESTRICT ptr2;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var38;
  orc_union16 var39;
  orc_int8 var40;
  orc_int8 var41;
  orc_union32 var42;
  orc_union32 var43;
  orc_union16 var44;
  orc_union16 var45;

  ptr0 = (orc_union16 *) d1;
  ptr1 = (orc_int8 *) d2;
  ptr2 = (orc_int8 *) d3;
  ptr4 = (orc_union64 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var38 = ptr4[i];
    /* 1: splitlw */
    {
      orc_union32 _src;
      _src.i = var38.x2[0];
      var42.x2[0] = _src.x2[1];
      var43.x2[0] = _src.x2[0];
    }
    {
      orc_union32 _src;
      _src.i = var38.x2[1];
      var42.x2[1] = _src.x2[1];
      var43.x2[1] = _src.x2[0];
    }
    /* 2: select1wb */
    {
      orc_union16 _src;
      _src.i = var43.x2[0];
      var39.x2[0] = _src.x2[1];
    }
    {
      orc_union16 _src;
      _src.i = var43.x2[1];
      var39.x2[1] = _src.x2[1];
    }
    /* 3: storew */
    ptr0[i] = var39;
    /* 4: splitwb */
    {
      orc_union16 _src;
      _src.i = var42.x2[0];
      var44.x2[0] = _src.x2[1];
      var45.x2[0] = _src.x2[0];
    }
    {
      orc_union16 _src;
      _src.i = var42.x2[1];
      var44.x2[1] = _src.x2[1];
      var45.x2[1] = _src.x2[0];
    }
    /* 5: select0wb */
    {
      orc_union16 _src;
      _src.i = var45.i;
      var40 = _src.x2[0];
    }
    /* 6: storeb */
    ptr1[i] = var40;
    /* 7: select0wb */
    {
      orc_union16 _src;
      _src.i = var44.i;
      var41 = _src.x2[0];
    }
    /* 8: storeb */
    ptr2[i] = var41;
  }

}

#else
static void
_backup_video_orc_pack_I420 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 *ORC_RESTRICT ptr0;
  orc_int8 *ORC_RESTRICT ptr1;
  orc_int8 *ORC_RESTRICT ptr2;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var38;
  orc_union16 var39;
  orc_int8 var40;
  orc_int8 var41;
  orc_union32 var42;
  orc_union32 var43;
  orc_union16 var44;
  orc_union16 var45;

  ptr0 = (orc_union16 *) ex->arrays[0];
  ptr1 = (orc_int8 *) ex->arrays[1];
  ptr2 = (orc_int8 *) ex->arrays[2];
  ptr4 = (orc_union64 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var38 = ptr4[i];
    /* 1: splitlw */
    {
      orc_union32 _src;
      _src.i = var38.x2[0];
      var42.x2[0] = _src.x2[1];
      var43.x2[0] = _src.x2[0];
    }
    {
      orc_union32 _src;
      _src.i = var38.x2[1];
      var42.x2[1] = _src.x2[1];
      var43.x2[1] = _src.x2[0];
    }
    /* 2: select1wb */
    {
      orc_union16 _src;
      _src.i = var43.x2[0];
      var39.x2[0] = _src.x2[1];
    }
    {
      orc_union16 _src;
      _src.i = var43.x2[1];
      var39.x2[1] = _src.x2[1];
    }
    /* 3: storew */
    ptr0[i] = var39;
    /* 4: splitwb */
    {
      orc_union16 _src;
      _src.i = var42.x2[0];
      var44.x2[0] = _src.x2[1];
      var45.x2[0] = _src.x2[0];
    }
    {
      orc_union16 _src;
      _src.i = var42.x2[1];
      var44.x2[1] = _src.x2[1];
      var45.x2[1] = _src.x2[0];
    }
    /* 5: select0wb */
    {
      orc_union16 _src;
      _src.i = var45.i;
      var40 = _src.x2[0];
    }
    /* 6: storeb */
    ptr1[i] = var40;
    /* 7: select0wb */
    {
      orc_union16 _src;
      _src.i = var44.i;
      var41 = _src.x2[0];
    }
    /* 8: storeb */
    ptr2[i] = var41;
  }

}

void
video_orc_pack_I420 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2,
    guint8 * ORC_RESTRICT d3, const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 19, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 112, 97, 99,
        107, 95, 73, 52, 50, 48, 11, 2, 2, 11, 1, 1, 11, 1, 1, 12,
        8, 8, 20, 4, 20, 4, 20, 2, 20, 2, 20, 1, 20, 1, 21, 1,
        198, 33, 32, 4, 21, 1, 189, 0, 32, 21, 1, 199, 35, 34, 33, 188,
        1, 34, 188, 2, 35, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_pack_I420);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_pack_I420");
      orc_program_set_backup_function (p, _backup_video_orc_pack_I420);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 1, "d2");
      orc_program_add_destination (p, 1, "d3");
      orc_program_add_source (p, 8, "s1");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 2, "t3");
      orc_program_add_temporary (p, 2, "t4");
      orc_program_add_temporary (p, 1, "t5");
      orc_program_add_temporary (p, 1, "t6");

      orc_program_append_2 (p, "splitlw", 1, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "select1wb", 1, ORC_VAR_D1, ORC_VAR_T1,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 1, ORC_VAR_T4, ORC_VAR_T3, ORC_VAR_T2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "select0wb", 0, ORC_VAR_D2, ORC_VAR_T3,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "select0wb", 0, ORC_VAR_D3, ORC_VAR_T4,
          ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->arrays[ORC_VAR_D3] = d3;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_unpack_YUY2 */
#ifdef DISABLE_ORC
void
video_orc_unpack_YUY2 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  int i;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var36;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var37;
#else
  orc_union16 var37;
#endif
  orc_union64 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union32 var41;
  orc_union32 var42;

  ptr0 = (orc_union64 *) d1;
  ptr4 = (orc_union32 *) s1;

  /* 2: loadpb */
  var37.x2[0] = (int) 0x000000ff;       /* 255 or 1.25987e-321f */
  var37.x2[1] = (int) 0x000000ff;       /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var36 = ptr4[i];
    /* 1: splitwb */
    {
      orc_union16 _src;
      _src.i = var36.x2[0];
      var39.x2[0] = _src.x2[1];
      var40.x2[0] = _src.x2[0];
    }
    {
      orc_union16 _src;
      _src.i = var36.x2[1];
      var39.x2[1] = _src.x2[1];
      var40.x2[1] = _src.x2[0];
    }
    /* 3: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var37.x2[0];
      _dest.x2[1] = var40.x2[0];
      var41.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var37.x2[1];
      _dest.x2[1] = var40.x2[1];
      var41.x2[1] = _dest.i;
    }
    /* 4: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var39.i;
      _dest.x2[1] = var39.i;
      var42.i = _dest.i;
    }
    /* 5: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var41.x2[0];
      _dest.x2[1] = var42.x2[0];
      var38.x2[0] = _dest.i;
    }
    {
      orc_union32 _dest;
      _dest.x2[0] = var41.x2[1];
      _dest.x2[1] = var42.x2[1];
      var38.x2[1] = _dest.i;
    }
    /* 6: storeq */
    ptr0[i] = var38;
  }

}

#else
static void
_backup_video_orc_unpack_YUY2 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var36;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var37;
#else
  orc_union16 var37;
#endif
  orc_union64 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union32 var41;
  orc_union32 var42;

  ptr0 = (orc_union64 *) ex->arrays[0];
  ptr4 = (orc_union32 *) ex->arrays[4];

  /* 2: loadpb */
  var37.x2[0] = (int) 0x000000ff;       /* 255 or 1.25987e-321f */
  var37.x2[1] = (int) 0x000000ff;       /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var36 = ptr4[i];
    /* 1: splitwb */
    {
      orc_union16 _src;
      _src.i = var36.x2[0];
      var39.x2[0] = _src.x2[1];
      var40.x2[0] = _src.x2[0];
    }
    {
      orc_union16 _src;
      _src.i = var36.x2[1];
      var39.x2[1] = _src.x2[1];
      var40.x2[1] = _src.x2[0];
    }
    /* 3: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var37.x2[0];
      _dest.x2[1] = var40.x2[0];
      var41.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var37.x2[1];
      _dest.x2[1] = var40.x2[1];
      var41.x2[1] = _dest.i;
    }
    /* 4: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var39.i;
      _dest.x2[1] = var39.i;
      var42.i = _dest.i;
    }
    /* 5: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var41.x2[0];
      _dest.x2[1] = var42.x2[0];
      var38.x2[0] = _dest.i;
    }
    {
      orc_union32 _dest;
      _dest.x2[0] = var41.x2[1];
      _dest.x2[1] = var42.x2[1];
      var38.x2[1] = _dest.i;
    }
    /* 6: storeq */
    ptr0[i] = var38;
  }

}

void
video_orc_unpack_YUY2 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 21, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 117, 110, 112,
        97, 99, 107, 95, 89, 85, 89, 50, 11, 8, 8, 12, 4, 4, 14, 2,
        255, 0, 0, 0, 20, 2, 20, 2, 20, 4, 20, 4, 21, 1, 199, 33,
        32, 4, 21, 1, 196, 34, 16, 32, 195, 35, 33, 33, 21, 1, 195, 0,
        34, 35, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_unpack_YUY2);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_unpack_YUY2");
      orc_program_set_backup_function (p, _backup_video_orc_unpack_YUY2);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 2, 0x000000ff, "c1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 4, "t3");
      orc_program_add_temporary (p, 4, "t4");

      orc_program_append_2 (p, "splitwb", 1, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_T3, ORC_VAR_C1, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T4, ORC_VAR_T2, ORC_VAR_T2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 1, ORC_VAR_D1, ORC_VAR_T3, ORC_VAR_T4,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_pack_YUY2 */
#ifdef DISABLE_ORC
void
video_orc_pack_YUY2 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var36;
  orc_union32 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union16 var40;
  orc_union16 var41;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_union64 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var36 = ptr4[i];
    /* 1: splitlw */
    {
      orc_union32 _src;
      _src.i = var36.x2[0];
      var38.x2[0] = _src.x2[1];
      var39.x2[0] = _src.x2[0];
    }
    {
      orc_union32 _src;
      _src.i = var36.x2[1];
      var38.x2[1] = _src.x2[1];
      var39.x2[1] = _src.x2[0];
    }
    /* 2: select0lw */
    {
      orc_union32 _src;
      _src.i = var38.i;
      var40.i = _src.x2[0];
    }
    /* 3: select1wb */
    {
      orc_union16 _src;
      _src.i = var39.x2[0];
      var41.x2[0] = _src.x2[1];
    }
    {
      orc_union16 _src;
      _src.i = var39.x2[1];
      var41.x2[1] = _src.x2[1];
    }
    /* 4: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var41.x2[0];
      _dest.x2[1] = var40.x2[0];
      var37.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var41.x2[1];
      _dest.x2[1] = var40.x2[1];
      var37.x2[1] = _dest.i;
    }
    /* 5: storel */
    ptr0[i] = var37;
  }

}

#else
static void
_backup_video_orc_pack_YUY2 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var36;
  orc_union32 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union16 var40;
  orc_union16 var41;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_union64 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var36 = ptr4[i];
    /* 1: splitlw */
    {
      orc_union32 _src;
      _src.i = var36.x2[0];
      var38.x2[0] = _src.x2[1];
      var39.x2[0] = _src.x2[0];
    }
    {
      orc_union32 _src;
      _src.i = var36.x2[1];
      var38.x2[1] = _src.x2[1];
      var39.x2[1] = _src.x2[0];
    }
    /* 2: select0lw */
    {
      orc_union32 _src;
      _src.i = var38.i;
      var40.i = _src.x2[0];
    }
    /* 3: select1wb */
    {
      orc_union16 _src;
      _src.i = var39.x2[0];
      var41.x2[0] = _src.x2[1];
    }
    {
      orc_union16 _src;
      _src.i = var39.x2[1];
      var41.x2[1] = _src.x2[1];
    }
    /* 4: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var41.x2[0];
      _dest.x2[1] = var40.x2[0];
      var37.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var41.x2[1];
      _dest.x2[1] = var40.x2[1];
      var37.x2[1] = _dest.i;
    }
    /* 5: storel */
    ptr0[i] = var37;
  }

}

void
video_orc_pack_YUY2 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 19, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 112, 97, 99,
        107, 95, 89, 85, 89, 50, 11, 4, 4, 12, 8, 8, 20, 2, 20, 2,
        20, 4, 20, 4, 21, 1, 198, 35, 34, 4, 190, 33, 35, 21, 1, 189,
        32, 34, 21, 1, 196, 0, 32, 33, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_pack_YUY2);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_pack_YUY2");
      orc_program_set_backup_function (p, _backup_video_orc_pack_YUY2);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 8, "s1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 4, "t3");
      orc_program_add_temporary (p, 4, "t4");

      orc_program_append_2 (p, "splitlw", 1, ORC_VAR_T4, ORC_VAR_T3, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "select0lw", 0, ORC_VAR_T2, ORC_VAR_T4,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "select1wb", 1, ORC_VAR_T1, ORC_VAR_T3,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_pack_UYVY */
#ifdef DISABLE_ORC
void
video_orc_pack_UYVY (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var36;
  orc_union32 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union16 var40;
  orc_union16 var41;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_union64 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var36 = ptr4[i];
    /* 1: splitlw */
    {
      orc_union32 _src;
      _src.i = var36.x2[0];
      var38.x2[0] = _src.x2[1];
      var39.x2[0] = _src.x2[0];
    }
    {
      orc_union32 _src;
      _src.i = var36.x2[1];
      var38.x2[1] = _src.x2[1];
      var39.x2[1] = _src.x2[0];
    }
    /* 2: select0lw */
    {
      orc_union32 _src;
      _src.i = var38.i;
      var40.i = _src.x2[0];
    }
    /* 3: select1wb */
    {
      orc_union16 _src;
      _src.i = var39.x2[0];
      var41.x2[0] = _src.x2[1];
    }
    {
      orc_union16 _src;
      _src.i = var39.x2[1];
      var41.x2[1] = _src.x2[1];
    }
    /* 4: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var40.x2[0];
      _dest.x2[1] = var41.x2[0];
      var37.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var40.x2[1];
      _dest.x2[1] = var41.x2[1];
      var37.x2[1] = _dest.i;
    }
    /* 5: storel */
    ptr0[i] = var37;
  }

}

#else
static void
_backup_video_orc_pack_UYVY (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var36;
  orc_union32 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union16 var40;
  orc_union16 var41;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_union64 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var36 = ptr4[i];
    /* 1: splitlw */
    {
      orc_union32 _src;
      _src.i = var36.x2[0];
      var38.x2[0] = _src.x2[1];
      var39.x2[0] = _src.x2[0];
    }
    {
      orc_union32 _src;
      _src.i = var36.x2[1];
      var38.x2[1] = _src.x2[1];
      var39.x2[1] = _src.x2[0];
    }
    /* 2: select0lw */
    {
      orc_union32 _src;
      _src.i = var38.i;
      var40.i = _src.x2[0];
    }
    /* 3: select1wb */
    {
      orc_union16 _src;
      _src.i = var39.x2[0];
      var41.x2[0] = _src.x2[1];
    }
    {
      orc_union16 _src;
      _src.i = var39.x2[1];
      var41.x2[1] = _src.x2[1];
    }
    /* 4: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var40.x2[0];
      _dest.x2[1] = var41.x2[0];
      var37.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var40.x2[1];
      _dest.x2[1] = var41.x2[1];
      var37.x2[1] = _dest.i;
    }
    /* 5: storel */
    ptr0[i] = var37;
  }

}

void
video_orc_pack_UYVY (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 19, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 112, 97, 99,
        107, 95, 85, 89, 86, 89, 11, 4, 4, 12, 8, 8, 20, 2, 20, 2,
        20, 4, 20, 4, 21, 1, 198, 35, 34, 4, 190, 33, 35, 21, 1, 189,
        32, 34, 21, 1, 196, 0, 33, 32, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_pack_UYVY);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_pack_UYVY");
      orc_program_set_backup_function (p, _backup_video_orc_pack_UYVY);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 8, "s1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 4, "t3");
      orc_program_add_temporary (p, 4, "t4");

      orc_program_append_2 (p, "splitlw", 1, ORC_VAR_T4, ORC_VAR_T3, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "select0lw", 0, ORC_VAR_T2, ORC_VAR_T4,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "select1wb", 1, ORC_VAR_T1, ORC_VAR_T3,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_T1,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_unpack_UYVY */
#ifdef DISABLE_ORC
void
video_orc_unpack_UYVY (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  int i;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var36;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var37;
#else
  orc_union16 var37;
#endif
  orc_union64 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union32 var41;
  orc_union32 var42;

  ptr0 = (orc_union64 *) d1;
  ptr4 = (orc_union32 *) s1;

  /* 2: loadpb */
  var37.x2[0] = (int) 0x000000ff;       /* 255 or 1.25987e-321f */
  var37.x2[1] = (int) 0x000000ff;       /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var36 = ptr4[i];
    /* 1: splitwb */
    {
      orc_union16 _src;
      _src.i = var36.x2[0];
      var39.x2[0] = _src.x2[1];
      var40.x2[0] = _src.x2[0];
    }
    {
      orc_union16 _src;
      _src.i = var36.x2[1];
      var39.x2[1] = _src.x2[1];
      var40.x2[1] = _src.x2[0];
    }
    /* 3: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var37.x2[0];
      _dest.x2[1] = var39.x2[0];
      var41.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var37.x2[1];
      _dest.x2[1] = var39.x2[1];
      var41.x2[1] = _dest.i;
    }
    /* 4: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var40.i;
      _dest.x2[1] = var40.i;
      var42.i = _dest.i;
    }
    /* 5: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var41.x2[0];
      _dest.x2[1] = var42.x2[0];
      var38.x2[0] = _dest.i;
    }
    {
      orc_union32 _dest;
      _dest.x2[0] = var41.x2[1];
      _dest.x2[1] = var42.x2[1];
      var38.x2[1] = _dest.i;
    }
    /* 6: storeq */
    ptr0[i] = var38;
  }

}

#else
static void
_backup_video_orc_unpack_UYVY (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var36;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var37;
#else
  orc_union16 var37;
#endif
  orc_union64 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union32 var41;
  orc_union32 var42;

  ptr0 = (orc_union64 *) ex->arrays[0];
  ptr4 = (orc_union32 *) ex->arrays[4];

  /* 2: loadpb */
  var37.x2[0] = (int) 0x000000ff;       /* 255 or 1.25987e-321f */
  var37.x2[1] = (int) 0x000000ff;       /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var36 = ptr4[i];
    /* 1: splitwb */
    {
      orc_union16 _src;
      _src.i = var36.x2[0];
      var39.x2[0] = _src.x2[1];
      var40.x2[0] = _src.x2[0];
    }
    {
      orc_union16 _src;
      _src.i = var36.x2[1];
      var39.x2[1] = _src.x2[1];
      var40.x2[1] = _src.x2[0];
    }
    /* 3: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var37.x2[0];
      _dest.x2[1] = var39.x2[0];
      var41.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var37.x2[1];
      _dest.x2[1] = var39.x2[1];
      var41.x2[1] = _dest.i;
    }
    /* 4: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var40.i;
      _dest.x2[1] = var40.i;
      var42.i = _dest.i;
    }
    /* 5: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var41.x2[0];
      _dest.x2[1] = var42.x2[0];
      var38.x2[0] = _dest.i;
    }
    {
      orc_union32 _dest;
      _dest.x2[0] = var41.x2[1];
      _dest.x2[1] = var42.x2[1];
      var38.x2[1] = _dest.i;
    }
    /* 6: storeq */
    ptr0[i] = var38;
  }

}

void
video_orc_unpack_UYVY (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 21, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 117, 110, 112,
        97, 99, 107, 95, 85, 89, 86, 89, 11, 8, 8, 12, 4, 4, 14, 2,
        255, 0, 0, 0, 20, 2, 20, 2, 20, 4, 20, 4, 21, 1, 199, 32,
        33, 4, 21, 1, 196, 34, 16, 32, 195, 35, 33, 33, 21, 1, 195, 0,
        34, 35, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_unpack_UYVY);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_unpack_UYVY");
      orc_program_set_backup_function (p, _backup_video_orc_unpack_UYVY);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 2, 0x000000ff, "c1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 4, "t3");
      orc_program_add_temporary (p, 4, "t4");

      orc_program_append_2 (p, "splitwb", 1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_T3, ORC_VAR_C1, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T4, ORC_VAR_T2, ORC_VAR_T2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 1, ORC_VAR_D1, ORC_VAR_T3, ORC_VAR_T4,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_unpack_YVYU */
#ifdef DISABLE_ORC
void
video_orc_unpack_YVYU (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  int i;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var36;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var37;
#else
  orc_union16 var37;
#endif
  orc_union64 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union32 var42;
  orc_union32 var43;

  ptr0 = (orc_union64 *) d1;
  ptr4 = (orc_union32 *) s1;

  /* 3: loadpb */
  var37.x2[0] = (int) 0x000000ff;       /* 255 or 1.25987e-321f */
  var37.x2[1] = (int) 0x000000ff;       /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var36 = ptr4[i];
    /* 1: splitwb */
    {
      orc_union16 _src;
      _src.i = var36.x2[0];
      var39.x2[0] = _src.x2[1];
      var40.x2[0] = _src.x2[0];
    }
    {
      orc_union16 _src;
      _src.i = var36.x2[1];
      var39.x2[1] = _src.x2[1];
      var40.x2[1] = _src.x2[0];
    }
    /* 2: swapw */
    var41.i = ORC_SWAP_W (var39.i);
    /* 4: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var37.x2[0];
      _dest.x2[1] = var40.x2[0];
      var42.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var37.x2[1];
      _dest.x2[1] = var40.x2[1];
      var42.x2[1] = _dest.i;
    }
    /* 5: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var41.i;
      _dest.x2[1] = var41.i;
      var43.i = _dest.i;
    }
    /* 6: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var42.x2[0];
      _dest.x2[1] = var43.x2[0];
      var38.x2[0] = _dest.i;
    }
    {
      orc_union32 _dest;
      _dest.x2[0] = var42.x2[1];
      _dest.x2[1] = var43.x2[1];
      var38.x2[1] = _dest.i;
    }
    /* 7: storeq */
    ptr0[i] = var38;
  }

}

#else
static void
_backup_video_orc_unpack_YVYU (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var36;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var37;
#else
  orc_union16 var37;
#endif
  orc_union64 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union32 var42;
  orc_union32 var43;

  ptr0 = (orc_union64 *) ex->arrays[0];
  ptr4 = (orc_union32 *) ex->arrays[4];

  /* 3: loadpb */
  var37.x2[0] = (int) 0x000000ff;       /* 255 or 1.25987e-321f */
  var37.x2[1] = (int) 0x000000ff;       /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var36 = ptr4[i];
    /* 1: splitwb */
    {
      orc_union16 _src;
      _src.i = var36.x2[0];
      var39.x2[0] = _src.x2[1];
      var40.x2[0] = _src.x2[0];
    }
    {
      orc_union16 _src;
      _src.i = var36.x2[1];
      var39.x2[1] = _src.x2[1];
      var40.x2[1] = _src.x2[0];
    }
    /* 2: swapw */
    var41.i = ORC_SWAP_W (var39.i);
    /* 4: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var37.x2[0];
      _dest.x2[1] = var40.x2[0];
      var42.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var37.x2[1];
      _dest.x2[1] = var40.x2[1];
      var42.x2[1] = _dest.i;
    }
    /* 5: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var41.i;
      _dest.x2[1] = var41.i;
      var43.i = _dest.i;
    }
    /* 6: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var42.x2[0];
      _dest.x2[1] = var43.x2[0];
      var38.x2[0] = _dest.i;
    }
    {
      orc_union32 _dest;
      _dest.x2[0] = var42.x2[1];
      _dest.x2[1] = var43.x2[1];
      var38.x2[1] = _dest.i;
    }
    /* 7: storeq */
    ptr0[i] = var38;
  }

}

void
video_orc_unpack_YVYU (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 21, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 117, 110, 112,
        97, 99, 107, 95, 89, 86, 89, 85, 11, 8, 8, 12, 4, 4, 14, 2,
        255, 0, 0, 0, 20, 2, 20, 2, 20, 4, 20, 4, 21, 1, 199, 33,
        32, 4, 183, 33, 33, 21, 1, 196, 34, 16, 32, 195, 35, 33, 33, 21,
        1, 195, 0, 34, 35, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_unpack_YVYU);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_unpack_YVYU");
      orc_program_set_backup_function (p, _backup_video_orc_unpack_YVYU);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 2, 0x000000ff, "c1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 4, "t3");
      orc_program_add_temporary (p, 4, "t4");

      orc_program_append_2 (p, "splitwb", 1, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "swapw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_T3, ORC_VAR_C1, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T4, ORC_VAR_T2, ORC_VAR_T2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 1, ORC_VAR_D1, ORC_VAR_T3, ORC_VAR_T4,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_pack_YVYU */
#ifdef DISABLE_ORC
void
video_orc_pack_YVYU (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var36;
  orc_union32 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_union64 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var36 = ptr4[i];
    /* 1: splitlw */
    {
      orc_union32 _src;
      _src.i = var36.x2[0];
      var38.x2[0] = _src.x2[1];
      var39.x2[0] = _src.x2[0];
    }
    {
      orc_union32 _src;
      _src.i = var36.x2[1];
      var38.x2[1] = _src.x2[1];
      var39.x2[1] = _src.x2[0];
    }
    /* 2: select0lw */
    {
      orc_union32 _src;
      _src.i = var38.i;
      var40.i = _src.x2[0];
    }
    /* 3: select1wb */
    {
      orc_union16 _src;
      _src.i = var39.x2[0];
      var41.x2[0] = _src.x2[1];
    }
    {
      orc_union16 _src;
      _src.i = var39.x2[1];
      var41.x2[1] = _src.x2[1];
    }
    /* 4: swapw */
    var42.i = ORC_SWAP_W (var40.i);
    /* 5: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var41.x2[0];
      _dest.x2[1] = var42.x2[0];
      var37.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var41.x2[1];
      _dest.x2[1] = var42.x2[1];
      var37.x2[1] = _dest.i;
    }
    /* 6: storel */
    ptr0[i] = var37;
  }

}

#else
static void
_backup_video_orc_pack_YVYU (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var36;
  orc_union32 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_union64 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var36 = ptr4[i];
    /* 1: splitlw */
    {
      orc_union32 _src;
      _src.i = var36.x2[0];
      var38.x2[0] = _src.x2[1];
      var39.x2[0] = _src.x2[0];
    }
    {
      orc_union32 _src;
      _src.i = var36.x2[1];
      var38.x2[1] = _src.x2[1];
      var39.x2[1] = _src.x2[0];
    }
    /* 2: select0lw */
    {
      orc_union32 _src;
      _src.i = var38.i;
      var40.i = _src.x2[0];
    }
    /* 3: select1wb */
    {
      orc_union16 _src;
      _src.i = var39.x2[0];
      var41.x2[0] = _src.x2[1];
    }
    {
      orc_union16 _src;
      _src.i = var39.x2[1];
      var41.x2[1] = _src.x2[1];
    }
    /* 4: swapw */
    var42.i = ORC_SWAP_W (var40.i);
    /* 5: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var41.x2[0];
      _dest.x2[1] = var42.x2[0];
      var37.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var41.x2[1];
      _dest.x2[1] = var42.x2[1];
      var37.x2[1] = _dest.i;
    }
    /* 6: storel */
    ptr0[i] = var37;
  }

}

void
video_orc_pack_YVYU (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 19, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 112, 97, 99,
        107, 95, 89, 86, 89, 85, 11, 4, 4, 12, 8, 8, 20, 2, 20, 2,
        20, 4, 20, 4, 21, 1, 198, 35, 34, 4, 190, 33, 35, 21, 1, 189,
        32, 34, 183, 33, 33, 21, 1, 196, 0, 32, 33, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_pack_YVYU);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_pack_YVYU");
      orc_program_set_backup_function (p, _backup_video_orc_pack_YVYU);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 8, "s1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 4, "t3");
      orc_program_add_temporary (p, 4, "t4");

      orc_program_append_2 (p, "splitlw", 1, ORC_VAR_T4, ORC_VAR_T3, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "select0lw", 0, ORC_VAR_T2, ORC_VAR_T4,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "select1wb", 1, ORC_VAR_T1, ORC_VAR_T3,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "swapw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_unpack_YUV9 */
#ifdef DISABLE_ORC
void
video_orc_unpack_YUV9 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, int n)
{
  int i;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_int8 *ORC_RESTRICT ptr5;
  const orc_int8 *ORC_RESTRICT ptr6;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var37;
#else
  orc_union16 var37;
#endif
  orc_union16 var38;
  orc_union64 var39;
  orc_int8 var40;
  orc_int8 var41;
  orc_union16 var42;
  orc_union32 var43;
  orc_union32 var44;

  ptr0 = (orc_union64 *) d1;
  ptr4 = (orc_union16 *) s1;
  ptr5 = (orc_int8 *) s2;
  ptr6 = (orc_int8 *) s3;

  /* 4: loadpb */
  var37.x2[0] = (int) 0x000000ff;       /* 255 or 1.25987e-321f */
  var37.x2[1] = (int) 0x000000ff;       /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadupdb */
    var40 = ptr5[i >> 1];
    /* 1: loadupdb */
    var41 = ptr6[i >> 1];
    /* 2: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var40;
      _dest.x2[1] = var41;
      var42.i = _dest.i;
    }
    /* 3: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var42.i;
      _dest.x2[1] = var42.i;
      var43.i = _dest.i;
    }
    /* 5: loadw */
    var38 = ptr4[i];
    /* 6: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var37.x2[0];
      _dest.x2[1] = var38.x2[0];
      var44.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var37.x2[1];
      _dest.x2[1] = var38.x2[1];
      var44.x2[1] = _dest.i;
    }
    /* 7: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var44.x2[0];
      _dest.x2[1] = var43.x2[0];
      var39.x2[0] = _dest.i;
    }
    {
      orc_union32 _dest;
      _dest.x2[0] = var44.x2[1];
      _dest.x2[1] = var43.x2[1];
      var39.x2[1] = _dest.i;
    }
    /* 8: storeq */
    ptr0[i] = var39;
  }

}

#else
static void
_backup_video_orc_unpack_YUV9 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_int8 *ORC_RESTRICT ptr5;
  const orc_int8 *ORC_RESTRICT ptr6;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var37;
#else
  orc_union16 var37;
#endif
  orc_union16 var38;
  orc_union64 var39;
  orc_int8 var40;
  orc_int8 var41;
  orc_union16 var42;
  orc_union32 var43;
  orc_union32 var44;

  ptr0 = (orc_union64 *) ex->arrays[0];
  ptr4 = (orc_union16 *) ex->arrays[4];
  ptr5 = (orc_int8 *) ex->arrays[5];
  ptr6 = (orc_int8 *) ex->arrays[6];

  /* 4: loadpb */
  var37.x2[0] = (int) 0x000000ff;       /* 255 or 1.25987e-321f */
  var37.x2[1] = (int) 0x000000ff;       /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadupdb */
    var40 = ptr5[i >> 1];
    /* 1: loadupdb */
    var41 = ptr6[i >> 1];
    /* 2: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var40;
      _dest.x2[1] = var41;
      var42.i = _dest.i;
    }
    /* 3: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var42.i;
      _dest.x2[1] = var42.i;
      var43.i = _dest.i;
    }
    /* 5: loadw */
    var38 = ptr4[i];
    /* 6: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var37.x2[0];
      _dest.x2[1] = var38.x2[0];
      var44.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var37.x2[1];
      _dest.x2[1] = var38.x2[1];
      var44.x2[1] = _dest.i;
    }
    /* 7: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var44.x2[0];
      _dest.x2[1] = var43.x2[0];
      var39.x2[0] = _dest.i;
    }
    {
      orc_union32 _dest;
      _dest.x2[0] = var44.x2[1];
      _dest.x2[1] = var43.x2[1];
      var39.x2[1] = _dest.i;
    }
    /* 8: storeq */
    ptr0[i] = var39;
  }

}

void
video_orc_unpack_YUV9 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 21, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 117, 110, 112,
        97, 99, 107, 95, 89, 85, 86, 57, 11, 8, 8, 12, 2, 2, 12, 1,
        1, 12, 1, 1, 14, 1, 255, 0, 0, 0, 20, 2, 20, 4, 20, 4,
        20, 1, 20, 1, 45, 35, 5, 45, 36, 6, 196, 32, 35, 36, 195, 34,
        32, 32, 21, 1, 196, 33, 16, 4, 21, 1, 195, 0, 33, 34, 2, 0,

      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_unpack_YUV9);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_unpack_YUV9");
      orc_program_set_backup_function (p, _backup_video_orc_unpack_YUV9);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_constant (p, 1, 0x000000ff, "c1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 4, "t3");
      orc_program_add_temporary (p, 1, "t4");
      orc_program_add_temporary (p, 1, "t5");

      orc_program_append_2 (p, "loadupdb", 0, ORC_VAR_T4, ORC_VAR_S2,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "loadupdb", 0, ORC_VAR_T5, ORC_VAR_S3,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T1, ORC_VAR_T4, ORC_VAR_T5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_T2, ORC_VAR_C1, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 1, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_T3,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->arrays[ORC_VAR_S2] = (void *) s2;
  ex->arrays[ORC_VAR_S3] = (void *) s3;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_unpack_Y42B */
#ifdef DISABLE_ORC
void
video_orc_unpack_Y42B (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, int n)
{
  int i;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_int8 *ORC_RESTRICT ptr5;
  const orc_int8 *ORC_RESTRICT ptr6;
  orc_int8 var36;
  orc_int8 var37;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var38;
#else
  orc_union16 var38;
#endif
  orc_union16 var39;
  orc_union64 var40;
  orc_union16 var41;
  orc_union32 var42;
  orc_union32 var43;

  ptr0 = (orc_union64 *) d1;
  ptr4 = (orc_union16 *) s1;
  ptr5 = (orc_int8 *) s2;
  ptr6 = (orc_int8 *) s3;

  /* 3: loadpb */
  var38.x2[0] = (int) 0x000000ff;       /* 255 or 1.25987e-321f */
  var38.x2[1] = (int) 0x000000ff;       /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var36 = ptr5[i];
    /* 1: loadb */
    var37 = ptr6[i];
    /* 2: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var36;
      _dest.x2[1] = var37;
      var41.i = _dest.i;
    }
    /* 4: loadw */
    var39 = ptr4[i];
    /* 5: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var38.x2[0];
      _dest.x2[1] = var39.x2[0];
      var42.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var38.x2[1];
      _dest.x2[1] = var39.x2[1];
      var42.x2[1] = _dest.i;
    }
    /* 6: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var41.i;
      _dest.x2[1] = var41.i;
      var43.i = _dest.i;
    }
    /* 7: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var42.x2[0];
      _dest.x2[1] = var43.x2[0];
      var40.x2[0] = _dest.i;
    }
    {
      orc_union32 _dest;
      _dest.x2[0] = var42.x2[1];
      _dest.x2[1] = var43.x2[1];
      var40.x2[1] = _dest.i;
    }
    /* 8: storeq */
    ptr0[i] = var40;
  }

}

#else
static void
_backup_video_orc_unpack_Y42B (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_int8 *ORC_RESTRICT ptr5;
  const orc_int8 *ORC_RESTRICT ptr6;
  orc_int8 var36;
  orc_int8 var37;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var38;
#else
  orc_union16 var38;
#endif
  orc_union16 var39;
  orc_union64 var40;
  orc_union16 var41;
  orc_union32 var42;
  orc_union32 var43;

  ptr0 = (orc_union64 *) ex->arrays[0];
  ptr4 = (orc_union16 *) ex->arrays[4];
  ptr5 = (orc_int8 *) ex->arrays[5];
  ptr6 = (orc_int8 *) ex->arrays[6];

  /* 3: loadpb */
  var38.x2[0] = (int) 0x000000ff;       /* 255 or 1.25987e-321f */
  var38.x2[1] = (int) 0x000000ff;       /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var36 = ptr5[i];
    /* 1: loadb */
    var37 = ptr6[i];
    /* 2: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var36;
      _dest.x2[1] = var37;
      var41.i = _dest.i;
    }
    /* 4: loadw */
    var39 = ptr4[i];
    /* 5: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var38.x2[0];
      _dest.x2[1] = var39.x2[0];
      var42.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var38.x2[1];
      _dest.x2[1] = var39.x2[1];
      var42.x2[1] = _dest.i;
    }
    /* 6: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var41.i;
      _dest.x2[1] = var41.i;
      var43.i = _dest.i;
    }
    /* 7: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var42.x2[0];
      _dest.x2[1] = var43.x2[0];
      var40.x2[0] = _dest.i;
    }
    {
      orc_union32 _dest;
      _dest.x2[0] = var42.x2[1];
      _dest.x2[1] = var43.x2[1];
      var40.x2[1] = _dest.i;
    }
    /* 8: storeq */
    ptr0[i] = var40;
  }

}

void
video_orc_unpack_Y42B (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 21, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 117, 110, 112,
        97, 99, 107, 95, 89, 52, 50, 66, 11, 8, 8, 12, 2, 2, 12, 1,
        1, 12, 1, 1, 14, 1, 255, 0, 0, 0, 20, 2, 20, 2, 20, 4,
        20, 4, 196, 32, 5, 6, 21, 1, 196, 35, 16, 4, 195, 34, 32, 32,
        21, 1, 195, 0, 35, 34, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_unpack_Y42B);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_unpack_Y42B");
      orc_program_set_backup_function (p, _backup_video_orc_unpack_Y42B);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_constant (p, 1, 0x000000ff, "c1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 4, "t3");
      orc_program_add_temporary (p, 4, "t4");

      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_S3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_T4, ORC_VAR_C1, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 1, ORC_VAR_D1, ORC_VAR_T4, ORC_VAR_T3,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->arrays[ORC_VAR_S2] = (void *) s2;
  ex->arrays[ORC_VAR_S3] = (void *) s3;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_pack_Y42B */
#ifdef DISABLE_ORC
void
video_orc_pack_Y42B (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2,
    guint8 * ORC_RESTRICT d3, const guint8 * ORC_RESTRICT s1, int n)
{
  int i;
  orc_union16 *ORC_RESTRICT ptr0;
  orc_int8 *ORC_RESTRICT ptr1;
  orc_int8 *ORC_RESTRICT ptr2;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var35;
  orc_int8 var36;
  orc_int8 var37;
  orc_union16 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union16 var41;

  ptr0 = (orc_union16 *) d1;
  ptr1 = (orc_int8 *) d2;
  ptr2 = (orc_int8 *) d3;
  ptr4 = (orc_union64 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var35 = ptr4[i];
    /* 1: splitlw */
    {
      orc_union32 _src;
      _src.i = var35.x2[0];
      var39.x2[0] = _src.x2[1];
      var40.x2[0] = _src.x2[0];
    }
    {
      orc_union32 _src;
      _src.i = var35.x2[1];
      var39.x2[1] = _src.x2[1];
      var40.x2[1] = _src.x2[0];
    }
    /* 2: select0lw */
    {
      orc_union32 _src;
      _src.i = var39.i;
      var41.i = _src.x2[0];
    }
    /* 3: splitwb */
    {
      orc_union16 _src;
      _src.i = var41.i;
      var36 = _src.x2[1];
      var37 = _src.x2[0];
    }
    /* 4: storeb */
    ptr2[i] = var36;
    /* 5: storeb */
    ptr1[i] = var37;
    /* 6: select1wb */
    {
      orc_union16 _src;
      _src.i = var40.x2[0];
      var38.x2[0] = _src.x2[1];
    }
    {
      orc_union16 _src;
      _src.i = var40.x2[1];
      var38.x2[1] = _src.x2[1];
    }
    /* 7: storew */
    ptr0[i] = var38;
  }

}

#else
static void
_backup_video_orc_pack_Y42B (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 *ORC_RESTRICT ptr0;
  orc_int8 *ORC_RESTRICT ptr1;
  orc_int8 *ORC_RESTRICT ptr2;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var35;
  orc_int8 var36;
  orc_int8 var37;
  orc_union16 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union16 var41;

  ptr0 = (orc_union16 *) ex->arrays[0];
  ptr1 = (orc_int8 *) ex->arrays[1];
  ptr2 = (orc_int8 *) ex->arrays[2];
  ptr4 = (orc_union64 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var35 = ptr4[i];
    /* 1: splitlw */
    {
      orc_union32 _src;
      _src.i = var35.x2[0];
      var39.x2[0] = _src.x2[1];
      var40.x2[0] = _src.x2[0];
    }
    {
      orc_union32 _src;
      _src.i = var35.x2[1];
      var39.x2[1] = _src.x2[1];
      var40.x2[1] = _src.x2[0];
    }
    /* 2: select0lw */
    {
      orc_union32 _src;
      _src.i = var39.i;
      var41.i = _src.x2[0];
    }
    /* 3: splitwb */
    {
      orc_union16 _src;
      _src.i = var41.i;
      var36 = _src.x2[1];
      var37 = _src.x2[0];
    }
    /* 4: storeb */
    ptr2[i] = var36;
    /* 5: storeb */
    ptr1[i] = var37;
    /* 6: select1wb */
    {
      orc_union16 _src;
      _src.i = var40.x2[0];
      var38.x2[0] = _src.x2[1];
    }
    {
      orc_union16 _src;
      _src.i = var40.x2[1];
      var38.x2[1] = _src.x2[1];
    }
    /* 7: storew */
    ptr0[i] = var38;
  }

}

void
video_orc_pack_Y42B (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2,
    guint8 * ORC_RESTRICT d3, const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 19, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 112, 97, 99,
        107, 95, 89, 52, 50, 66, 11, 2, 2, 11, 1, 1, 11, 1, 1, 12,
        8, 8, 20, 4, 20, 4, 20, 2, 21, 1, 198, 33, 32, 4, 190, 34,
        33, 199, 2, 1, 34, 21, 1, 189, 0, 32, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_pack_Y42B);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_pack_Y42B");
      orc_program_set_backup_function (p, _backup_video_orc_pack_Y42B);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 1, "d2");
      orc_program_add_destination (p, 1, "d3");
      orc_program_add_source (p, 8, "s1");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 2, "t3");

      orc_program_append_2 (p, "splitlw", 1, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "select0lw", 0, ORC_VAR_T3, ORC_VAR_T2,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_D3, ORC_VAR_D2, ORC_VAR_T3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "select1wb", 1, ORC_VAR_D1, ORC_VAR_T1,
          ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->arrays[ORC_VAR_D3] = d3;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_unpack_Y444 */
#ifdef DISABLE_ORC
void
video_orc_unpack_Y444 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
  const orc_int8 *ORC_RESTRICT ptr5;
  const orc_int8 *ORC_RESTRICT ptr6;
  orc_int8 var34;
  orc_int8 var35;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_int8 var36;
#else
  orc_int8 var36;
#endif
  orc_int8 var37;
  orc_union32 var38;
  orc_union16 var39;
  orc_union16 var40;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_int8 *) s1;
  ptr5 = (orc_int8 *) s2;
  ptr6 = (orc_int8 *) s3;

  /* 3: loadpb */
  var36 = (int) 0x000000ff;     /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var34 = ptr5[i];
    /* 1: loadb */
    var35 = ptr6[i];
    /* 2: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var34;
      _dest.x2[1] = var35;
      var39.i = _dest.i;
    }
    /* 4: loadb */
    var37 = ptr4[i];
    /* 5: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var36;
      _dest.x2[1] = var37;
      var40.i = _dest.i;
    }
    /* 6: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var40.i;
      _dest.x2[1] = var39.i;
      var38.i = _dest.i;
    }
    /* 7: storel */
    ptr0[i] = var38;
  }

}

#else
static void
_backup_video_orc_unpack_Y444 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
  const orc_int8 *ORC_RESTRICT ptr5;
  const orc_int8 *ORC_RESTRICT ptr6;
  orc_int8 var34;
  orc_int8 var35;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_int8 var36;
#else
  orc_int8 var36;
#endif
  orc_int8 var37;
  orc_union32 var38;
  orc_union16 var39;
  orc_union16 var40;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_int8 *) ex->arrays[4];
  ptr5 = (orc_int8 *) ex->arrays[5];
  ptr6 = (orc_int8 *) ex->arrays[6];

  /* 3: loadpb */
  var36 = (int) 0x000000ff;     /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var34 = ptr5[i];
    /* 1: loadb */
    var35 = ptr6[i];
    /* 2: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var34;
      _dest.x2[1] = var35;
      var39.i = _dest.i;
    }
    /* 4: loadb */
    var37 = ptr4[i];
    /* 5: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var36;
      _dest.x2[1] = var37;
      var40.i = _dest.i;
    }
    /* 6: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var40.i;
      _dest.x2[1] = var39.i;
      var38.i = _dest.i;
    }
    /* 7: storel */
    ptr0[i] = var38;
  }

}

void
video_orc_unpack_Y444 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 21, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 117, 110, 112,
        97, 99, 107, 95, 89, 52, 52, 52, 11, 4, 4, 12, 1, 1, 12, 1,
        1, 12, 1, 1, 14, 1, 255, 0, 0, 0, 20, 2, 20, 2, 196, 32,
        5, 6, 196, 33, 16, 4, 195, 0, 33, 32, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_unpack_Y444);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_unpack_Y444");
      orc_program_set_backup_function (p, _backup_video_orc_unpack_Y444);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_constant (p, 1, 0x000000ff, "c1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_S3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T2, ORC_VAR_C1, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_T1,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->arrays[ORC_VAR_S2] = (void *) s2;
  ex->arrays[ORC_VAR_S3] = (void *) s3;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_pack_Y444 */
#ifdef DISABLE_ORC
void
video_orc_pack_Y444 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2,
    guint8 * ORC_RESTRICT d3, const guint8 * ORC_RESTRICT s1, int n)
{
  int i;
  orc_int8 *ORC_RESTRICT ptr0;
  orc_int8 *ORC_RESTRICT ptr1;
  orc_int8 *ORC_RESTRICT ptr2;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var34;
  orc_int8 var35;
  orc_int8 var36;
  orc_int8 var37;
  orc_union16 var38;
  orc_union16 var39;

  ptr0 = (orc_int8 *) d1;
  ptr1 = (orc_int8 *) d2;
  ptr2 = (orc_int8 *) d3;
  ptr4 = (orc_union32 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var34 = ptr4[i];
    /* 1: splitlw */
    {
      orc_union32 _src;
      _src.i = var34.i;
      var38.i = _src.x2[1];
      var39.i = _src.x2[0];
    }
    /* 2: splitwb */
    {
      orc_union16 _src;
      _src.i = var38.i;
      var35 = _src.x2[1];
      var36 = _src.x2[0];
    }
    /* 3: storeb */
    ptr2[i] = var35;
    /* 4: storeb */
    ptr1[i] = var36;
    /* 5: select1wb */
    {
      orc_union16 _src;
      _src.i = var39.i;
      var37 = _src.x2[1];
    }
    /* 6: storeb */
    ptr0[i] = var37;
  }

}

#else
static void
_backup_video_orc_pack_Y444 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_int8 *ORC_RESTRICT ptr0;
  orc_int8 *ORC_RESTRICT ptr1;
  orc_int8 *ORC_RESTRICT ptr2;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var34;
  orc_int8 var35;
  orc_int8 var36;
  orc_int8 var37;
  orc_union16 var38;
  orc_union16 var39;

  ptr0 = (orc_int8 *) ex->arrays[0];
  ptr1 = (orc_int8 *) ex->arrays[1];
  ptr2 = (orc_int8 *) ex->arrays[2];
  ptr4 = (orc_union32 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var34 = ptr4[i];
    /* 1: splitlw */
    {
      orc_union32 _src;
      _src.i = var34.i;
      var38.i = _src.x2[1];
      var39.i = _src.x2[0];
    }
    /* 2: splitwb */
    {
      orc_union16 _src;
      _src.i = var38.i;
      var35 = _src.x2[1];
      var36 = _src.x2[0];
    }
    /* 3: storeb */
    ptr2[i] = var35;
    /* 4: storeb */
    ptr1[i] = var36;
    /* 5: select1wb */
    {
      orc_union16 _src;
      _src.i = var39.i;
      var37 = _src.x2[1];
    }
    /* 6: storeb */
    ptr0[i] = var37;
  }

}

void
video_orc_pack_Y444 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2,
    guint8 * ORC_RESTRICT d3, const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 19, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 112, 97, 99,
        107, 95, 89, 52, 52, 52, 11, 1, 1, 11, 1, 1, 11, 1, 1, 12,
        4, 4, 20, 2, 20, 2, 198, 33, 32, 4, 199, 2, 1, 33, 189, 0,
        32, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_pack_Y444);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_pack_Y444");
      orc_program_set_backup_function (p, _backup_video_orc_pack_Y444);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_destination (p, 1, "d2");
      orc_program_add_destination (p, 1, "d3");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append_2 (p, "splitlw", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_D3, ORC_VAR_D2, ORC_VAR_T2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "select1wb", 0, ORC_VAR_D1, ORC_VAR_T1,
          ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->arrays[ORC_VAR_D3] = d3;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_unpack_GRAY8 */
#ifdef DISABLE_ORC
void
video_orc_unpack_GRAY8 (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_int8 var33;
#else
  orc_int8 var33;
#endif
  orc_int8 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var35;
#else
  orc_union16 var35;
#endif
  orc_union32 var36;
  orc_union16 var37;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_int8 *) s1;

  /* 0: loadpb */
  var33 = (int) 0x000000ff;     /* 255 or 1.25987e-321f */
  /* 3: loadpw */
  var35.i = (int) 0x00008080;   /* 32896 or 1.62528e-319f */

  for (i = 0; i < n; i++) {
    /* 1: loadb */
    var34 = ptr4[i];
    /* 2: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var33;
      _dest.x2[1] = var34;
      var37.i = _dest.i;
    }
    /* 4: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var37.i;
      _dest.x2[1] = var35.i;
      var36.i = _dest.i;
    }
    /* 5: storel */
    ptr0[i] = var36;
  }

}

#else
static void
_backup_video_orc_unpack_GRAY8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_int8 var33;
#else
  orc_int8 var33;
#endif
  orc_int8 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var35;
#else
  orc_union16 var35;
#endif
  orc_union32 var36;
  orc_union16 var37;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_int8 *) ex->arrays[4];

  /* 0: loadpb */
  var33 = (int) 0x000000ff;     /* 255 or 1.25987e-321f */
  /* 3: loadpw */
  var35.i = (int) 0x00008080;   /* 32896 or 1.62528e-319f */

  for (i = 0; i < n; i++) {
    /* 1: loadb */
    var34 = ptr4[i];
    /* 2: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var33;
      _dest.x2[1] = var34;
      var37.i = _dest.i;
    }
    /* 4: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var37.i;
      _dest.x2[1] = var35.i;
      var36.i = _dest.i;
    }
    /* 5: storel */
    ptr0[i] = var36;
  }

}

void
video_orc_unpack_GRAY8 (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 22, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 117, 110, 112,
        97, 99, 107, 95, 71, 82, 65, 89, 56, 11, 4, 4, 12, 1, 1, 14,
        1, 255, 0, 0, 0, 14, 2, 128, 128, 0, 0, 20, 2, 196, 32, 16,
        4, 195, 0, 32, 17, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_unpack_GRAY8);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_unpack_GRAY8");
      orc_program_set_backup_function (p, _backup_video_orc_unpack_GRAY8);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_constant (p, 1, 0x000000ff, "c1");
      orc_program_add_constant (p, 2, 0x00008080, "c2");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_C2,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_pack_GRAY8 */
#ifdef DISABLE_ORC
void
video_orc_pack_GRAY8 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  int i;
  orc_int8 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_int8 var34;
  orc_union16 var35;

  ptr0 = (orc_int8 *) d1;
  ptr4 = (orc_union32 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: select0lw */
    {
      orc_union32 _src;
      _src.i = var33.i;
      var35.i = _src.x2[0];
    }
    /* 2: select1wb */
    {
      orc_union16 _src;
      _src.i = var35.i;
      var34 = _src.x2[1];
    }
    /* 3: storeb */
    ptr0[i] = var34;
  }

}

#else
static void
_backup_video_orc_pack_GRAY8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_int8 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_int8 var34;
  orc_union16 var35;

  ptr0 = (orc_int8 *) ex->arrays[0];
  ptr4 = (orc_union32 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: select0lw */
    {
      orc_union32 _src;
      _src.i = var33.i;
      var35.i = _src.x2[0];
    }
    /* 2: select1wb */
    {
      orc_union16 _src;
      _src.i = var35.i;
      var34 = _src.x2[1];
    }
    /* 3: storeb */
    ptr0[i] = var34;
  }

}

void
video_orc_pack_GRAY8 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 20, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 112, 97, 99,
        107, 95, 71, 82, 65, 89, 56, 11, 1, 1, 12, 4, 4, 20, 2, 190,
        32, 4, 189, 0, 32, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_pack_GRAY8);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_pack_GRAY8");
      orc_program_set_backup_function (p, _backup_video_orc_pack_GRAY8);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "select0lw", 0, ORC_VAR_T1, ORC_VAR_S1,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "select1wb", 0, ORC_VAR_D1, ORC_VAR_T1,
          ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_unpack_BGRA */
#ifdef DISABLE_ORC
void
video_orc_unpack_BGRA (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_union32 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: swapl */
    var33.i = ORC_SWAP_L (var32.i);
    /* 2: storel */
    ptr0[i] = var33;
  }

}

#else
static void
_backup_video_orc_unpack_BGRA (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_union32 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: swapl */
    var33.i = ORC_SWAP_L (var32.i);
    /* 2: storel */
    ptr0[i] = var33;
  }

}

void
video_orc_unpack_BGRA (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 21, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 117, 110, 112,
        97, 99, 107, 95, 66, 71, 82, 65, 11, 4, 4, 12, 4, 4, 184, 0,
        4, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_unpack_BGRA);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_unpack_BGRA");
      orc_program_set_backup_function (p, _backup_video_orc_unpack_BGRA);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");

      orc_program_append_2 (p, "swapl", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_pack_BGRA */
#ifdef DISABLE_ORC
void
video_orc_pack_BGRA (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_union32 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: swapl */
    var33.i = ORC_SWAP_L (var32.i);
    /* 2: storel */
    ptr0[i] = var33;
  }

}

#else
static void
_backup_video_orc_pack_BGRA (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_union32 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: swapl */
    var33.i = ORC_SWAP_L (var32.i);
    /* 2: storel */
    ptr0[i] = var33;
  }

}

void
video_orc_pack_BGRA (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 19, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 112, 97, 99,
        107, 95, 66, 71, 82, 65, 11, 4, 4, 12, 4, 4, 184, 0, 4, 2,
        0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_pack_BGRA);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_pack_BGRA");
      orc_program_set_backup_function (p, _backup_video_orc_pack_BGRA);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");

      orc_program_append_2 (p, "swapl", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_pack_RGBA */
#ifdef DISABLE_ORC
void
video_orc_pack_RGBA (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var40;
  orc_union32 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_int8 var44;
  orc_int8 var45;
  orc_int8 var46;
  orc_int8 var47;
  orc_union16 var48;
  orc_union16 var49;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_union32 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var40 = ptr4[i];
    /* 1: splitlw */
    {
      orc_union32 _src;
      _src.i = var40.i;
      var42.i = _src.x2[1];
      var43.i = _src.x2[0];
    }
    /* 2: splitwb */
    {
      orc_union16 _src;
      _src.i = var42.i;
      var44 = _src.x2[1];
      var45 = _src.x2[0];
    }
    /* 3: splitwb */
    {
      orc_union16 _src;
      _src.i = var43.i;
      var46 = _src.x2[1];
      var47 = _src.x2[0];
    }
    /* 4: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var44;
      _dest.x2[1] = var47;
      var48.i = _dest.i;
    }
    /* 5: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var46;
      _dest.x2[1] = var45;
      var49.i = _dest.i;
    }
    /* 6: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var49.i;
      _dest.x2[1] = var48.i;
      var41.i = _dest.i;
    }
    /* 7: storel */
    ptr0[i] = var41;
  }

}

#else
static void
_backup_video_orc_pack_RGBA (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var40;
  orc_union32 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_int8 var44;
  orc_int8 var45;
  orc_int8 var46;
  orc_int8 var47;
  orc_union16 var48;
  orc_union16 var49;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_union32 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var40 = ptr4[i];
    /* 1: splitlw */
    {
      orc_union32 _src;
      _src.i = var40.i;
      var42.i = _src.x2[1];
      var43.i = _src.x2[0];
    }
    /* 2: splitwb */
    {
      orc_union16 _src;
      _src.i = var42.i;
      var44 = _src.x2[1];
      var45 = _src.x2[0];
    }
    /* 3: splitwb */
    {
      orc_union16 _src;
      _src.i = var43.i;
      var46 = _src.x2[1];
      var47 = _src.x2[0];
    }
    /* 4: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var44;
      _dest.x2[1] = var47;
      var48.i = _dest.i;
    }
    /* 5: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var46;
      _dest.x2[1] = var45;
      var49.i = _dest.i;
    }
    /* 6: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var49.i;
      _dest.x2[1] = var48.i;
      var41.i = _dest.i;
    }
    /* 7: storel */
    ptr0[i] = var41;
  }

}

void
video_orc_pack_RGBA (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 19, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 112, 97, 99,
        107, 95, 82, 71, 66, 65, 11, 4, 4, 12, 4, 4, 20, 1, 20, 1,
        20, 1, 20, 1, 20, 2, 20, 2, 20, 2, 20, 2, 198, 39, 38, 4,
        199, 35, 34, 39, 199, 33, 32, 38, 196, 37, 35, 32, 196, 36, 33, 34,
        195, 0, 36, 37, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_pack_RGBA);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_pack_RGBA");
      orc_program_set_backup_function (p, _backup_video_orc_pack_RGBA);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_temporary (p, 1, "t1");
      orc_program_add_temporary (p, 1, "t2");
      orc_program_add_temporary (p, 1, "t3");
      orc_program_add_temporary (p, 1, "t4");
      orc_program_add_temporary (p, 2, "t5");
      orc_program_add_temporary (p, 2, "t6");
      orc_program_add_temporary (p, 2, "t7");
      orc_program_add_temporary (p, 2, "t8");

      orc_program_append_2 (p, "splitlw", 0, ORC_VAR_T8, ORC_VAR_T7, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T4, ORC_VAR_T3, ORC_VAR_T8,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_T7,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T6, ORC_VAR_T4, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T5, ORC_VAR_T2, ORC_VAR_T3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_D1, ORC_VAR_T5, ORC_VAR_T6,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_unpack_RGBA */
#ifdef DISABLE_ORC
void
video_orc_unpack_RGBA (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var40;
  orc_union32 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_int8 var44;
  orc_int8 var45;
  orc_int8 var46;
  orc_int8 var47;
  orc_union16 var48;
  orc_union16 var49;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_union32 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var40 = ptr4[i];
    /* 1: splitlw */
    {
      orc_union32 _src;
      _src.i = var40.i;
      var42.i = _src.x2[1];
      var43.i = _src.x2[0];
    }
    /* 2: splitwb */
    {
      orc_union16 _src;
      _src.i = var43.i;
      var44 = _src.x2[1];
      var45 = _src.x2[0];
    }
    /* 3: splitwb */
    {
      orc_union16 _src;
      _src.i = var42.i;
      var46 = _src.x2[1];
      var47 = _src.x2[0];
    }
    /* 4: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var46;
      _dest.x2[1] = var45;
      var48.i = _dest.i;
    }
    /* 5: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var44;
      _dest.x2[1] = var47;
      var49.i = _dest.i;
    }
    /* 6: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var48.i;
      _dest.x2[1] = var49.i;
      var41.i = _dest.i;
    }
    /* 7: storel */
    ptr0[i] = var41;
  }

}

#else
static void
_backup_video_orc_unpack_RGBA (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var40;
  orc_union32 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_int8 var44;
  orc_int8 var45;
  orc_int8 var46;
  orc_int8 var47;
  orc_union16 var48;
  orc_union16 var49;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_union32 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var40 = ptr4[i];
    /* 1: splitlw */
    {
      orc_union32 _src;
      _src.i = var40.i;
      var42.i = _src.x2[1];
      var43.i = _src.x2[0];
    }
    /* 2: splitwb */
    {
      orc_union16 _src;
      _src.i = var43.i;
      var44 = _src.x2[1];
      var45 = _src.x2[0];
    }
    /* 3: splitwb */
    {
      orc_union16 _src;
      _src.i = var42.i;
      var46 = _src.x2[1];
      var47 = _src.x2[0];
    }
    /* 4: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var46;
      _dest.x2[1] = var45;
      var48.i = _dest.i;
    }
    /* 5: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var44;
      _dest.x2[1] = var47;
      var49.i = _dest.i;
    }
    /* 6: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var48.i;
      _dest.x2[1] = var49.i;
      var41.i = _dest.i;
    }
    /* 7: storel */
    ptr0[i] = var41;
  }

}

void
video_orc_unpack_RGBA (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 21, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 117, 110, 112,
        97, 99, 107, 95, 82, 71, 66, 65, 11, 4, 4, 12, 4, 4, 20, 1,
        20, 1, 20, 1, 20, 1, 20, 2, 20, 2, 20, 2, 20, 2, 198, 37,
        36, 4, 199, 34, 33, 36, 199, 32, 35, 37, 196, 38, 32, 33, 196, 39,
        34, 35, 195, 0, 38, 39, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_unpack_RGBA);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_unpack_RGBA");
      orc_program_set_backup_function (p, _backup_video_orc_unpack_RGBA);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_temporary (p, 1, "t1");
      orc_program_add_temporary (p, 1, "t2");
      orc_program_add_temporary (p, 1, "t3");
      orc_program_add_temporary (p, 1, "t4");
      orc_program_add_temporary (p, 2, "t5");
      orc_program_add_temporary (p, 2, "t6");
      orc_program_add_temporary (p, 2, "t7");
      orc_program_add_temporary (p, 2, "t8");

      orc_program_append_2 (p, "splitlw", 0, ORC_VAR_T6, ORC_VAR_T5, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T3, ORC_VAR_T2, ORC_VAR_T5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T1, ORC_VAR_T4, ORC_VAR_T6,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T7, ORC_VAR_T1, ORC_VAR_T2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T8, ORC_VAR_T3, ORC_VAR_T4,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_D1, ORC_VAR_T7, ORC_VAR_T8,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_unpack_ABGR */
#ifdef DISABLE_ORC
void
video_orc_unpack_ABGR (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var40;
  orc_union32 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_int8 var44;
  orc_int8 var45;
  orc_int8 var46;
  orc_int8 var47;
  orc_union16 var48;
  orc_union16 var49;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_union32 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var40 = ptr4[i];
    /* 1: splitlw */
    {
      orc_union32 _src;
      _src.i = var40.i;
      var42.i = _src.x2[1];
      var43.i = _src.x2[0];
    }
    /* 2: splitwb */
    {
      orc_union16 _src;
      _src.i = var42.i;
      var44 = _src.x2[1];
      var45 = _src.x2[0];
    }
    /* 3: splitwb */
    {
      orc_union16 _src;
      _src.i = var43.i;
      var46 = _src.x2[1];
      var47 = _src.x2[0];
    }
    /* 4: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var47;
      _dest.x2[1] = var44;
      var48.i = _dest.i;
    }
    /* 5: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var45;
      _dest.x2[1] = var46;
      var49.i = _dest.i;
    }
    /* 6: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var48.i;
      _dest.x2[1] = var49.i;
      var41.i = _dest.i;
    }
    /* 7: storel */
    ptr0[i] = var41;
  }

}

#else
static void
_backup_video_orc_unpack_ABGR (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var40;
  orc_union32 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_int8 var44;
  orc_int8 var45;
  orc_int8 var46;
  orc_int8 var47;
  orc_union16 var48;
  orc_union16 var49;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_union32 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var40 = ptr4[i];
    /* 1: splitlw */
    {
      orc_union32 _src;
      _src.i = var40.i;
      var42.i = _src.x2[1];
      var43.i = _src.x2[0];
    }
    /* 2: splitwb */
    {
      orc_union16 _src;
      _src.i = var42.i;
      var44 = _src.x2[1];
      var45 = _src.x2[0];
    }
    /* 3: splitwb */
    {
      orc_union16 _src;
      _src.i = var43.i;
      var46 = _src.x2[1];
      var47 = _src.x2[0];
    }
    /* 4: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var47;
      _dest.x2[1] = var44;
      var48.i = _dest.i;
    }
    /* 5: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var45;
      _dest.x2[1] = var46;
      var49.i = _dest.i;
    }
    /* 6: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var48.i;
      _dest.x2[1] = var49.i;
      var41.i = _dest.i;
    }
    /* 7: storel */
    ptr0[i] = var41;
  }

}

void
video_orc_unpack_ABGR (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 21, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 117, 110, 112,
        97, 99, 107, 95, 65, 66, 71, 82, 11, 4, 4, 12, 4, 4, 20, 1,
        20, 1, 20, 1, 20, 1, 20, 2, 20, 2, 20, 2, 20, 2, 198, 36,
        37, 4, 199, 33, 34, 36, 199, 35, 32, 37, 196, 38, 32, 33, 196, 39,
        34, 35, 195, 0, 38, 39, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_unpack_ABGR);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_unpack_ABGR");
      orc_program_set_backup_function (p, _backup_video_orc_unpack_ABGR);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_temporary (p, 1, "t1");
      orc_program_add_temporary (p, 1, "t2");
      orc_program_add_temporary (p, 1, "t3");
      orc_program_add_temporary (p, 1, "t4");
      orc_program_add_temporary (p, 2, "t5");
      orc_program_add_temporary (p, 2, "t6");
      orc_program_add_temporary (p, 2, "t7");
      orc_program_add_temporary (p, 2, "t8");

      orc_program_append_2 (p, "splitlw", 0, ORC_VAR_T5, ORC_VAR_T6, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T2, ORC_VAR_T3, ORC_VAR_T5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T4, ORC_VAR_T1, ORC_VAR_T6,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T7, ORC_VAR_T1, ORC_VAR_T2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T8, ORC_VAR_T3, ORC_VAR_T4,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_D1, ORC_VAR_T7, ORC_VAR_T8,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_pack_ABGR */
#ifdef DISABLE_ORC
void
video_orc_pack_ABGR (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var40;
  orc_union32 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_int8 var44;
  orc_int8 var45;
  orc_int8 var46;
  orc_int8 var47;
  orc_union16 var48;
  orc_union16 var49;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_union32 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var40 = ptr4[i];
    /* 1: splitlw */
    {
      orc_union32 _src;
      _src.i = var40.i;
      var42.i = _src.x2[1];
      var43.i = _src.x2[0];
    }
    /* 2: splitwb */
    {
      orc_union16 _src;
      _src.i = var42.i;
      var44 = _src.x2[1];
      var45 = _src.x2[0];
    }
    /* 3: splitwb */
    {
      orc_union16 _src;
      _src.i = var43.i;
      var46 = _src.x2[1];
      var47 = _src.x2[0];
    }
    /* 4: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var47;
      _dest.x2[1] = var44;
      var48.i = _dest.i;
    }
    /* 5: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var45;
      _dest.x2[1] = var46;
      var49.i = _dest.i;
    }
    /* 6: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var48.i;
      _dest.x2[1] = var49.i;
      var41.i = _dest.i;
    }
    /* 7: storel */
    ptr0[i] = var41;
  }

}

#else
static void
_backup_video_orc_pack_ABGR (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var40;
  orc_union32 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_int8 var44;
  orc_int8 var45;
  orc_int8 var46;
  orc_int8 var47;
  orc_union16 var48;
  orc_union16 var49;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_union32 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var40 = ptr4[i];
    /* 1: splitlw */
    {
      orc_union32 _src;
      _src.i = var40.i;
      var42.i = _src.x2[1];
      var43.i = _src.x2[0];
    }
    /* 2: splitwb */
    {
      orc_union16 _src;
      _src.i = var42.i;
      var44 = _src.x2[1];
      var45 = _src.x2[0];
    }
    /* 3: splitwb */
    {
      orc_union16 _src;
      _src.i = var43.i;
      var46 = _src.x2[1];
      var47 = _src.x2[0];
    }
    /* 4: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var47;
      _dest.x2[1] = var44;
      var48.i = _dest.i;
    }
    /* 5: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var45;
      _dest.x2[1] = var46;
      var49.i = _dest.i;
    }
    /* 6: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var48.i;
      _dest.x2[1] = var49.i;
      var41.i = _dest.i;
    }
    /* 7: storel */
    ptr0[i] = var41;
  }

}

void
video_orc_pack_ABGR (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 19, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 112, 97, 99,
        107, 95, 65, 66, 71, 82, 11, 4, 4, 12, 4, 4, 20, 1, 20, 1,
        20, 1, 20, 1, 20, 2, 20, 2, 20, 2, 20, 2, 198, 39, 38, 4,
        199, 35, 34, 39, 199, 33, 32, 38, 196, 37, 32, 35, 196, 36, 34, 33,
        195, 0, 37, 36, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_pack_ABGR);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_pack_ABGR");
      orc_program_set_backup_function (p, _backup_video_orc_pack_ABGR);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_temporary (p, 1, "t1");
      orc_program_add_temporary (p, 1, "t2");
      orc_program_add_temporary (p, 1, "t3");
      orc_program_add_temporary (p, 1, "t4");
      orc_program_add_temporary (p, 2, "t5");
      orc_program_add_temporary (p, 2, "t6");
      orc_program_add_temporary (p, 2, "t7");
      orc_program_add_temporary (p, 2, "t8");

      orc_program_append_2 (p, "splitlw", 0, ORC_VAR_T8, ORC_VAR_T7, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T4, ORC_VAR_T3, ORC_VAR_T8,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_T7,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T6, ORC_VAR_T1, ORC_VAR_T4,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T5, ORC_VAR_T3, ORC_VAR_T2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_D1, ORC_VAR_T6, ORC_VAR_T5,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_unpack_NV12 */
#ifdef DISABLE_ORC
void
video_orc_unpack_NV12 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    const guint8 * ORC_RESTRICT s2, int n)
{
  int i;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_union16 *ORC_RESTRICT ptr5;
  orc_union16 var34;
  orc_union16 var35;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var36;
#else
  orc_union16 var36;
#endif
  orc_union16 var37;
  orc_union64 var38;
  orc_union32 var39;
  orc_union32 var40;

  ptr0 = (orc_union64 *) d1;
  ptr4 = (orc_union16 *) s1;
  ptr5 = (orc_union16 *) s2;

  /* 3: loadpb */
  var36.x2[0] = (int) 0x000000ff;       /* 255 or 1.25987e-321f */
  var36.x2[1] = (int) 0x000000ff;       /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr5[i];
    /* 1: loadw */
    var35 = ptr5[i];
    /* 2: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var34.i;
      _dest.x2[1] = var35.i;
      var39.i = _dest.i;
    }
    /* 4: loadw */
    var37 = ptr4[i];
    /* 5: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var36.x2[0];
      _dest.x2[1] = var37.x2[0];
      var40.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var36.x2[1];
      _dest.x2[1] = var37.x2[1];
      var40.x2[1] = _dest.i;
    }
    /* 6: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var40.x2[0];
      _dest.x2[1] = var39.x2[0];
      var38.x2[0] = _dest.i;
    }
    {
      orc_union32 _dest;
      _dest.x2[0] = var40.x2[1];
      _dest.x2[1] = var39.x2[1];
      var38.x2[1] = _dest.i;
    }
    /* 7: storeq */
    ptr0[i] = var38;
  }

}

#else
static void
_backup_video_orc_unpack_NV12 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_union16 *ORC_RESTRICT ptr5;
  orc_union16 var34;
  orc_union16 var35;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var36;
#else
  orc_union16 var36;
#endif
  orc_union16 var37;
  orc_union64 var38;
  orc_union32 var39;
  orc_union32 var40;

  ptr0 = (orc_union64 *) ex->arrays[0];
  ptr4 = (orc_union16 *) ex->arrays[4];
  ptr5 = (orc_union16 *) ex->arrays[5];

  /* 3: loadpb */
  var36.x2[0] = (int) 0x000000ff;       /* 255 or 1.25987e-321f */
  var36.x2[1] = (int) 0x000000ff;       /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr5[i];
    /* 1: loadw */
    var35 = ptr5[i];
    /* 2: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var34.i;
      _dest.x2[1] = var35.i;
      var39.i = _dest.i;
    }
    /* 4: loadw */
    var37 = ptr4[i];
    /* 5: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var36.x2[0];
      _dest.x2[1] = var37.x2[0];
      var40.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var36.x2[1];
      _dest.x2[1] = var37.x2[1];
      var40.x2[1] = _dest.i;
    }
    /* 6: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var40.x2[0];
      _dest.x2[1] = var39.x2[0];
      var38.x2[0] = _dest.i;
    }
    {
      orc_union32 _dest;
      _dest.x2[0] = var40.x2[1];
      _dest.x2[1] = var39.x2[1];
      var38.x2[1] = _dest.i;
    }
    /* 7: storeq */
    ptr0[i] = var38;
  }

}

void
video_orc_unpack_NV12 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    const guint8 * ORC_RESTRICT s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 21, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 117, 110, 112,
        97, 99, 107, 95, 78, 86, 49, 50, 11, 8, 8, 12, 2, 2, 12, 2,
        2, 14, 1, 255, 0, 0, 0, 20, 4, 20, 4, 195, 33, 5, 5, 21,
        1, 196, 32, 16, 4, 21, 1, 195, 0, 32, 33, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_unpack_NV12);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_unpack_NV12");
      orc_program_set_backup_function (p, _backup_video_orc_unpack_NV12);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_constant (p, 1, 0x000000ff, "c1");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");

      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_S2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->arrays[ORC_VAR_S2] = (void *) s2;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_pack_NV12 */
#ifdef DISABLE_ORC
void
video_orc_pack_NV12 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2,
    const guint8 * ORC_RESTRICT s1, int n)
{
  int i;
  orc_union16 *ORC_RESTRICT ptr0;
  orc_union16 *ORC_RESTRICT ptr1;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var34;
  orc_union16 var35;
  orc_union16 var36;
  orc_union32 var37;
  orc_union32 var38;

  ptr0 = (orc_union16 *) d1;
  ptr1 = (orc_union16 *) d2;
  ptr4 = (orc_union64 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var34 = ptr4[i];
    /* 1: splitlw */
    {
      orc_union32 _src;
      _src.i = var34.x2[0];
      var37.x2[0] = _src.x2[1];
      var38.x2[0] = _src.x2[0];
    }
    {
      orc_union32 _src;
      _src.i = var34.x2[1];
      var37.x2[1] = _src.x2[1];
      var38.x2[1] = _src.x2[0];
    }
    /* 2: select1wb */
    {
      orc_union16 _src;
      _src.i = var38.x2[0];
      var35.x2[0] = _src.x2[1];
    }
    {
      orc_union16 _src;
      _src.i = var38.x2[1];
      var35.x2[1] = _src.x2[1];
    }
    /* 3: storew */
    ptr0[i] = var35;
    /* 4: select0lw */
    {
      orc_union32 _src;
      _src.i = var37.i;
      var36.i = _src.x2[0];
    }
    /* 5: storew */
    ptr1[i] = var36;
  }

}

#else
static void
_backup_video_orc_pack_NV12 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 *ORC_RESTRICT ptr0;
  orc_union16 *ORC_RESTRICT ptr1;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var34;
  orc_union16 var35;
  orc_union16 var36;
  orc_union32 var37;
  orc_union32 var38;

  ptr0 = (orc_union16 *) ex->arrays[0];
  ptr1 = (orc_union16 *) ex->arrays[1];
  ptr4 = (orc_union64 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var34 = ptr4[i];
    /* 1: splitlw */
    {
      orc_union32 _src;
      _src.i = var34.x2[0];
      var37.x2[0] = _src.x2[1];
      var38.x2[0] = _src.x2[0];
    }
    {
      orc_union32 _src;
      _src.i = var34.x2[1];
      var37.x2[1] = _src.x2[1];
      var38.x2[1] = _src.x2[0];
    }
    /* 2: select1wb */
    {
      orc_union16 _src;
      _src.i = var38.x2[0];
      var35.x2[0] = _src.x2[1];
    }
    {
      orc_union16 _src;
      _src.i = var38.x2[1];
      var35.x2[1] = _src.x2[1];
    }
    /* 3: storew */
    ptr0[i] = var35;
    /* 4: select0lw */
    {
      orc_union32 _src;
      _src.i = var37.i;
      var36.i = _src.x2[0];
    }
    /* 5: storew */
    ptr1[i] = var36;
  }

}

void
video_orc_pack_NV12 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2,
    const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 19, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 112, 97, 99,
        107, 95, 78, 86, 49, 50, 11, 2, 2, 11, 2, 2, 12, 8, 8, 20,
        4, 20, 4, 21, 1, 198, 33, 32, 4, 21, 1, 189, 0, 32, 190, 1,
        33, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_pack_NV12);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_pack_NV12");
      orc_program_set_backup_function (p, _backup_video_orc_pack_NV12);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 2, "d2");
      orc_program_add_source (p, 8, "s1");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");

      orc_program_append_2 (p, "splitlw", 1, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "select1wb", 1, ORC_VAR_D1, ORC_VAR_T1,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "select0lw", 0, ORC_VAR_D2, ORC_VAR_T2,
          ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_unpack_NV21 */
#ifdef DISABLE_ORC
void
video_orc_unpack_NV21 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    const guint8 * ORC_RESTRICT s2, int n)
{
  int i;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_union16 *ORC_RESTRICT ptr5;
  orc_union16 var35;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var36;
#else
  orc_union16 var36;
#endif
  orc_union16 var37;
  orc_union64 var38;
  orc_union16 var39;
  orc_union32 var40;
  orc_union32 var41;

  ptr0 = (orc_union64 *) d1;
  ptr4 = (orc_union16 *) s1;
  ptr5 = (orc_union16 *) s2;

  /* 3: loadpb */
  var36.x2[0] = (int) 0x000000ff;       /* 255 or 1.25987e-321f */
  var36.x2[1] = (int) 0x000000ff;       /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var35 = ptr5[i];
    /* 1: swapw */
    var39.i = ORC_SWAP_W (var35.i);
    /* 2: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var39.i;
      _dest.x2[1] = var39.i;
      var40.i = _dest.i;
    }
    /* 4: loadw */
    var37 = ptr4[i];
    /* 5: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var36.x2[0];
      _dest.x2[1] = var37.x2[0];
      var41.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var36.x2[1];
      _dest.x2[1] = var37.x2[1];
      var41.x2[1] = _dest.i;
    }
    /* 6: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var41.x2[0];
      _dest.x2[1] = var40.x2[0];
      var38.x2[0] = _dest.i;
    }
    {
      orc_union32 _dest;
      _dest.x2[0] = var41.x2[1];
      _dest.x2[1] = var40.x2[1];
      var38.x2[1] = _dest.i;
    }
    /* 7: storeq */
    ptr0[i] = var38;
  }

}

#else
static void
_backup_video_orc_unpack_NV21 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_union16 *ORC_RESTRICT ptr5;
  orc_union16 var35;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var36;
#else
  orc_union16 var36;
#endif
  orc_union16 var37;
  orc_union64 var38;
  orc_union16 var39;
  orc_union32 var40;
  orc_union32 var41;

  ptr0 = (orc_union64 *) ex->arrays[0];
  ptr4 = (orc_union16 *) ex->arrays[4];
  ptr5 = (orc_union16 *) ex->arrays[5];

  /* 3: loadpb */
  var36.x2[0] = (int) 0x000000ff;       /* 255 or 1.25987e-321f */
  var36.x2[1] = (int) 0x000000ff;       /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var35 = ptr5[i];
    /* 1: swapw */
    var39.i = ORC_SWAP_W (var35.i);
    /* 2: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var39.i;
      _dest.x2[1] = var39.i;
      var40.i = _dest.i;
    }
    /* 4: loadw */
    var37 = ptr4[i];
    /* 5: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var36.x2[0];
      _dest.x2[1] = var37.x2[0];
      var41.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var36.x2[1];
      _dest.x2[1] = var37.x2[1];
      var41.x2[1] = _dest.i;
    }
    /* 6: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var41.x2[0];
      _dest.x2[1] = var40.x2[0];
      var38.x2[0] = _dest.i;
    }
    {
      orc_union32 _dest;
      _dest.x2[0] = var41.x2[1];
      _dest.x2[1] = var40.x2[1];
      var38.x2[1] = _dest.i;
    }
    /* 7: storeq */
    ptr0[i] = var38;
  }

}

void
video_orc_unpack_NV21 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    const guint8 * ORC_RESTRICT s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 21, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 117, 110, 112,
        97, 99, 107, 95, 78, 86, 50, 49, 11, 8, 8, 12, 2, 2, 12, 2,
        2, 14, 1, 255, 0, 0, 0, 20, 2, 20, 4, 20, 4, 183, 32, 5,
        195, 34, 32, 32, 21, 1, 196, 33, 16, 4, 21, 1, 195, 0, 33, 34,
        2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_unpack_NV21);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_unpack_NV21");
      orc_program_set_backup_function (p, _backup_video_orc_unpack_NV21);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_constant (p, 1, 0x000000ff, "c1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 4, "t3");

      orc_program_append_2 (p, "swapw", 0, ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_T2, ORC_VAR_C1, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 1, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_T3,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->arrays[ORC_VAR_S2] = (void *) s2;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_pack_NV21 */
#ifdef DISABLE_ORC
void
video_orc_pack_NV21 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2,
    const guint8 * ORC_RESTRICT s1, int n)
{
  int i;
  orc_union16 *ORC_RESTRICT ptr0;
  orc_union16 *ORC_RESTRICT ptr1;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union16 var40;

  ptr0 = (orc_union16 *) d1;
  ptr1 = (orc_union16 *) d2;
  ptr4 = (orc_union64 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var35 = ptr4[i];
    /* 1: splitlw */
    {
      orc_union32 _src;
      _src.i = var35.x2[0];
      var38.x2[0] = _src.x2[1];
      var39.x2[0] = _src.x2[0];
    }
    {
      orc_union32 _src;
      _src.i = var35.x2[1];
      var38.x2[1] = _src.x2[1];
      var39.x2[1] = _src.x2[0];
    }
    /* 2: select1wb */
    {
      orc_union16 _src;
      _src.i = var39.x2[0];
      var36.x2[0] = _src.x2[1];
    }
    {
      orc_union16 _src;
      _src.i = var39.x2[1];
      var36.x2[1] = _src.x2[1];
    }
    /* 3: storew */
    ptr0[i] = var36;
    /* 4: select0lw */
    {
      orc_union32 _src;
      _src.i = var38.i;
      var40.i = _src.x2[0];
    }
    /* 5: swapw */
    var37.i = ORC_SWAP_W (var40.i);
    /* 6: storew */
    ptr1[i] = var37;
  }

}

#else
static void
_backup_video_orc_pack_NV21 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 *ORC_RESTRICT ptr0;
  orc_union16 *ORC_RESTRICT ptr1;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union16 var40;

  ptr0 = (orc_union16 *) ex->arrays[0];
  ptr1 = (orc_union16 *) ex->arrays[1];
  ptr4 = (orc_union64 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var35 = ptr4[i];
    /* 1: splitlw */
    {
      orc_union32 _src;
      _src.i = var35.x2[0];
      var38.x2[0] = _src.x2[1];
      var39.x2[0] = _src.x2[0];
    }
    {
      orc_union32 _src;
      _src.i = var35.x2[1];
      var38.x2[1] = _src.x2[1];
      var39.x2[1] = _src.x2[0];
    }
    /* 2: select1wb */
    {
      orc_union16 _src;
      _src.i = var39.x2[0];
      var36.x2[0] = _src.x2[1];
    }
    {
      orc_union16 _src;
      _src.i = var39.x2[1];
      var36.x2[1] = _src.x2[1];
    }
    /* 3: storew */
    ptr0[i] = var36;
    /* 4: select0lw */
    {
      orc_union32 _src;
      _src.i = var38.i;
      var40.i = _src.x2[0];
    }
    /* 5: swapw */
    var37.i = ORC_SWAP_W (var40.i);
    /* 6: storew */
    ptr1[i] = var37;
  }

}

void
video_orc_pack_NV21 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2,
    const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 19, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 112, 97, 99,
        107, 95, 78, 86, 50, 49, 11, 2, 2, 11, 2, 2, 12, 8, 8, 20,
        4, 20, 4, 20, 2, 21, 1, 198, 33, 32, 4, 21, 1, 189, 0, 32,
        190, 34, 33, 183, 1, 34, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_pack_NV21);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_pack_NV21");
      orc_program_set_backup_function (p, _backup_video_orc_pack_NV21);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 2, "d2");
      orc_program_add_source (p, 8, "s1");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 2, "t3");

      orc_program_append_2 (p, "splitlw", 1, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "select1wb", 1, ORC_VAR_D1, ORC_VAR_T1,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "select0lw", 0, ORC_VAR_T3, ORC_VAR_T2,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "swapw", 0, ORC_VAR_D2, ORC_VAR_T3, ORC_VAR_D1,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_unpack_NV24 */
#ifdef DISABLE_ORC
void
video_orc_unpack_NV24 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    const guint8 * ORC_RESTRICT s2, int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
  const orc_union16 *ORC_RESTRICT ptr5;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_int8 var33;
#else
  orc_int8 var33;
#endif
  orc_int8 var34;
  orc_union16 var35;
  orc_union32 var36;
  orc_union16 var37;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_int8 *) s1;
  ptr5 = (orc_union16 *) s2;

  /* 0: loadpb */
  var33 = (int) 0x000000ff;     /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 1: loadb */
    var34 = ptr4[i];
    /* 2: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var33;
      _dest.x2[1] = var34;
      var37.i = _dest.i;
    }
    /* 3: loadw */
    var35 = ptr5[i];
    /* 4: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var37.i;
      _dest.x2[1] = var35.i;
      var36.i = _dest.i;
    }
    /* 5: storel */
    ptr0[i] = var36;
  }

}

#else
static void
_backup_video_orc_unpack_NV24 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
  const orc_union16 *ORC_RESTRICT ptr5;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_int8 var33;
#else
  orc_int8 var33;
#endif
  orc_int8 var34;
  orc_union16 var35;
  orc_union32 var36;
  orc_union16 var37;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_int8 *) ex->arrays[4];
  ptr5 = (orc_union16 *) ex->arrays[5];

  /* 0: loadpb */
  var33 = (int) 0x000000ff;     /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 1: loadb */
    var34 = ptr4[i];
    /* 2: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var33;
      _dest.x2[1] = var34;
      var37.i = _dest.i;
    }
    /* 3: loadw */
    var35 = ptr5[i];
    /* 4: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var37.i;
      _dest.x2[1] = var35.i;
      var36.i = _dest.i;
    }
    /* 5: storel */
    ptr0[i] = var36;
  }

}

void
video_orc_unpack_NV24 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    const guint8 * ORC_RESTRICT s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 21, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 117, 110, 112,
        97, 99, 107, 95, 78, 86, 50, 52, 11, 4, 4, 12, 1, 1, 12, 2,
        2, 14, 1, 255, 0, 0, 0, 20, 2, 196, 32, 16, 4, 195, 0, 32,
        5, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_unpack_NV24);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_unpack_NV24");
      orc_program_set_backup_function (p, _backup_video_orc_unpack_NV24);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_constant (p, 1, 0x000000ff, "c1");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_S2,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->arrays[ORC_VAR_S2] = (void *) s2;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_pack_NV24 */
#ifdef DISABLE_ORC
void
video_orc_pack_NV24 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2,
    const guint8 * ORC_RESTRICT s1, int n)
{
  int i;
  orc_int8 *ORC_RESTRICT ptr0;
  orc_union16 *ORC_RESTRICT ptr1;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_union16 var34;
  orc_int8 var35;
  orc_union16 var36;

  ptr0 = (orc_int8 *) d1;
  ptr1 = (orc_union16 *) d2;
  ptr4 = (orc_union32 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: splitlw */
    {
      orc_union32 _src;
      _src.i = var33.i;
      var34.i = _src.x2[1];
      var36.i = _src.x2[0];
    }
    /* 2: storew */
    ptr1[i] = var34;
    /* 3: select1wb */
    {
      orc_union16 _src;
      _src.i = var36.i;
      var35 = _src.x2[1];
    }
    /* 4: storeb */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_video_orc_pack_NV24 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_int8 *ORC_RESTRICT ptr0;
  orc_union16 *ORC_RESTRICT ptr1;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_union16 var34;
  orc_int8 var35;
  orc_union16 var36;

  ptr0 = (orc_int8 *) ex->arrays[0];
  ptr1 = (orc_union16 *) ex->arrays[1];
  ptr4 = (orc_union32 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: splitlw */
    {
      orc_union32 _src;
      _src.i = var33.i;
      var34.i = _src.x2[1];
      var36.i = _src.x2[0];
    }
    /* 2: storew */
    ptr1[i] = var34;
    /* 3: select1wb */
    {
      orc_union16 _src;
      _src.i = var36.i;
      var35 = _src.x2[1];
    }
    /* 4: storeb */
    ptr0[i] = var35;
  }

}

void
video_orc_pack_NV24 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2,
    const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 19, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 112, 97, 99,
        107, 95, 78, 86, 50, 52, 11, 1, 1, 11, 2, 2, 12, 4, 4, 20,
        2, 198, 1, 32, 4, 189, 0, 32, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_pack_NV24);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_pack_NV24");
      orc_program_set_backup_function (p, _backup_video_orc_pack_NV24);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_destination (p, 2, "d2");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "splitlw", 0, ORC_VAR_D2, ORC_VAR_T1, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "select1wb", 0, ORC_VAR_D1, ORC_VAR_T1,
          ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_unpack_A420 */
#ifdef DISABLE_ORC
void
video_orc_unpack_A420 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3,
    const guint8 * ORC_RESTRICT s4, int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
  const orc_int8 *ORC_RESTRICT ptr5;
  const orc_int8 *ORC_RESTRICT ptr6;
  const orc_int8 *ORC_RESTRICT ptr7;
  orc_int8 var36;
  orc_int8 var37;
  orc_union32 var38;
  orc_int8 var39;
  orc_int8 var40;
  orc_union16 var41;
  orc_union16 var42;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_int8 *) s1;
  ptr5 = (orc_int8 *) s2;
  ptr6 = (orc_int8 *) s3;
  ptr7 = (orc_int8 *) s4;


  for (i = 0; i < n; i++) {
    /* 0: loadupdb */
    var39 = ptr5[i >> 1];
    /* 1: loadupdb */
    var40 = ptr6[i >> 1];
    /* 2: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var39;
      _dest.x2[1] = var40;
      var41.i = _dest.i;
    }
    /* 3: loadb */
    var36 = ptr7[i];
    /* 4: loadb */
    var37 = ptr4[i];
    /* 5: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var36;
      _dest.x2[1] = var37;
      var42.i = _dest.i;
    }
    /* 6: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var42.i;
      _dest.x2[1] = var41.i;
      var38.i = _dest.i;
    }
    /* 7: storel */
    ptr0[i] = var38;
  }

}

#else
static void
_backup_video_orc_unpack_A420 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
  const orc_int8 *ORC_RESTRICT ptr5;
  const orc_int8 *ORC_RESTRICT ptr6;
  const orc_int8 *ORC_RESTRICT ptr7;
  orc_int8 var36;
  orc_int8 var37;
  orc_union32 var38;
  orc_int8 var39;
  orc_int8 var40;
  orc_union16 var41;
  orc_union16 var42;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_int8 *) ex->arrays[4];
  ptr5 = (orc_int8 *) ex->arrays[5];
  ptr6 = (orc_int8 *) ex->arrays[6];
  ptr7 = (orc_int8 *) ex->arrays[7];


  for (i = 0; i < n; i++) {
    /* 0: loadupdb */
    var39 = ptr5[i >> 1];
    /* 1: loadupdb */
    var40 = ptr6[i >> 1];
    /* 2: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var39;
      _dest.x2[1] = var40;
      var41.i = _dest.i;
    }
    /* 3: loadb */
    var36 = ptr7[i];
    /* 4: loadb */
    var37 = ptr4[i];
    /* 5: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var36;
      _dest.x2[1] = var37;
      var42.i = _dest.i;
    }
    /* 6: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var42.i;
      _dest.x2[1] = var41.i;
      var38.i = _dest.i;
    }
    /* 7: storel */
    ptr0[i] = var38;
  }

}

void
video_orc_unpack_A420 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3,
    const guint8 * ORC_RESTRICT s4, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 21, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 117, 110, 112,
        97, 99, 107, 95, 65, 52, 50, 48, 11, 4, 4, 12, 1, 1, 12, 1,
        1, 12, 1, 1, 12, 1, 1, 20, 2, 20, 2, 20, 1, 20, 1, 45,
        34, 5, 45, 35, 6, 196, 32, 34, 35, 196, 33, 7, 4, 195, 0, 33,
        32, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_unpack_A420);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_unpack_A420");
      orc_program_set_backup_function (p, _backup_video_orc_unpack_A420);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_source (p, 1, "s4");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 1, "t3");
      orc_program_add_temporary (p, 1, "t4");

      orc_program_append_2 (p, "loadupdb", 0, ORC_VAR_T3, ORC_VAR_S2,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "loadupdb", 0, ORC_VAR_T4, ORC_VAR_S3,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T1, ORC_VAR_T3, ORC_VAR_T4,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T2, ORC_VAR_S4, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_T1,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->arrays[ORC_VAR_S2] = (void *) s2;
  ex->arrays[ORC_VAR_S3] = (void *) s3;
  ex->arrays[ORC_VAR_S4] = (void *) s4;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_pack_A420 */
#ifdef DISABLE_ORC
void
video_orc_pack_A420 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2,
    guint8 * ORC_RESTRICT d3, guint8 * ORC_RESTRICT d4,
    const guint8 * ORC_RESTRICT s1, int n)
{
  int i;
  orc_union16 *ORC_RESTRICT ptr0;
  orc_int8 *ORC_RESTRICT ptr1;
  orc_int8 *ORC_RESTRICT ptr2;
  orc_union16 *ORC_RESTRICT ptr3;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_int8 var39;
  orc_int8 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union16 var43;
  orc_union16 var44;

  ptr0 = (orc_union16 *) d1;
  ptr1 = (orc_int8 *) d2;
  ptr2 = (orc_int8 *) d3;
  ptr3 = (orc_union16 *) d4;
  ptr4 = (orc_union64 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var36 = ptr4[i];
    /* 1: splitlw */
    {
      orc_union32 _src;
      _src.i = var36.x2[0];
      var41.x2[0] = _src.x2[1];
      var42.x2[0] = _src.x2[0];
    }
    {
      orc_union32 _src;
      _src.i = var36.x2[1];
      var41.x2[1] = _src.x2[1];
      var42.x2[1] = _src.x2[0];
    }
    /* 2: select1wb */
    {
      orc_union16 _src;
      _src.i = var42.x2[0];
      var37.x2[0] = _src.x2[1];
    }
    {
      orc_union16 _src;
      _src.i = var42.x2[1];
      var37.x2[1] = _src.x2[1];
    }
    /* 3: storew */
    ptr0[i] = var37;
    /* 4: select0wb */
    {
      orc_union16 _src;
      _src.i = var42.x2[0];
      var38.x2[0] = _src.x2[0];
    }
    {
      orc_union16 _src;
      _src.i = var42.x2[1];
      var38.x2[1] = _src.x2[0];
    }
    /* 5: storew */
    ptr3[i] = var38;
    /* 6: splitwb */
    {
      orc_union16 _src;
      _src.i = var41.x2[0];
      var43.x2[0] = _src.x2[1];
      var44.x2[0] = _src.x2[0];
    }
    {
      orc_union16 _src;
      _src.i = var41.x2[1];
      var43.x2[1] = _src.x2[1];
      var44.x2[1] = _src.x2[0];
    }
    /* 7: select0wb */
    {
      orc_union16 _src;
      _src.i = var44.i;
      var39 = _src.x2[0];
    }
    /* 8: storeb */
    ptr1[i] = var39;
    /* 9: select0wb */
    {
      orc_union16 _src;
      _src.i = var43.i;
      var40 = _src.x2[0];
    }
    /* 10: storeb */
    ptr2[i] = var40;
  }

}

#else
static void
_backup_video_orc_pack_A420 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 *ORC_RESTRICT ptr0;
  orc_int8 *ORC_RESTRICT ptr1;
  orc_int8 *ORC_RESTRICT ptr2;
  orc_union16 *ORC_RESTRICT ptr3;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_int8 var39;
  orc_int8 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union16 var43;
  orc_union16 var44;

  ptr0 = (orc_union16 *) ex->arrays[0];
  ptr1 = (orc_int8 *) ex->arrays[1];
  ptr2 = (orc_int8 *) ex->arrays[2];
  ptr3 = (orc_union16 *) ex->arrays[3];
  ptr4 = (orc_union64 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var36 = ptr4[i];
    /* 1: splitlw */
    {
      orc_union32 _src;
      _src.i = var36.x2[0];
      var41.x2[0] = _src.x2[1];
      var42.x2[0] = _src.x2[0];
    }
    {
      orc_union32 _src;
      _src.i = var36.x2[1];
      var41.x2[1] = _src.x2[1];
      var42.x2[1] = _src.x2[0];
    }
    /* 2: select1wb */
    {
      orc_union16 _src;
      _src.i = var42.x2[0];
      var37.x2[0] = _src.x2[1];
    }
    {
      orc_union16 _src;
      _src.i = var42.x2[1];
      var37.x2[1] = _src.x2[1];
    }
    /* 3: storew */
    ptr0[i] = var37;
    /* 4: select0wb */
    {
      orc_union16 _src;
      _src.i = var42.x2[0];
      var38.x2[0] = _src.x2[0];
    }
    {
      orc_union16 _src;
      _src.i = var42.x2[1];
      var38.x2[1] = _src.x2[0];
    }
    /* 5: storew */
    ptr3[i] = var38;
    /* 6: splitwb */
    {
      orc_union16 _src;
      _src.i = var41.x2[0];
      var43.x2[0] = _src.x2[1];
      var44.x2[0] = _src.x2[0];
    }
    {
      orc_union16 _src;
      _src.i = var41.x2[1];
      var43.x2[1] = _src.x2[1];
      var44.x2[1] = _src.x2[0];
    }
    /* 7: select0wb */
    {
      orc_union16 _src;
      _src.i = var44.i;
      var39 = _src.x2[0];
    }
    /* 8: storeb */
    ptr1[i] = var39;
    /* 9: select0wb */
    {
      orc_union16 _src;
      _src.i = var43.i;
      var40 = _src.x2[0];
    }
    /* 10: storeb */
    ptr2[i] = var40;
  }

}

void
video_orc_pack_A420 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2,
    guint8 * ORC_RESTRICT d3, guint8 * ORC_RESTRICT d4,
    const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 19, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 112, 97, 99,
        107, 95, 65, 52, 50, 48, 11, 2, 2, 11, 1, 1, 11, 1, 1, 11,
        2, 2, 12, 8, 8, 20, 4, 20, 4, 20, 2, 20, 2, 21, 1, 198,
        33, 32, 4, 21, 1, 189, 0, 32, 21, 1, 188, 3, 32, 21, 1, 199,
        35, 34, 33, 188, 1, 34, 188, 2, 35, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_pack_A420);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_pack_A420");
      orc_program_set_backup_function (p, _backup_video_orc_pack_A420);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 1, "d2");
      orc_program_add_destination (p, 1, "d3");
      orc_program_add_destination (p, 2, "d4");
      orc_program_add_source (p, 8, "s1");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 2, "t3");
      orc_program_add_temporary (p, 2, "t4");

      orc_program_append_2 (p, "splitlw", 1, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "select1wb", 1, ORC_VAR_D1, ORC_VAR_T1,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "select0wb", 1, ORC_VAR_D4, ORC_VAR_T1,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 1, ORC_VAR_T4, ORC_VAR_T3, ORC_VAR_T2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "select0wb", 0, ORC_VAR_D2, ORC_VAR_T3,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "select0wb", 0, ORC_VAR_D3, ORC_VAR_T4,
          ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->arrays[ORC_VAR_D3] = d3;
  ex->arrays[ORC_VAR_D4] = d4;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_resample_bilinear_u32 */
#ifdef DISABLE_ORC
void
video_orc_resample_bilinear_u32 (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int p1, int p2, int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var32;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_union32 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: ldreslinl */
    {
      int tmp = p1 + i * p2;
      orc_union32 a = ptr4[tmp >> 16];
      orc_union32 b = ptr4[(tmp >> 16) + 1];
      var32.x4[0] =
          ((orc_uint8) a.x4[0] * (256 - ((tmp >> 8) & 0xff)) +
          (orc_uint8) b.x4[0] * ((tmp >> 8) & 0xff)) >> 8;
      var32.x4[1] =
          ((orc_uint8) a.x4[1] * (256 - ((tmp >> 8) & 0xff)) +
          (orc_uint8) b.x4[1] * ((tmp >> 8) & 0xff)) >> 8;
      var32.x4[2] =
          ((orc_uint8) a.x4[2] * (256 - ((tmp >> 8) & 0xff)) +
          (orc_uint8) b.x4[2] * ((tmp >> 8) & 0xff)) >> 8;
      var32.x4[3] =
          ((orc_uint8) a.x4[3] * (256 - ((tmp >> 8) & 0xff)) +
          (orc_uint8) b.x4[3] * ((tmp >> 8) & 0xff)) >> 8;
    }
    /* 1: storel */
    ptr0[i] = var32;
  }

}

#else
static void
_backup_video_orc_resample_bilinear_u32 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var32;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_union32 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: ldreslinl */
    {
      int tmp = ex->params[24] + i * ex->params[25];
      orc_union32 a = ptr4[tmp >> 16];
      orc_union32 b = ptr4[(tmp >> 16) + 1];
      var32.x4[0] =
          ((orc_uint8) a.x4[0] * (256 - ((tmp >> 8) & 0xff)) +
          (orc_uint8) b.x4[0] * ((tmp >> 8) & 0xff)) >> 8;
      var32.x4[1] =
          ((orc_uint8) a.x4[1] * (256 - ((tmp >> 8) & 0xff)) +
          (orc_uint8) b.x4[1] * ((tmp >> 8) & 0xff)) >> 8;
      var32.x4[2] =
          ((orc_uint8) a.x4[2] * (256 - ((tmp >> 8) & 0xff)) +
          (orc_uint8) b.x4[2] * ((tmp >> 8) & 0xff)) >> 8;
      var32.x4[3] =
          ((orc_uint8) a.x4[3] * (256 - ((tmp >> 8) & 0xff)) +
          (orc_uint8) b.x4[3] * ((tmp >> 8) & 0xff)) >> 8;
    }
    /* 1: storel */
    ptr0[i] = var32;
  }

}

void
video_orc_resample_bilinear_u32 (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int p1, int p2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 31, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 114, 101, 115,
        97, 109, 112, 108, 101, 95, 98, 105, 108, 105, 110, 101, 97, 114, 95,
            117,
        51, 50, 11, 4, 4, 12, 4, 4, 16, 4, 16, 4, 51, 0, 4, 24,
        25, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p,
          _backup_video_orc_resample_bilinear_u32);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_resample_bilinear_u32");
      orc_program_set_backup_function (p,
          _backup_video_orc_resample_bilinear_u32);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_parameter (p, 4, "p1");
      orc_program_add_parameter (p, 4, "p2");

      orc_program_append_2 (p, "ldreslinl", 0, ORC_VAR_D1, ORC_VAR_S1,
          ORC_VAR_P1, ORC_VAR_P2);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_merge_linear_u8 */
#ifdef DISABLE_ORC
void
video_orc_merge_linear_u8 (orc_uint8 * ORC_RESTRICT d1,
    const orc_uint8 * ORC_RESTRICT s1, const orc_uint8 * ORC_RESTRICT s2,
    int p1, int n)
{
  int i;
  orc_int8 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
  const orc_int8 *ORC_RESTRICT ptr5;
  orc_int8 var36;
  orc_int8 var37;
  orc_union16 var38;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var39;
#else
  orc_union16 var39;
#endif
  orc_int8 var40;
  orc_int8 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_int8 var47;

  ptr0 = (orc_int8 *) d1;
  ptr4 = (orc_int8 *) s1;
  ptr5 = (orc_int8 *) s2;

  /* 6: loadpw */
  var38.i = p1;
  /* 8: loadpw */
  var39.i = (int) 0x00000080;   /* 128 or 6.32404e-322f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var41 = ptr4[i];
    /* 1: loadb */
    var36 = ptr4[i];
    /* 2: convubw */
    var42.i = (orc_uint8) var36;
    /* 3: loadb */
    var37 = ptr5[i];
    /* 4: convubw */
    var43.i = (orc_uint8) var37;
    /* 5: subw */
    var44.i = var43.i - var42.i;
    /* 7: mullw */
    var45.i = (var44.i * var38.i) & 0xffff;
    /* 9: addw */
    var46.i = var45.i + var39.i;
    /* 10: convhwb */
    var47 = ((orc_uint16) var46.i) >> 8;
    /* 11: addb */
    var40 = var47 + var41;
    /* 12: storeb */
    ptr0[i] = var40;
  }

}

#else
static void
_backup_video_orc_merge_linear_u8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_int8 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
  const orc_int8 *ORC_RESTRICT ptr5;
  orc_int8 var36;
  orc_int8 var37;
  orc_union16 var38;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__)
  volatile orc_union16 var39;
#else
  orc_union16 var39;
#endif
  orc_int8 var40;
  orc_int8 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_int8 var47;

  ptr0 = (orc_int8 *) ex->arrays[0];
  ptr4 = (orc_int8 *) ex->arrays[4];
  ptr5 = (orc_int8 *) ex->arrays[5];

  /* 6: loadpw */
  var38.i = ex->params[24];
  /* 8: loadpw */
  var39.i = (int) 0x00000080;   /* 128 or 6.32404e-322f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var41 = ptr4[i];
    /* 1: loadb */
    var36 = ptr4[i];
    /* 2: convubw */
    var42.i = (orc_uint8) var36;
    /* 3: loadb */
    var37 = ptr5[i];
    /* 4: convubw */
    var43.i = (orc_uint8) var37;
    /* 5: subw */
    var44.i = var43.i - var42.i;
    /* 7: mullw */
    var45.i = (var44.i * var38.i) & 0xffff;
    /* 9: addw */
    var46.i = var45.i + var39.i;
    /* 10: convhwb */
    var47 = ((orc_uint16) var46.i) >> 8;
    /* 11: addb */
    var40 = var47 + var41;
    /* 12: storeb */
    ptr0[i] = var40;
  }

}

void
video_orc_merge_linear_u8 (orc_uint8 * ORC_RESTRICT d1,
    const orc_uint8 * ORC_RESTRICT s1, const orc_uint8 * ORC_RESTRICT s2,
    int p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 25, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 109, 101, 114,
        103, 101, 95, 108, 105, 110, 101, 97, 114, 95, 117, 56, 11, 1, 1, 12,
        1, 1, 12, 1, 1, 14, 4, 128, 0, 0, 0, 16, 1, 20, 2, 20,
        2, 20, 1, 20, 1, 43, 34, 4, 150, 32, 4, 150, 33, 5, 98, 33,
        33, 32, 89, 33, 33, 24, 70, 33, 33, 16, 158, 35, 33, 33, 0, 35,
        34, 2, 0,
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_merge_linear_u8);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_merge_linear_u8");
      orc_program_set_backup_function (p, _backup_video_orc_merge_linear_u8);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_constant (p, 4, 0x00000080, "c1");
      orc_program_add_parameter (p, 1, "p1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 1, "t3");
      orc_program_add_temporary (p, 1, "t4");

      orc_program_append_2 (p, "loadb", 0, ORC_VAR_T3, ORC_VAR_S1, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "subw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convhwb", 0, ORC_VAR_T4, ORC_VAR_T2, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addb", 0, ORC_VAR_D1, ORC_VAR_T4, ORC_VAR_T3,
          ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->arrays[ORC_VAR_S2] = (void *) s2;
  ex->params[ORC_VAR_P1] = p1;

  func = c->exec;
  func (ex);
}
#endif
