/* $Id: pulseutil.c 48 2006-07-14 15:45:00Z lennart $ */

/***
  This file is part of gst-pulse.
 
  gst-pulse is free software; you can redistribute it and/or modify
  it under the terms of the GNU Lesser General Public License as
  published by the Free Software Foundation; either version 2.1 of the
  License, or (at your option) any later version.
 
  gst-pulse is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details.
 
  You should have received a copy of the GNU Lesser General Public
  License along with gst-pulse; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
  USA.
***/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "pulseutil.h"

gboolean gst_pulse_fill_sample_spec(GstRingBufferSpec *spec, pa_sample_spec *ss) {

    if (spec->format == GST_MU_LAW && spec->width == 8)
        ss->format = PA_SAMPLE_ULAW;
    else if (spec->format == GST_A_LAW && spec->width == 8)
        ss->format = PA_SAMPLE_ALAW;
    else if (spec->format == GST_U8 && spec->width == 8)
        ss->format = PA_SAMPLE_U8;
    else if (spec->format == GST_S16_LE && spec->width == 16)
        ss->format = PA_SAMPLE_S16LE;
    else if (spec->format == GST_S16_BE && spec->width == 16)
        ss->format = PA_SAMPLE_S16BE;
    else if (spec->format == GST_FLOAT32_LE && spec->width == 32)
        ss->format = PA_SAMPLE_FLOAT32LE;
    else if (spec->format == GST_FLOAT32_BE && spec->width == 32)
        ss->format = PA_SAMPLE_FLOAT32BE;
    else
        return FALSE;

    ss->channels = spec->channels;
    ss->rate = spec->rate;

    if (!pa_sample_spec_valid(ss))
        return FALSE;

    return TRUE;
}

gchar *gst_pulse_client_name(void) {
    gchar buf[PATH_MAX];
    
    if (pa_get_binary_name(buf, sizeof(buf)))
        return g_strdup_printf("gstreamer[%s]", buf);
    else
        return g_strdup("gstreamer");
}
