/*
 * Copyright (C) 1997,98 Free Software Foundation
 * Copyright (C) 1995 Eric M. Ludlam
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, you can either send email to this
 * program's author (see below) or write to:
 *
 *              The Free Software Foundation, Inc.
 *              675 Mass Ave.
 *              Cambridge, MA 02139, USA. 
 *
 * Please send bug reports, etc. to zappo@gnu.org.
 *
 * Purpose:
 *  This file contains functions used to handle ringer file activity.
 * It will initially start with simply reporting to the parent process
 * the presence of a ringer activity, to eventually answering the
 * call's itself.  Of couse, the decision to answer an incomming call
 * should be made by the user, so that feature may never arrive.
 * 
 * $Log: gt_ring.c,v $
 * Revision 1.8  1998/10/17 22:15:51  zappo
 * Removed stale code (return ring informatin)
 * Added code to grab the host out of the updated ringer message.
 *
 * Revision 1.7  1997/12/14 19:16:50  zappo
 * Renamed package to gtalk, renamed symbols and files apropriately
 * Fixed copyright and email address.
 *
 * Revision 1.6  1995/11/26 23:58:15  zappo
 * Ringer now asks if we wish to talk to the ringee.  No longer send
 * RINGER code when in Socket mode. (Now obsolete)
 *
 * Revision 1.5  1995/09/29  09:10:22  zappo
 * Removed traces of ringer response message
 *
 * Revision 1.4  1995/09/22  13:45:49  zappo
 * Added code so that the ringer now works with the gui interface as
 * well.
 *
 * Revision 1.3  1995/03/25  03:38:24  zappo
 * Update copyright.
 *
 * Revision 1.2  1995/02/01  03:36:53  zappo
 * Fixed ringer so it works.
 *
 * Revision 1.1  1995/01/30  22:46:15  zappo
 * Initial revision
 *
 * ::Header:: gtalkc.h
 */
#include "gtalklib.h"
#include "gtalkc.h"
#include "talk.h"
#include "gtalk.h"

GNU_RING_CONTROL rc;


/*
 * Function: ETR_read
 *
 *   Reads from DEV one ringer control structure.  This structure
 * supposedly contains information relavent to an ANNOUNCE as produced
 * by a talk daemon.
 *
 * Returns:     Nothing
 * Parameters:  Ctxt - Context
 *              dev  - Pointer to device
 * History:
 * zappo   1/29/95    Created
 * zappo   10/16/98   Removed creating new udp for ringer return since we
 *                    don't do that anymore.
 */
void ETR_read(Ctxt, dev)
     struct TalkContext *Ctxt;
     struct InputDevice *dev;
{
  struct HostObject *host;

  GT_recv(dev, &rc, sizeof(rc));

  /* Fix byte swapping in the family so we can use this address. */
  ((struct sockaddr_in *)&rc.addr)->sin_family = 
    ntohs(((struct sockaddr_in *)&rc.addr)->sin_family);
  ((struct sockaddr_in *)&rc.raddr)->sin_family = 
    ntohs(((struct sockaddr_in *)&rc.raddr)->sin_family);

  host = HOST_gen_host_by_addr(&rc.raddr, sizeof(struct sockaddr_in));

  /* Print this if we are in socket mode only */
  if(Ctxt->runstate == Socket)
    RING_print_control(&rc);

  if(Ctxt->querynewtcp == AlwaysConnect)
    {
      /* Now, we could read the information from the announcement, and
	 call LOCAL_new_user_tty, but the _reply function already
	 handles all the tough bookeeping part, so just call that */
      PROTOCOL_reply(Ctxt);
    }
  else if(Ctxt->querynewtcp == QueryConnect)
    {
      char qbuff[100];
      sprintf(qbuff, "User %s@%s is calling, answer?", rc.name, host->name);
      if(DISP_yes_or_no(Ctxt, qbuff))
	PROTOCOL_reply(Ctxt);
    }

  return;
}

