/* gt_xgui.c - GUI generic display driver
 *
 * Copyright (C) 1997, 1998, 1999 Free Software Foundation
 * Copyright (C) 1995, 1996 Eric M. Ludlam
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, you can either send email to this
 * program's author (see below) or write to:
 * 
 *              The Free Software Foundation, Inc.
 *              675 Mass Ave.
 *              Cambridge, MA 02139, USA. 
 * 
 * Please send bug reports, etc. to zappo@gnu.org.
 * 
 * Description:
 * 
 *  This file contains gui independent code common between all widget
 * sets.  The concepts are window system specific, but the code is
 * non-specific.
 * 
 * $Log: gt_xgui.c,v $
 * Revision 1.4  1999/11/29 17:05:47  zappo
 * Converted old crypt code into generic filter code.
 *
 * Revision 1.3  1999/08/26 11:58:54  zappo
 * Added eightbit toggle menu item.
 *
 * Revision 1.2  1998/09/22 13:48:43  zappo
 * Added a menu item to add routes.
 *
 * Revision 1.1  1998/04/26 15:08:40  zappo
 * Initial revision
 * 
 */
#include "gtalklib.h"
#include "gtalkc.h"

struct MenuItemConstructor {
  char           *button_name;
  char           *describe;
  void          (*callback)();
  void           *data;
};

extern void simulate_key_callback();


/*
 * Function: X_make_menus
 *
 *   This function is called from the widget control file since the
 * menus will always be the same across multiple X widget interfaces.
 *
 * Returns:     Nothing
 * Parameters:  parent - Widget parent to place menu buttons in
 *
 * History:
 * zappo   9/22/95    Created
 */
void X_make_menus(parent)
     void *parent;
{
  static struct MenuItemConstructor file[] =
    {
      { "Fix Windows   (M-f)", "Resize windows to be similar sizes",
	simulate_key_callback, "\033f" },
/*      { "Reload Hosts", "Reload hosts names from default",
	  (XtCallbackProc)simulate_key_callback, "\033xREAD\n" }, */
      { "Quit          (M-q)", "Exit GNU talk",
	simulate_key_callback, "\033q" }
    };

  static struct MenuItemConstructor talkcmds[] =
    {
      { "Call user            (M-c)", "Call the specified user",
	simulate_key_callback, "\033c" },
      { "Reply                (M-r)", "Reply to a recent talk request",
	simulate_key_callback, "\033r" },
      { "Toggle Ringer        (M-R)", "Toggle ringer activation on/off",
	simulate_key_callback, "\033R" },
      { "Toggle Accept Method (M-T)", "Toggle connection accept method never/always/query",
	simulate_key_callback, "\033T" },
      { "Toggle 8-bit display      ", "Toggle 8 bit character display in talk window.",
	simulate_key_callback, "\033xset eightbit\n"},
      { "Abort call           (M-a)", "Abort any currently active call",
	simulate_key_callback, "\033a" },
      { "Hangup               (M-H)", "Hanup all active calls",
	simulate_key_callback, "\033H" },
      { "Command Prompt       (M-x)", "Enter a GNU talk command",
	simulate_key_callback, "\033x" },
    };

  static struct MenuItemConstructor interactivecmds[] =
  {
      { "Send File...           (M-s)", "Send a file to someone.",
	simulate_key_callback, "\033s" },
      { "Start Application...   (M-A)", "Start a shared application with someone.",
	simulate_key_callback, "\033A" },
      { "Filter Connection...   (M-F)", "Enable a filter on an outbound connection.",
	simulate_key_callback, "\033F" },
      { "Minibuffer message...  (M-M)", "Send a message to a remote user's minibuffer.",
	simulate_key_callback, "\033M" },
      { "Set download path...   (M-D)", "Set the path for files sent by peers.",
	simulate_key_callback, "\033D" },
  };

  static struct MenuItemConstructor statuscmds[] =
    {
      { "Version", "Display version information",
	simulate_key_callback, "\033xSHOW VERSION\n" },
      { "Status", "Display current status of important variables",
	simulate_key_callback, "\033xSHOW STATUS\n" },
      { "Hosts", "List details of all active hosts",
	simulate_key_callback, "\033xSHOW HOST\n" },
      { "Devices", "List details of all active IO devices",
	simulate_key_callback, "\033xSHOW DEVICE\n" },
      { "Users", "List details of all users",
	simulate_key_callback, "\033xSHOW USERS\n" },
      { "Routes", "List all active IP routes and networks",
	simulate_key_callback, "\033xSHOW ROUTE\n" },
      { "Associations", "List application associations",
	simulate_key_callback, "\033xSHOW ASSOC\n" },
      { "Shared Apps", "List multi-user applications",
	simulate_key_callback, "\033xSHOW SHARED\n" },
      { "Jobs", "List all subprocess and states",
	simulate_key_callback, "\033xSHOW JOBS\n" },
    };

  static struct MenuItemConstructor helpcmds[] =
    {
      { "Copyright", "What you can do with GNU talk",
	simulate_key_callback, "\033xSHOW COPYRIGHT\n" },
      { "GUI commands  (M-h)", "Help for GUI keys",
	simulate_key_callback, "\033h" },
      { "Commands", "Help with string commands",
	simulate_key_callback, "\033xHELP\n" },
      { "Set Commands", "Help with string commands under SET",
	simulate_key_callback, "\033xSET HELP\n" },
      { "Show Commands", "Help with string commands under SHOW",
	simulate_key_callback, "\033xSHOW HELP\n" },
      { "Filter Methods", "Filter methods available",
	simulate_key_callback, "\033xFILTER HELP\n" },
    };

  /* Put some menu items into it */
  XW_build_menu(parent, "File", file, 
		sizeof(file)/sizeof(struct MenuItemConstructor));
  XW_build_menu(parent, "Talk", talkcmds,
		sizeof(talkcmds)/sizeof(struct MenuItemConstructor));
  XW_build_menu(parent, "Tools", interactivecmds,
		sizeof(interactivecmds)/sizeof(struct MenuItemConstructor));
  XW_build_menu(parent, "Status", statuscmds,
		sizeof(statuscmds)/sizeof(struct MenuItemConstructor));
  XW_build_menu(parent, "Help", helpcmds,
		sizeof(helpcmds)/sizeof(struct MenuItemConstructor));
  
}
