/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  GThumb
 *
 *  Copyright (C) 2001 The Free Software Foundation, Inc.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Street #330, Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <gtk/gtkclist.h>
#include "file-data.h"


GList *
clist_utils_get_file_list_selection (GtkCList *clist)
{
	gint row;
	FileData *fd;
	GList *scan, *file_list;

	file_list = NULL;
	for (scan = clist->selection; scan; scan =  scan->next) {
		row = GPOINTER_TO_INT (scan->data);
		fd = gtk_clist_get_row_data (clist, row);
		file_list = g_list_prepend (file_list, g_strdup (fd->path));
	}

	return g_list_reverse (file_list);
}


gboolean 
clist_utils_row_is_selected (GtkCList *clist, 
			     gint row)
{
        GList *scan;

	for (scan = clist->selection; scan; scan = scan->next)
                if (GPOINTER_TO_INT (scan->data) == row) 
			return TRUE;

        return FALSE;
}


gboolean
clist_utils_only_one_is_selected (GtkCList *clist)
{
	if (clist->selection == NULL)
		return FALSE;

	return (clist->selection->next == NULL);
}


gboolean
clist_utils_selection_not_null (GtkCList *clist)
{
	return (clist->selection != NULL);
}


gint
clist_utils_get_first_selected_row (GtkCList *clist)
{
	gint row;

	row = -1;
	if (clist->selection != NULL) {
		GList *scan = clist->selection;

		row = GPOINTER_TO_INT (scan->data);
		scan = scan->next;
		for (; scan; scan = scan->next) 
			row = MIN (row, GPOINTER_TO_INT (scan->data));
	}

	return row;
}
