/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  GThumb
 *
 *  Copyright (C) 2001 The Free Software Foundation, Inc.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Street #330, Boston, MA 02111-1307, USA.
 */

#ifndef PREFERENCES_H
#define PREFERENCES_H

#include <glib.h>
#include <gdk/gdktypes.h>  /* for GdkColor */
#include "bookmarks.h"
#include "catalog-png-exporter.h"
#include "typedefs.h"
#include "image-viewer.h"


typedef struct {
	/* This can be the startup location or a directory specified in the 
	 * command line. */
	gchar *starting_location;

	/* Startup location. */
	gboolean go_to_last_location : 1;
	gboolean use_startup_location : 1;
	gchar   *startup_location;

	/* Confirmations. */
	gboolean confirm_file_del : 1;
	gboolean confirm_catalog_del : 1;

	/* Filter options. */
	gboolean show_dot_files : 1;        /* whether to show hidden files. */
	gboolean show_comments : 1;         
	gboolean fast_file_type : 1;        /* get file type only by 
					     * extension. */

	/* Thumbnails options. */
	gboolean enable_thumbnails : 1;     /* whether to show thumbnails
					     * in the file list. */
	gboolean enable_thumb_caching : 1;  /* whether to save thumbnails. */
	gint thumb_size;
	guint thumb_quality : 1;            /* 0 : High quality.
					     * 1 : Low quality. */

	/* History options. */
	gint history_max_length;

	/* Viewer options. */
	guint zoom_quality : 1;             /* 0 : High quality.
					     * 1 : Low quality. */

	guint zoom_change : 2;              /* 0 : set zoom to actual size.
					     * 1 : fit image.
					     * 2 : keep previous.
					     * 3 : fit image if larger. */
	TranspType transp_type;
	CheckType  check_type;
	CheckSize  check_size;

	/* Slide Show. */
	guint ss_direction : 1;             /* 0 : forward.
					     * 1 : reverse. */
	gint ss_delay;                      /* delay in seconds. */
	gboolean ss_wrap_around : 1;        /* whether to restart when
					     * finished. */

	/* Sort type. */
	SortMethod file_list_sort;
	GtkSortType file_list_sort_type;    /* ascending or discending. */

	/* Visualization options. */
	guint layout_type : 2;
	ToolbarStyle toolbar_style;
	gboolean location_on_main_bar;
	gint main_win_width;
	gint main_win_height;
	gint sidebar_width;
	gint sidebar_content_height;

	Bookmarks *bookmarks;
	Bookmarks *history;

	gboolean menu_have_tearoff;

	/* Wallpaper options. */
	gchar *wallpaper;
	gchar *wallpapers_dir;
	int    wallpaperAlign;
} Preferences;


typedef struct {
	/* Page. */
	GdkColor    bg_color;
	SortMethod  sort_method;
	GtkSortType sort_type;    /* ascending or discending. */
	
	gint      page_width;
	gint      page_height;
	gboolean  size_use_row_col;
	gint      page_rows;
	gint      page_cols;
	gboolean  all_pages_same_size;

	/* Thumbnail. */
	CaptionFields  caption;
	FrameStyle     frame_style;
	GdkColor       frame_color;
	gint           thumb_size;
	GdkColor       text_color;
	gchar *        text_font;

	gboolean       write_imap;
} PngExporterPref;


void            preferences_init                      ();

void            preferences_release                   ();

void            preferences_set_default_values        ();

void            preferences_load                      ();

void            preferences_save                      ();

const gchar *   pref_util_get_file_location           (const gchar *location);

const gchar *   pref_util_get_catalog_location        (const gchar *location);

const gchar *   pref_util_get_search_location         (const gchar *location);

gboolean        pref_util_location_is_file            (const gchar *location);

gboolean        pref_util_location_is_catalog         (const gchar *location);

gboolean        pref_util_location_is_search          (const gchar *location);

const gchar *   pref_util_remove_prefix               (const gchar *location);


#endif /* PREFERENCES_H */
