/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  GThumb
 *
 *  Copyright (C) 2001 The Free Software Foundation, Inc.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Street #330, Boston, MA 02111-1307, USA.
 */

#ifndef __GEDO_VPANED_H__
#define __GEDO_VPANED_H__


#include <gdk/gdk.h>
#include "gedo-paned.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define GEDO_VPANED(obj)          GTK_CHECK_CAST (obj, gedo_vpaned_get_type (), GedoVPaned)
#define GEDO_VPANED_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, gedo_vpaned_get_type (), GedoVPanedClass)
#define GEDO_IS_VPANED(obj)       GTK_CHECK_TYPE (obj, gedo_vpaned_get_type ())


typedef struct _GedoVPaned       GedoVPaned;
typedef struct _GedoVPanedClass  GedoVPanedClass;

struct _GedoVPaned
{
  GedoPaned paned;
};

struct _GedoVPanedClass
{
  GedoPanedClass parent_class;
};


guint      gedo_vpaned_get_type (void);
GtkWidget* gedo_vpaned_new      (void);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GEDO_VPANED_H__ */
