#include <gtk/gtk.h>
#include <gmodule.h>

/* Default stuff */
#define DEFAULT_SCROLLSHAPE       SCROLL_SHAPED
#define DEFAULT_SCROLLBARMARKS    MARKS_ON 
#define DEFAULT_SCROLLBUTTONMARKS MARKS_ON
#define DEFAULT_HANDLEBOXMARKS    MARKS_ON
#define DEFAULT_MARKTYPE1         1
#define DEFAULT_MARKTYPE2         1

#define DEFAULT_SLIDER_WIDTH      11
#define DEFAULT_MIN_SLIDER_SIZE   9
#define SMALLEST_HANDLE           17

typedef struct
  {
    guint scrollbar_type:1;
    guint scrollbar_marks:1;
    guint scroll_button_marks:1;
    guint handlebox_marks:1;
    guint mark_type1;
    guint mark_type2;
  }
ThemeRcData;

typedef struct
  {
    guint scrollbar_type:1;
    guint scrollbar_marks:1;
    guint scroll_button_marks:1;
    guint handlebox_marks:1;
    guint mark_type1;
    guint mark_type2;
  }
ThemeStyleData;

enum
  {
    TOKEN_RECTSCROLLBAR = G_TOKEN_LAST + 1,
    TOKEN_SCROLLBARMARKS,
    TOKEN_SCROLLBUTTONMARKS,
    TOKEN_HANDLEBOXMARKS,
    TOKEN_MARKTYPE1,
    TOKEN_MARKTYPE2,

    TOKEN_TRUE,
    TOKEN_FALSE,

    TOKEN_NOTHING,
    TOKEN_SLASH,
    TOKEN_INVSLASH,
    TOKEN_DOT,
    TOKEN_INVDOT
  };
  
enum
  {
    SCROLL_SHAPED = 0,
    SCROLL_RECT = 1,

    MARKS_ON = 0,
    MARKS_OFF = 1,

    MARKS_NOTHING = 0,
    MARKS_SLASH = 1,
    MARKS_INVSLASH = 2,
    MARKS_DOT = 3,
    MARKS_INVDOT = 4
  };

