/***************************************************************************
 *            docklet.c
 *
 *  Sun Nov 30 21:10:10 2003
 *  Copyright  2003  Stefan Strigler
 *  steve@zeank.in-berlin.de
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 ****************************************************************************/
#include <gtk/gtk.h>
#include "docklet.h"
#include "callbacks.h"
#include "eggtrayicon.h"
#include "support.h"

EggTrayIcon *docklet;
GtkWidget *image;

static void
docklet_clicked_cb(GtkWidget *button, GdkEventButton *event, void *data)
{
	GtkWidget *widget;
	
	if (event->type != GDK_BUTTON_PRESS)
		return;

	switch (event->button) {
	case 1: /* left mouse button */
		if (is_mini) 
			widget = gtk_miniimonc;
		else
			widget = gtk_imonc;			
	
		if (main_is_hidden) {
			gtk_window_move (GTK_WINDOW(widget), root_x, root_y);	
			gtk_widget_show (widget);
		} else {
				gtk_window_get_position (GTK_WINDOW(widget), &root_x, &root_y);
				gtk_widget_hide (widget);
		}
		main_is_hidden = !main_is_hidden;
		break;
	case 3:
		gtk_menu_popup (GTK_MENU (rightclick_menu), NULL, NULL, NULL, NULL,
										event->button, event->time);
		break;
	}
}

void
docklet_init() 
{
		GtkWidget *box;

		docklet = egg_tray_icon_new("gtkimonc");

		box = gtk_event_box_new();
		image = gtk_image_new();

		g_signal_connect(G_OBJECT(box), "button-press-event", G_CALLBACK(docklet_clicked_cb), NULL);

		/*image = create_pixmap(image, "docklet-online.png");*/

		gtk_container_add(GTK_CONTAINER(box), image);
		gtk_container_add(GTK_CONTAINER(docklet), box);
		gtk_widget_show_all(GTK_WIDGET(docklet));
	
		/* ref the docklet before we bandy it about the place */
		g_object_ref(G_OBJECT(docklet));
}			

void
docklet_update_icon(enum docklet_status icon)
{
	gchar *icon_name = "";
	switch (icon) {
	case offline:
		icon_name = "docklet-offline.png";
		break;
	case online:
		icon_name = "docklet-online.png";
		break;
  case inactive:
    icon_name = "docklet-inactive.png";
    break;
	}
	
/* 	image = create_pixmap(image, icon_name); */
	gtk_image_set_from_file(GTK_IMAGE(image),find_pixmap_file(icon_name));
}

void
docklet_destroy()
{
/* 	g_signal_handlers_disconnect_by_func(G_OBJECT(docklet), G_CALLBACK(docklet_x11_destroyed_cb), NULL); */
	gtk_widget_destroy(GTK_WIDGET(docklet));

	g_object_unref(G_OBJECT(docklet));
	docklet = NULL;
}
