/*
 *   Copyright (C) 2007-2009 Tristan Heaven <tristanheaven@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License along
 *   with this program; if not, write to the Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef _PROPERTIES_H_
#define _PROPERTIES_H_

#include <stdbool.h>
#include <stdint.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <mhash.h>

#if ENABLE_NLS
	#include <glib/gi18n-lib.h>
#else
	#define _(X) (X)
#endif

#define HASH_FUNCS_N 27

struct page_s {
	char *uri;
	GtkWidget *box;
	GtkProgressBar *progressbar;
	GtkTreeView *treeview;
	GtkCellRendererToggle *cellrendtoggle;
	GtkMenu *menu;
	GtkImageMenuItem *menuitem_copy;
	GtkCheckMenuItem *menuitem_show_funcs;
	GtkButton *button_hash, *button_stop;
	struct {
		GFile *file;
		GFileInputStream *stream;
		goffset file_size;
		goffset total_read;
		gssize just_read;
		uint8_t *buffer;
		uint8_t func_pos;
		GTimer *timer;
		struct {
			GMutex *mutex;
			unsigned int source;
			bool stop;
			enum hash_state_e {
				HASH_STATE_INIT,
				HASH_STATE_OPEN,
				HASH_STATE_GET_SIZE,
				HASH_STATE_READ,
				HASH_STATE_HASH,
				HASH_STATE_REPORT,
				HASH_STATE_CLOSE,
				HASH_STATE_END,
				HASH_STATE_DONE,
			} state;
		} priv;
		struct {
			MHASH thread;
			bool enabled;
			char *digest;
		} funcs[HASH_FUNCS_N];
	} hash;
};

void gtkhash_properties_idle(struct page_s *page);

#endif // _PROPERTIES_H_
