#include <config.h>

#include "output.h"

#include <stdio.h>
#include <ctype.h>
#include <gtk/gtk.h>

#include <gettext.h>
#include <libgtklp.h>

#include "gtklp.h"
#include "gtklp_functions.h"

#include "black.xpm"
#include "white.xpm"

GSList *rangeButtons,*sheetsButtons;
GtkWidget *outputTab;
GtkWidget *rangesFrame, *rangeCheck, *rangeText;
GtkWidget *sheetsFrame;
GtkWidget *landscapeCheck;
GtkWidget *brightFrame,*gammaFrame;
GtkObject *brightAdj,*gammaAdj;

void outputTabSetDefaults(void)
{
	if(DEBUG)
		printf("Get outputTabDefaults\n");

	/* Range Text */
	gtk_entry_set_text(GTK_ENTRY (rangeText),Range);
	if(wantRange)
	{
		gtk_widget_show(rangeText);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(rangeCheck),1);
	}
	else
        {
                gtk_widget_hide(rangeText);
                gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(rangeCheck),0);
        }
	/* Range Buttons */
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(g_slist_nth_data(rangeButtons,rangeType)),TRUE);
	/* Sheets Type */
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(g_slist_nth_data(sheetsButtons,sheetsType)),TRUE);
	/* Landscape */
        if(wantLandscape)
        {
                gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(landscapeCheck),1);
        }
        else
        {
                gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(landscapeCheck),0);
        }
	/* Brightness */
	gtk_adjustment_set_value(GTK_ADJUSTMENT(brightAdj),(int)brightness);	
	/* Gamma */
	gtk_adjustment_set_value(GTK_ADJUSTMENT(gammaAdj),(int)gamma);

}

void rangeCheckChanged(GtkWidget *widget,gpointer data)
{
	if(DEBUG)
		printf("rangeChanged:%i\n",gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(rangeCheck)));
	if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(rangeCheck)))
	{
		gtk_widget_hide(rangeText);
		wantRange=0;
	}
	else
	{
		gtk_widget_show(rangeText);
		wantRange=1;
	}
}

void rangeTextChanged(GtkWidget *widget,gpointer data)
{
        unsigned char tmp[MAXRANGEENTRY+1];
        int i1,flg=0;

        strncpy(tmp,gtk_editable_get_chars(GTK_EDITABLE(rangeText),0,-1),(size_t)MAXRANGEENTRY);
        if(DEBUG)
                printf("rangeText: %s\n",tmp);

        for(i1=0; i1<strlen(tmp);i1++)
        {
                if((isdigit(tmp[i1]) == 0) && (tmp[i1] != ',') && (tmp[i1] != '-'))
                {
                        gtk_entry_set_text(GTK_ENTRY(rangeText),Range);
                        gtk_editable_set_position(GTK_EDITABLE(rangeText),-1);
                        flg=1;
                        break;
                }
        }
        if((flg==0) && tmp[0] != (unsigned char)NULL)
        {
                strncpy(Range,tmp,(size_t)MAXRANGEENTRY);
                if(DEBUG)
                        printf("Range: Value changed: %s\n",Range);
        }

}

void rangeButtonsChanged(GtkWidget *widget,gpointer data)
{
        if(DEBUG)
                printf("Range toggled: %s\n",(char *)data);
        if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(g_slist_nth_data(rangeButtons,2))))
        {
                if(DEBUG)
                        printf("ALL\n");
                rangeType=2;
                return;
        }
        else if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(g_slist_nth_data(rangeButtons,1))))
        {
                if(DEBUG)
                        printf("EVEN\n");
                rangeType=1;
                return;
        }
        else if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(g_slist_nth_data(rangeButtons,0))))
        {
                if(DEBUG)
                        printf("ODD\n");
                rangeType=0;
                return;
        }
        else
        {
                if(DEBUG)
                        printf("PROG-ERROR: Whats that for an range Type ?\n");
                emergency();
        }
}

void sheetsChanged(GtkWidget *widget,gpointer data)
{
        if(DEBUG)
                printf("Number of Sheets toggled: %s\n",(char *)data);
        if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(g_slist_nth_data(sheetsButtons,3))))
        {
                if(DEBUG)
                        printf("1\n");
                sheetsType=3;
                return;
        }
        else if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(g_slist_nth_data(sheetsButtons,2))))
        {
                if(DEBUG)
                        printf("2\n");
                sheetsType=2;
                return;
        }
        else if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(g_slist_nth_data(sheetsButtons,1))))
        {
                if(DEBUG)
                        printf("3\n");
                sheetsType=1;
                return;
        }
        else if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(g_slist_nth_data(sheetsButtons,0))))
        {
                if(DEBUG)
                        printf("4\n");
                sheetsType=0;
                return;
        }
        else
        {
                if(DEBUG)
                        printf("PROG_ERROR: Whats that for an sheet Type ?\n");
                emergency();
        }
}

void landscapeCheckChanged(GtkWidget *widget,gpointer data)
{
        if(DEBUG)
                printf("landscapeChanged:%i\n",gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(landscapeCheck)));
        if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(landscapeCheck)))
        {
                wantLandscape=0;
        }
        else
        {
                wantLandscape=1;
        }
}



void sheetUsageFrame(GtkWidget *container)
{
        GtkWidget *mainHBox,*hbox1,*hbox2,*vbox,*label;
        GtkWidget *button1,*button2,*button3,*button4;

        mainHBox=gtk_hbox_new(FALSE,INFRAME_SPACING_H);
        gtk_box_pack_start(GTK_BOX(container),mainHBox,FALSE, FALSE,FRAME_SPACING_V);
        gtk_widget_show(mainHBox);
        sheetsFrame=gtk_frame_new(_("Sheet Usage"));
        gtk_box_pack_start(GTK_BOX(mainHBox), sheetsFrame, TRUE, TRUE,FRAME_SPACING_V);

        vbox=gtk_vbox_new(FALSE,INFRAME_SPACING_V);
        gtk_container_add(GTK_CONTAINER(sheetsFrame), vbox);
        gtk_widget_show(vbox);

        hbox1=gtk_hbox_new(FALSE,INFRAME_SPACING_H);
        gtk_box_pack_start(GTK_BOX(vbox), hbox1, TRUE, TRUE,FRAME_SPACING_V);
        gtk_widget_show(hbox1);

        label=gtk_label_new(_("Sheets per page"));
        gtk_box_pack_start(GTK_BOX(hbox1), label, FALSE, FALSE,FRAME_SPACING_H);
        gtk_widget_show(label);

        button1=gtk_radio_button_new_with_label (NULL, _("1"));
        gtk_box_pack_start (GTK_BOX (hbox1), button1, FALSE, FALSE,FRAME_SPACING_H);
        sheetsButtons=gtk_radio_button_group (GTK_RADIO_BUTTON (button1));
        gtk_widget_show (button1);

        button2=gtk_radio_button_new_with_label(sheetsButtons,_("2"));
        gtk_box_pack_start (GTK_BOX (hbox1), button2, FALSE, FALSE,0);
        sheetsButtons=gtk_radio_button_group (GTK_RADIO_BUTTON (button2));
        gtk_widget_show (button2);

        button3=gtk_radio_button_new_with_label(sheetsButtons,_("3"));
        gtk_box_pack_start (GTK_BOX (hbox1), button3, FALSE, FALSE,0);
        sheetsButtons=gtk_radio_button_group (GTK_RADIO_BUTTON (button2));
        gtk_widget_show (button3);

        button4=gtk_radio_button_new_with_label(sheetsButtons,_("4"));
        gtk_box_pack_start (GTK_BOX (hbox1), button4, FALSE, FALSE,0);
        sheetsButtons=gtk_radio_button_group (GTK_RADIO_BUTTON (button3));
        gtk_widget_show (button4);

        gtk_signal_connect(GTK_OBJECT(button1),"toggled",GTK_SIGNAL_FUNC(sheetsChanged),"Button1");
	gtk_signal_connect(GTK_OBJECT(button2),"toggled",GTK_SIGNAL_FUNC(sheetsChanged),"Button2");
	gtk_signal_connect(GTK_OBJECT(button3),"toggled",GTK_SIGNAL_FUNC(sheetsChanged),"Button3");
	gtk_signal_connect(GTK_OBJECT(button4),"toggled",GTK_SIGNAL_FUNC(sheetsChanged),"Button4");

        hbox2=gtk_hbox_new(FALSE,INFRAME_SPACING_H);
        gtk_box_pack_start(GTK_BOX(vbox), hbox2, TRUE, TRUE,FRAME_SPACING_V);
        gtk_widget_show(hbox2);

        landscapeCheck=gtk_check_button_new_with_label(_("Landscape Mode"));
        gtk_box_pack_start(GTK_BOX(hbox2), landscapeCheck, FALSE, FALSE,FRAME_SPACING_H);
        gtk_signal_connect(GTK_OBJECT(landscapeCheck),"pressed",GTK_SIGNAL_FUNC(landscapeCheckChanged),"landscapeCheck");
        gtk_widget_show(landscapeCheck);




}

void RangesFrame(GtkWidget *container)
{
        GtkWidget *mainHBox,*hbox1,*hbox2,*vbox,*label;
	GtkWidget *button1,*button2,*button3;

        mainHBox=gtk_hbox_new(FALSE,INFRAME_SPACING_H);
        gtk_box_pack_start(GTK_BOX(container),mainHBox,FALSE, FALSE,FRAME_SPACING_V);
        gtk_widget_show(mainHBox);
        rangesFrame=gtk_frame_new(_("Ranges"));
        gtk_box_pack_start(GTK_BOX(mainHBox), rangesFrame, TRUE, TRUE,FRAME_SPACING_V);

        vbox=gtk_vbox_new(FALSE,INFRAME_SPACING_V);
        gtk_container_add(GTK_CONTAINER(rangesFrame), vbox);
        gtk_widget_show(vbox);

	hbox1=gtk_hbox_new(FALSE,INFRAME_SPACING_H);
	gtk_box_pack_start(GTK_BOX(vbox), hbox1, TRUE, TRUE,FRAME_SPACING_V);
	gtk_widget_show(hbox1);
	
	rangeCheck=gtk_check_button_new_with_label(_("Print Range"));	
	gtk_box_pack_start(GTK_BOX(hbox1), rangeCheck, FALSE, FALSE,FRAME_SPACING_H);
	gtk_signal_connect(GTK_OBJECT(rangeCheck),"pressed",GTK_SIGNAL_FUNC(rangeCheckChanged),"RangeCheck");
	gtk_widget_show(rangeCheck);

        rangeText=gtk_entry_new_with_max_length (MAXRANGEENTRY);
        gtk_widget_set_usize(rangeText,RANGE_FIELDLENGTH,-1);
        gtk_entry_set_text(GTK_ENTRY (rangeText),"");
        gtk_box_pack_start(GTK_BOX(hbox1), rangeText, FALSE, FALSE,FRAME_SPACING_V);
        gtk_widget_show(rangeText);

	label=gtk_label_new(_("(e.g. 1-4,9,10-12)"));
	gtk_box_pack_end(GTK_BOX(hbox1), label, FALSE, FALSE,FRAME_SPACING_H);
	gtk_widget_show(label);

        gtk_signal_connect(GTK_OBJECT(GTK_ENTRY(rangeText)),"changed",GTK_SIGNAL_FUNC(rangeTextChanged),NULL);

        hbox2=gtk_hbox_new(FALSE,INFRAME_SPACING_H);
        gtk_box_pack_start(GTK_BOX(vbox), hbox2, TRUE, TRUE,FRAME_SPACING_V);
        gtk_widget_show(hbox2);

        button1=gtk_radio_button_new_with_label (NULL, _("All"));
        gtk_box_pack_start (GTK_BOX (hbox2), button1, FALSE, FALSE,FRAME_SPACING_H);
        rangeButtons=gtk_radio_button_group (GTK_RADIO_BUTTON (button1));
        gtk_widget_show (button1);

        button2=gtk_radio_button_new_with_label(rangeButtons,_("Even"));
        gtk_box_pack_start (GTK_BOX (hbox2), button2, FALSE, FALSE,0);
        rangeButtons=gtk_radio_button_group (GTK_RADIO_BUTTON (button2));
        gtk_widget_show (button2);

        button3=gtk_radio_button_new_with_label(rangeButtons,_("Odd"));
        gtk_box_pack_start (GTK_BOX (hbox2), button3, FALSE, FALSE,0);
        rangeButtons=gtk_radio_button_group (GTK_RADIO_BUTTON (button2));
        gtk_widget_show (button3);

        gtk_signal_connect(GTK_OBJECT(button1),"toggled",GTK_SIGNAL_FUNC(rangeButtonsChanged),"Button1");
        gtk_signal_connect(GTK_OBJECT(button2),"toggled",GTK_SIGNAL_FUNC(rangeButtonsChanged),"Button2");
        gtk_signal_connect(GTK_OBJECT(button3),"toggled",GTK_SIGNAL_FUNC(rangeButtonsChanged),"Button3");

}

void BrightFrame(GtkWidget *container)
{
        GtkWidget *mainHBox,*hbox1,*hbox2,*vbox,*brightScale,*button1,*button2;
        GtkWidget *pixmapwid;
        GdkPixmap *pixmap;
        GdkBitmap *mask;
        GtkStyle *style;

        mainHBox=gtk_hbox_new(FALSE,INFRAME_SPACING_H);
        gtk_box_pack_start(GTK_BOX(container),mainHBox,FALSE, FALSE,FRAME_SPACING_V);
        gtk_widget_show(mainHBox);
        brightFrame=gtk_frame_new(_("Brightness"));
        gtk_box_pack_start(GTK_BOX(mainHBox), brightFrame, TRUE, TRUE,FRAME_SPACING_V);

        vbox=gtk_vbox_new(FALSE,INFRAME_SPACING_V);
        gtk_container_add(GTK_CONTAINER(brightFrame), vbox);
        gtk_widget_show(vbox);

        hbox1=gtk_hbox_new(FALSE,0);
        gtk_box_pack_start(GTK_BOX(vbox), hbox1, TRUE, TRUE,FRAME_SPACING_V);
        gtk_widget_show(hbox1);

        style = gtk_widget_get_style(mainHBox);
        pixmap = gdk_pixmap_create_from_xpm_d(mainWindow->window,  &mask, &style->bg[GTK_STATE_NORMAL], (gchar **)pixmap_black );
        pixmapwid = gtk_pixmap_new( pixmap, mask );
        gtk_box_pack_start(GTK_BOX(hbox1), pixmapwid, FALSE, FALSE, MESSAGE_SPACING_H);
        gtk_widget_show(pixmapwid);

	brightAdj=gtk_adjustment_new(0,BRIGHT_MIN,BRIGHT_MAX,BRIGHT_STEP,BRIGHT_PAGE,0);
	brightScale=gtk_hscale_new(GTK_ADJUSTMENT(brightAdj));
	gtk_scale_set_digits(GTK_SCALE(brightScale),BRIGHT_DIGIT);
	gtk_scale_set_draw_value(GTK_SCALE(brightScale),TRUE);
	gtk_scale_set_value_pos(GTK_SCALE(brightScale),GTK_POS_TOP);
	gtk_range_set_update_policy(GTK_RANGE(brightScale),GTK_UPDATE_DISCONTINUOUS);
	gtk_box_pack_start(GTK_BOX(hbox1), brightScale, TRUE, TRUE,0);
	gtk_widget_show(brightScale);

        style = gtk_widget_get_style(mainHBox);
        pixmap = gdk_pixmap_create_from_xpm_d(mainWindow->window,  &mask, &style->bg[GTK_STATE_NORMAL], (gchar **)pixmap_white );
        pixmapwid = gtk_pixmap_new( pixmap, mask );
        gtk_box_pack_start(GTK_BOX(hbox1), pixmapwid, FALSE, FALSE, MESSAGE_SPACING_H);
        gtk_widget_show(pixmapwid);

        hbox2=gtk_hbox_new(FALSE,0);
        gtk_box_pack_start(GTK_BOX(vbox), hbox2, TRUE, TRUE,FRAME_SPACING_V);
        gtk_widget_show(hbox2);

        button1=gtk_button_new_with_label(_("Default"));
        gtk_box_pack_end(GTK_BOX(hbox2), button1, FALSE, FALSE,BUTTON_SPACING_H);
        gtk_widget_show(button1);

        button2=gtk_button_new_with_label(_("Reset"));
        gtk_box_pack_end(GTK_BOX(hbox2), button2, FALSE, FALSE,0);
        gtk_widget_show(button2);

	gtk_signal_connect(GTK_OBJECT(button1),"pressed",GTK_SIGNAL_FUNC(resetButton),"BrightnessDefault");
        gtk_signal_connect(GTK_OBJECT(button2),"pressed",GTK_SIGNAL_FUNC(resetButton),"Brightness");

}

void GammaFrame(GtkWidget *container)
{
        GtkWidget *mainHBox,*hbox1,*hbox2,*vbox,*gammaScale,*button1,*button2;
	GtkWidget *pixmapwid;
	GdkPixmap *pixmap;
	GdkBitmap *mask;
	GtkStyle *style;
	

        mainHBox=gtk_hbox_new(FALSE,INFRAME_SPACING_H);
        gtk_box_pack_start(GTK_BOX(container),mainHBox,FALSE, FALSE,FRAME_SPACING_V);
        gtk_widget_show(mainHBox);
        gammaFrame=gtk_frame_new(_("Gamma correction"));
        gtk_box_pack_start(GTK_BOX(mainHBox), gammaFrame, TRUE, TRUE,FRAME_SPACING_V);

        vbox=gtk_vbox_new(FALSE,INFRAME_SPACING_V);
        gtk_container_add(GTK_CONTAINER(gammaFrame), vbox);
        gtk_widget_show(vbox);

        hbox1=gtk_hbox_new(FALSE,0);
        gtk_box_pack_start(GTK_BOX(vbox), hbox1, TRUE, TRUE,FRAME_SPACING_V);
        gtk_widget_show(hbox1);

        style = gtk_widget_get_style(mainHBox);
        pixmap = gdk_pixmap_create_from_xpm_d(mainWindow->window,  &mask, &style->bg[GTK_STATE_NORMAL], (gchar **)pixmap_black );
        pixmapwid = gtk_pixmap_new( pixmap, mask );
        gtk_box_pack_start(GTK_BOX(hbox1), pixmapwid, FALSE, FALSE, MESSAGE_SPACING_H);
	gtk_widget_show(pixmapwid);


        gammaAdj=gtk_adjustment_new(0,GAMMA_MIN,GAMMA_MAX,GAMMA_STEP,GAMMA_PAGE,0);
        gammaScale=gtk_hscale_new(GTK_ADJUSTMENT(gammaAdj));
        gtk_scale_set_digits(GTK_SCALE(gammaScale),GAMMA_DIGIT);
        gtk_scale_set_draw_value(GTK_SCALE(gammaScale),TRUE);
        gtk_scale_set_value_pos(GTK_SCALE(gammaScale),GTK_POS_TOP);
        gtk_range_set_update_policy(GTK_RANGE(gammaScale),GTK_UPDATE_DISCONTINUOUS);
        gtk_box_pack_start(GTK_BOX(hbox1), gammaScale, TRUE, TRUE,0);
        gtk_widget_show(gammaScale);

        style = gtk_widget_get_style(mainHBox);
        pixmap = gdk_pixmap_create_from_xpm_d(mainWindow->window,  &mask, &style->bg[GTK_STATE_NORMAL], (gchar **)pixmap_white );
        pixmapwid = gtk_pixmap_new( pixmap, mask );
        gtk_box_pack_start(GTK_BOX(hbox1), pixmapwid, FALSE, FALSE, MESSAGE_SPACING_H);
        gtk_widget_show(pixmapwid);

        hbox2=gtk_hbox_new(FALSE,0);
        gtk_box_pack_start(GTK_BOX(vbox), hbox2, TRUE, TRUE,FRAME_SPACING_V);
        gtk_widget_show(hbox2);

        button1=gtk_button_new_with_label(_("Default"));
        gtk_box_pack_end(GTK_BOX(hbox2), button1, FALSE, FALSE,BUTTON_SPACING_H);
        gtk_widget_show(button1);

        button2=gtk_button_new_with_label(_("Reset"));
        gtk_box_pack_end(GTK_BOX(hbox2), button2, FALSE, FALSE,0);
        gtk_widget_show(button2);

        gtk_signal_connect(GTK_OBJECT(button1),"pressed",GTK_SIGNAL_FUNC(resetButton),"GammaDefault");
        gtk_signal_connect(GTK_OBJECT(button2),"pressed",GTK_SIGNAL_FUNC(resetButton),"Gamma");

}



void OutputTab(void)
{
        outputTab=gtk_vbox_new(FALSE,0);
        gtk_notebook_append_page(GTK_NOTEBOOK(tabs), outputTab, gtk_label_new(_("Output")));

	RangesFrame(outputTab);
	sheetUsageFrame(outputTab);
	BrightFrame(outputTab);
	GammaFrame(outputTab);
}
