%option nounput
%option noyywrap
%{
#include <gnome.h>
#include "config_common.h"
#include "config_parse.h"

	char*remove_quotes(char*str, char quote) {
		char*r = g_malloc(strlen(str)*sizeof(char));
		int i;
		int j;
		g_assert(str[0] == quote);
		for(i=1, j=0; str[i]; i++) {
			if((str[i] == '\\') && (str[i+1] == quote)) { r[j++] = quote; i++; }
			else { r[j++] = str[i]; }
		}
		j--;
		g_assert(r[j] == quote);
		r[j] = '\0';
		return(r);
	}

%}

separator	[\t ]+

%%
{separator}			;

	/* not used yet
{separator}\-{separator}	{return TO;}
	*/

^[#;].*$			;

^\ *[Aa]dd[Ii]con		{yylval.string = yytext; return ADDEXTICON;}
^\ *[Aa]dd[Mm]ime[Ii]con	{yylval.string = yytext; return ADDMIMEICON;}
^\ *[Dd]efault[Ff]ile[Ii]con	{yylval.string = yytext; return DEFAULTFILEICON;}
^\ *[Dd]efault[Dd]ir[Ii]con	{yylval.string = yytext; return DEFAULTDIRICON;}
^\ *[Dd]efault[Dd]isk[Ii]con	{yylval.string = yytext; return DEFAULTDISKICON;}
^\ *[Dd]efault[Uu]nreadable[Ii]con	{yylval.string = yytext; return DEFAULTUNREADABLEICON;}
^\ *[Dd]efault[Vv][Ff][Ss][Ii]con	{yylval.string = yytext; return DEFAULTVFSICON;}
^\ *[Dd]efault[Oo]pened[Dd]ir[Ii]con	{yylval.string = yytext; return DEFAULTOPENEDDIRICON;}
^\ *[Dd]efault[Oo]pened[Dd]isk[Ii]con	{yylval.string = yytext; return DEFAULTOPENEDDISKICON;}
^\ *[Dd]efault[Oo]pened[Vv][Ff][Ss][Ii]con	{yylval.string = yytext; return DEFAULTOPENEDVFSICON;}

^\ *[Dd]isplay[Dd]ir[Ss]ize	{yylval.string = yytext; return DISPLAYDIRSIZE;}

^\ *[Mm]ount[Pp]rogram		{yylval.string = yytext; return MOUNTPROGRAM;}
^\ *[Uu]mount[Pp]rogram		{yylval.string = yytext; return UMOUNTPROGRAM;}
^\ *[Ee]ject[Pp]rogram		{yylval.string = yytext; return EJECTPROGRAM;}
^\ *[Mm]ount[Pp]oint		{yylval.string = yytext; return MOUNTPOINT;}
^\ *[Uu]se[Aa]utomount          {yylval.string = yytext; return USEAUTOMOUNT;}
^\ *[Mm]ount[Rr]etry            {yylval.string = yytext; return MOUNTRETRY;}
^\ *[Uu]se[Ss]udo               {yylval.string = yytext; return USESUDO;}

^\ *[Aa]dd[Ee]xtension		{yylval.string = yytext; return EXTENSION;}
^\ *[Aa]dd[Mm]ime[Ii]nformation	{yylval.string = yytext; return MIMEEXTENSION;}
^\ *[Dd]efault[Mm]ime[Ii]nformation	{yylval.string = yytext; return DEFAULTMIMEEXTENSION;}
^\ *[Aa]dd[Vv][Ff][Ss][Ee]xtension	{yylval.string = yytext; return VFSEXTENSION;}
^\ *[Aa]dd[Vv][Ff][Ss][Mm]ime		{yylval.string = yytext; return MIMEVFSEXTENSION;}

^\ *[Aa]dd[Mm]ime[Tt]o[Ss]kip	{yylval.string = yytext; return ADDMIMETOSKIP;}

^\ *[Oo]ption[Ee]ject           {yylval.string = yytext; return OPTIONEJECT;}
^\ *[Rr]ead[Cc][Dd][Nn]ame	{yylval.string = yytext; return READCDNAME;}
^\ *[Vv]alidate[Cc][Dd][Nn]ame	{yylval.string = yytext; return VALIDATECDNAME;}
^\ *[Oo]ption[Ww]arn[Mm]ount    {yylval.string = yytext; return OPTIONWARNMOUNT;}
^\ *[Oo]ption[Dd]us             {yylval.string = yytext; return OPTIONDUS;}
^\ *[Cc]ompression[Ll]evel      {yylval.string = yytext; return COMPRESSIONLEVEL;}

^\ *VFS[Mm]ode			{yylval.string = yytext; return TESTVFS;}
^\ *[Rr]ead[Ii]nformation       {yylval.string = yytext; return READINFORMATION;}
^\ *[Ss]can[Mm]ime[Tt]ypes	{yylval.string = yytext; return SCANMIMETYPES;}
^\ *[Uu]se[Dd]efault[Mm]ime[Pp]lugin       {yylval.string = yytext; return USEDEFAULTMIMEPLUGIN;}
^\ *[Dd]b[Cc]lick[Ff]ile[Ff]or[Ii]nfo  {yylval.string = yytext; return DBCLICKFORINFO;}
^\ *[Dd]ate[Ff]ormat            {yylval.string = yytext; return DATEFORMAT;}

^\ *[Ss]ize[Ff]ormat		{yylval.string = yytext; return SIZEFORMAT;}

^\ *[Rr]ecent[Ff]ile		{yylval.string = yytext; return RECENTFILE;}
^\ *[Rr]ecent[Ff]iles[Mm]ax	{yylval.string = yytext; return RECENTFILESMAX;}

^\ *[Pp]revious[Ss]earch[Mm]ode	{yylval.string = yytext; return PREVIOUSSEARCHMODE;}

^\ *[Ss]ave[Oo]nly[Uu]sed[Cc]ategories	{yylval.string = yytext; return SAVEONLYUSEDCATEGORIES;}

^\ *[Mm]ain[Ww]indow[Pp]osition	{yylval.string = yytext; return MAINWINDOWPOSITION;}
^\ *[Tt]ree[Ww]indow[Ss]ize	{yylval.string = yytext; return TREEWINDOWSIZE;}

^\ *[Ff]ile[Tt]o[Ll]oad		{yylval.string = yytext; return FILETOLOAD;}
^\ *[Ll]oad[Ff]ile[Aa]t[Bb]oot	{yylval.string = yytext; return LOADFILEATBOOT;}

^\ *[Aa]utosave			{yylval.string = yytext; return AUTOSAVE;}
^\ *[Kk]eep[Bb]ackup[Ff]ile	{yylval.string = yytext; return KEEPBACKUPFILE;}
^\ *[Mm]inutes[Bb]efore[Aa]utosave	{yylval.string = yytext; return MINUTESBEFOREAUTOSAVE;}

^\ *[Tt]oolbar[Ss]tyle		{yylval.string = yytext; return TOOLBARSTYLE;}
^\ *[Nn]ew[Ss]earch[Tt]ype	{yylval.string = yytext; return NEWSEARCHTYPE;}
^\ *[Dd]efault[Ww]orking[Dd]irectory	{yylval.string = yytext; return WORKINGPATH;}
^\ *[Ss]trict[Aa]lphabetic[Ss]ort	{yylval.string = yytext; return STRICTALPHABETICSORT;}

^\ *[Dd]isplay[Ss]plash		{yylval.string = yytext; return DISPLAYSPLASH;}

[Tt][rR][Uu][eE]                { yylval.gbool = TRUE; return GBOOLEAN; }
[Ff][Aa][Ll][Ss][eE]            { yylval.gbool = FALSE; return GBOOLEAN; }
[Yy][Ee][Ss]                    { yylval.gbool = TRUE; return GBOOLEAN; }
[Nn][Oo]                        { yylval.gbool = FALSE; return GBOOLEAN; }
[Nn]ormal			{ yylval.val = TEST_VFS_YES; return INTEGER; }
[Ee]xtended			{ yylval.val = TEST_VFS_EXTENDED; return INTEGER; }
[Ii]gnored                      { yylval.val = TEST_VFS_NO; return INTEGER; }
[Ll]ocale                       { yylval.val = 0; return STRINGLOCALE; }
[Ii][Ss][Oo]8601                { yylval.val = 0; return STRINGISO8601; }
[Bb][Yy][Tt][Ee][Ss]		{ yylval.sizeformat = SIZE_FORMAT_B; return SIZE_FORMAT_INT; }
[Kk][Ii][Ll][Oo][Bb][Yy][Tt][Ee][Ss]			{ yylval.sizeformat = SIZE_FORMAT_KB; return SIZE_FORMAT_INT; }
[Mm][Ee][Gg][Aa][Bb][Yy][Tt][Ee][Ss]			{ yylval.sizeformat = SIZE_FORMAT_MB; return SIZE_FORMAT_INT; }
[Gg][Ii][Gg][Aa][Bb][Yy][Tt][Ee][Ss]			{ yylval.sizeformat = SIZE_FORMAT_GB; return SIZE_FORMAT_INT; }
[Hh][Uu][Mm][Aa][Nn][Rr][Ee][Aa][Dd][Aa][Bb][Ll][Ee]	{ yylval.sizeformat = SIZE_FORMAT_HUMAN; return SIZE_FORMAT_INT; }
[Bb][Yy][Tt][Ee][Ss]_[Hh][Uu][Mm][Aa][Nn]		{ yylval.sizeformat = SIZE_FORMAT_B_HUMAN; return SIZE_FORMAT_INT; }
[Nn][Oo][Tt][Hh][Ii][Nn][Gg]		{ yylval.vfslast_column = VFS_LAST_COLUMN_NOTHING; return VFS_LAST_COLUMN_INT; }
[Ss][Ii][Zz][Ee]			{ yylval.vfslast_column = VFS_LAST_COLUMN_SIZE; return VFS_LAST_COLUMN_INT; }
[Dd][Aa][Tt][Ee]			{ yylval.vfslast_column = VFS_LAST_COLUMN_DATE; return VFS_LAST_COLUMN_INT; }
[Nn][Aa][Mm][Ee]			{ yylval.vfslast_column = VFS_LAST_COLUMN_NAME; return VFS_LAST_COLUMN_INT; }
[Tt][Ee][Xx][Tt]                { yylval.toolbarstyle = GTK_TOOLBAR_TEXT; return TOOLBAR_STYLE_INT; }
[Ii][Cc][Oo][Nn][Ss]?           { yylval.toolbarstyle = GTK_TOOLBAR_ICONS; return TOOLBAR_STYLE_INT; }
[Bb][Oo][Tt][Hh]                { yylval.toolbarstyle = GTK_TOOLBAR_BOTH; return TOOLBAR_STYLE_INT; }

-?[0-9]+			{ yylval.val = atoi(yytext); return INTEGER; }
	/* not used yet
[^ \t\n]+@[^ \t\n]+\.[^ \t\n]{2,3} { yylval.string = yytext; return EMAIL; }
	*/
\"[^"]*(\\\"[^"]*)*\"		{ yylval.string = remove_quotes(yytext,'"'); return GMALLOC_STRING; }
'[^']*(\\'[^']*)*'		{ yylval.string = remove_quotes(yytext,'\''); return GMALLOC_STRING; }
\"[^"]*\"			{ yylval.string = yytext; return QSTRING;}
'[^']*'				{ yylval.string = yytext; return QSTRING;}
[^'" \t\n]+			{ yylval.string = yytext; return STRING;}

^{separator}*\n			;
{separator}*\n			{ return EOL; }
<<EOF>>				{ return 0 ; }
%%
