#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "varman.h"
#include "preferences.h"
#include "configfile.h"

/* uncomment for debugging */
/* #define DEBUG */

typedef struct
{
   varman_varchanged callback;
   gpointer data;
} varman_varchanged_cbinfo;

/* this macro is for internal use only. It will not create a valid
 * varman entry but allocate memory for it and append it to the
 * database.
 * entry will contain a pointer to the VARMAN_VAR_ENTRY struct afterwards */
#define varman_entry_create(database,entry) \
	entry=(VARMAN_VAR_ENTRY*)malloc(sizeof(VARMAN_VAR_ENTRY)); \
	*db=g_list_append(*db,entry)

varman_database *varman_vardatabase_create_new()
{
   varman_database *db;
   
   db=(varman_database*)malloc(sizeof(varman_database));
   
   /* initialize GList */
   *db=NULL;
   
   return db;
}
;

varman_database *varman_vardatabase_create_fromfile(char *name,char *section)
{
   varman_database *db;
	
   db=(varman_database*)malloc(sizeof(varman_database));
	
   /* init GList */
   *db=NULL;
   
   varman_loaddatabase(db,name,section);
	
   return db;
}
;

/* install a change_callback function for a variable */
void varman_install_handler(varman_database *db,
			    char *name,
			    varman_varchanged handler,
			    gpointer data
			    )
{
   varman_varchanged_cbinfo *info;
   VARMAN_VAR_ENTRY *entry;
      
   info=(varman_varchanged_cbinfo*)malloc(sizeof(varman_varchanged_cbinfo));
   info->callback=handler;
   info->data=data;
   
   /* see,if there already is an entry */
   entry=varman_getentry(db,name);
   if (entry==NULL) /* if not,create new one */
     {
	
	varman_entry_create(db,entry);
	
	entry->callbacks=NULL;           /* no callbacks yet */
	strcpy(entry->varvalue,"");      /* no value yet */
	strcpy(entry->varname,name);     /* set name at least */
     }
   ;
   entry->callbacks=g_list_append(entry->callbacks,
				  (gpointer)info);
   
}
;

void varman_remove_handler(varman_database *db,
			   char *name,
			   varman_varchanged handler,
			   gpointer data)
{
   VARMAN_VAR_ENTRY *pos;
   varman_varchanged_cbinfo *info;
   GList *current;		

   /* see,if there is an entry */
   pos=varman_getentry(db,name); 
   if (pos==NULL) return; /* simply do nothing if theres no matching var */   

   current=pos->callbacks;
   while (current!=NULL)
     {
	info=(varman_varchanged_cbinfo*)current->data;
	/* get the next entry here because the reference might already be
	 * destroyed below */
	current=current->next;
	if (((info->callback==handler)||(handler==NULL)) &&
	    ((info->data==data)||(data==NULL)))
	  {
	     pos->callbacks=
	       g_list_remove(pos->callbacks,(gpointer)info);
	     free(info);
	  };
     };
}
;
	
/* callback handler for "foreach" statement */
void varman_cb_handler(gpointer data,gpointer userdata)
{
	VARMAN_VAR_ENTRY *var;
   	varman_varchanged_cbinfo *info;
	
        info=(varman_varchanged_cbinfo*)data;
	var=(VARMAN_VAR_ENTRY*)userdata;
	
	info->callback(var,info->data);
}
;		

void varman_setvar_update(varman_database *db,
			  char *name,
			  char *value,
			  int update)
{
	VARMAN_VAR_ENTRY *pos;
	int different;
	
	/* see,if there already is an entry */
	pos=varman_getentry(db,name);
	if (pos==NULL)	/* if not,create new one */
	  { 
		  varman_entry_create(db,pos);
		  
		  pos->callbacks=NULL;           /* no callbacks yet */
		  strcpy(pos->varname,name);     /* set name */
		  /* there's always a difference between a 
		   * non existing entry and a value */
		  different=1;	     
	  }
	else
	    /* only do this if we got a valid entry,
	     * otherwise we might run into trouble 
	     * comparing the two values */
	    different=strcmp(pos->varvalue,value);
	strcpy(pos->varvalue,value);		
	/* always update if update>0,
	 * update if value has changed and update==0,
	 * never update if update<0 */
	if (((update==0)&&different)
	    ||(update>0))
     {		
#ifdef DEBUG
	     printf ("varman_setvar: calling callbacks\n");
#endif
	     g_list_foreach(pos->callbacks, /* process callbacks */
			    varman_cb_handler,
			    (gpointer)pos);
     };
	/* do only call callback if value has definitely changed or
	 * the force callback option has been enabled,
	 * otherwise just take the new value and that's it */
}
;

/* this one had to be renamed utterly as there is no function overlay support
 * in normal c. former vardatabase::setvar(char *name,double value); */
void varman_setvar_value(varman_database *db,char *name,double value)
{
	char tmp[255];
   	if (value==(int)value)
           sprintf(tmp,"%.0lf",value);
        else     
           sprintf(tmp,"%lf",value);
	varman_setvar(db,name,(char*)&tmp);
}
;
	

char *varman_getvar(varman_database *db,char *name)
{
   VARMAN_VAR_ENTRY *pos;
	
   pos=varman_getentry(db,name);
   if (pos!=NULL) return pos->varvalue;
   else return NULL;
}
;

double varman_getvar_value(varman_database *db,char *name)
{
   double result;
   char *var;
   
   var=varman_getvar(db,name);
	   
   if (var!=NULL)     
     sscanf(varman_getvar(db,name),
	    "%lf",&result);
   else
     result=0;
   
   return result;
};


char *varman_getnamebyvalue(varman_database *db,char *value)
{
   VARMAN_VAR_ENTRY *pos;
   
   pos=varman_getentrybyvalue(db,value);
   if (pos!=NULL) return pos->varname;
   else return NULL;
}
;

/* replace variable in String by its value. this is a generic function
 * not using any var database. variable name and value are given as
 * parameters directly */
void varman_replacestring(char *string,const char *varname,const char *svarval) 
{
	char *rest;

   /* use global MAXSTRINGSIZE here */
	rest=(char*)malloc(MAXSTRINGSIZE);
	while (strstr(string,varname)!=NULL)
	  {
		  strcpy(rest,strstr(string,varname)+strlen(varname));
		  strcpy(strstr(string,varname),svarval);
		  if ((strlen(string)+strlen(rest))>MAXSTRINGSIZE-1)
		    {
			    printf ("varman.c: stringsize overflow\n");
			    exit(-1);
		    }
		  ;		      
		  strcat(string,rest);
	  }
	;	
	free(rest);
}
;

/* replace variable in String by its value. this is a generic function
 * not using any var database. variable name and value are given as
 * parameters directly 
 * difference to function above: ignore quotes */
void varman_replacestring_quote(char *string,char *varname,char *svarval) 
{
	char *rest;
	
	rest=(char*)malloc(VARMAN_MAXSTRINGSIZE);
	while (helpings_strstr_quote(string,varname)!=NULL)
	  {
		  strcpy(rest,helpings_strstr_quote(string,varname)+strlen(varname));
		  strcpy(helpings_strstr_quote(string,varname),svarval);
		  if ((strlen(string)+strlen(rest))>VARMAN_MAXSTRINGSIZE-1)
		    {
			    printf ("varman.c: stringsize overflow\n");
			    exit(-1);
		    }
		  ;		      
		  strcat(string,rest);
	  }
	;	
	free(rest);
}
;

/* see above,takes double as argument */
void varman_replacestringbyfloat(char *string,char *varname,double varvalue)
{
	char *tmp;
	
	tmp=(char*)malloc(255);
        if (varvalue==(int)varvalue)
           sprintf(&tmp[0],"%.0lf",varvalue);
   	else
           sprintf(&tmp[0],"%lf",varvalue);
	varman_replacestring(string,varname,tmp);
	
	free(tmp);
}
;


/* basic functionality see above, this one is used for replacing variables in 
 * computed terms,automatically inserting brackets around the expression */
void varman_replacevarbyvalue(char *string,char *varname,char *svarval) 
{
	char *tmp;
	
	tmp=(char*)malloc(255);
	strcpy(tmp,"(");
	strcpy(&tmp[1],svarval);
	strcat(tmp,")");
	varman_replacestring(string,varname,tmp);
	
	free(tmp);
}
;

/* see above, only difference: double value instead of value as string.
 * naming changed due to c limitations */
void varman_replacevarbyvalue_float(char *string,char *varname,double varvalue) 
{
	char *tmp;
	
	tmp=(char*)malloc(255);	
	strcpy(tmp,"(");
	sprintf(&tmp[1],"%lf",varvalue);
	strcat(tmp,")");
	varman_replacestring(string,varname,tmp);
	
	free(tmp);
}
;

/* Replace whatever looks like a var in the current string */
void varman_replacevars(varman_database *db,char *string)
{
   GList *current;
   
   for (current=*db;current!=NULL;current=current->next)
     {
	varman_replacestring(string,
			     ((VARMAN_VAR_ENTRY*)current->data)->varname,
			     ((VARMAN_VAR_ENTRY*)current->data)->varvalue);
     }
   ;
}
;

/* Replace whatever looks like a var 
 * in the current string by its value in brackets */
void varman_replacevarsbyvalue(varman_database *db,char *string)
{
   GList *current;
   
   for (current=*db;current!=NULL;current=current->next)
     {
	varman_replacevarbyvalue(string,
				 ((VARMAN_VAR_ENTRY*)current->data)->varname,
				 ((VARMAN_VAR_ENTRY*)current->data)->varvalue);
     }
   ;
}
;

VARMAN_VAR_ENTRY *varman_getentry(varman_database *db,char *name)
{
   VARMAN_VAR_ENTRY *pos=NULL;
   GList *current;

   for (current=*db;current!=NULL;current=current->next)
     {
	if (!strcmp(((VARMAN_VAR_ENTRY*)current->data)->varname,
		    name))
	  pos=(VARMAN_VAR_ENTRY*)current->data;
     };
   return pos;
}
;

VARMAN_VAR_ENTRY *varman_getentrybyvalue(varman_database *db,char *value)
{
   VARMAN_VAR_ENTRY *pos=NULL;
   GList *current;

   for (current=*db;current!=NULL;current=current->next)
     {
	if (!strcmp(((VARMAN_VAR_ENTRY*)current->data)->varvalue,
		    value))
	  pos=(VARMAN_VAR_ENTRY*)current->data;
     };
   return pos;
}
;

char *varman_getvar_copy(varman_database *db,char *name)
{
	char *var,*varval;
	varval=varman_getvar(db,name);
   /* use the global maxstringsize here */
	var=(char*)malloc(MAXSTRINGSIZE);
	if (varval!=NULL)
	  {		  
	    if (strlen(varval)>MAXSTRINGSIZE-1)
		    {			    
			    printf ("Stringsize overflow.\n");
			    printf ("Please recompile Gtoaster with MAXSTRINGSIZE set \n");
			    printf ("to a higher value.\n");
			    exit(-1);
		    }
		  ;
	    strcpy(var,varval);
	  }	
	else
	    strcpy(var,"");		
	return var;
}
;

char *varman_getnamebyvalue_copy(varman_database *db,char *value)
{
	char *var,*varname;
	varname=varman_getnamebyvalue(db,value);
	var=(char*)malloc(VARMAN_MAXSTRINGSIZE);
	if (varname!=NULL)
	    strcpy(var,varname);
	else 
	    strcpy(var,"");
	return var;
}
;

char *varman_replacestring_copy(char *string,char *varname,char *svarval)
{
	char *result;
	result=(char*)malloc(VARMAN_MAXSTRINGSIZE);
	strcpy(result,string);
	varman_replacestring(result,varname,svarval);	
	return result;
}
;
	
char *varman_replacevarbyvalue_copy(char *string,char *varname,char *svarval)
{
	char *result;
	result=(char*)malloc(VARMAN_MAXSTRINGSIZE);
	strcpy(result,string);
	varman_replacevarbyvalue(result,varname,svarval);	
	return result;
}
;

char *varman_replacevarbyvalue_float_copy(char *string,char *varname,double varvalue)
{
	char *result;
	result=(char*)malloc(VARMAN_MAXSTRINGSIZE);
	strcpy(result,string);
	varman_replacevarbyvalue_float(result,varname,varvalue);	
	return result;
}
;

char *varman_replacevars_copy(varman_database *db,char *string)
{
	char *result;
	result=(char*)malloc(VARMAN_MAXSTRINGSIZE);
	strcpy(result,string);
	varman_replacevars(db,result);
	return result;
}
;

char *varman_replacevarsbyvalue_copy(varman_database *db,char *string)
{
	char *result;
	result=(char*)malloc(VARMAN_MAXSTRINGSIZE);
	strcpy(result,string);
	varman_replacevarsbyvalue(db,result);
	return result;
}
;

int varman_loaddatabase(varman_database *db,char *filename,char *section)
{
   FILE *f;
   char name[VARMAN_MAXSTRINGSIZE],value[VARMAN_MAXSTRINGSIZE];
   int success=0;
   
   f=fopen(filename,"r");
   if (f!=NULL)
     {
	if (configfile_seeksection(f,section))
	  {			    
	     do
	       {
		  configfile_getnextentry(f,name,value);
		  if (strlen(name)>0)
		    {			
		       /* force updatehandler processing */
		       varman_setvar_update(db,name,value,1);
		       
		       success=1;
		    }
		  ;
	       }
	     while (strlen(name)>0);
	  }
	;
	fclose(f);
	  }
   ;
   return success;
}
;

/* this function can be used as a callback for configfile.c without
 * modifications */
void varman_savedatabase_fd(FILE *fd,varman_database *db)
{
   GList *current;

   for (current=*db;current!=NULL;current=current->next)
     {
	/* using fwrite instead of printf here ensures that no
	 * escape sequences get executed while writing the strings */
	
	fwrite(((VARMAN_VAR_ENTRY*)current->data)->varname,
	       strlen(((VARMAN_VAR_ENTRY*)current->data)->varname),
	       1,
	       fd);
	fputc('=',fd);
	fwrite(((VARMAN_VAR_ENTRY*)current->data)->varvalue,
	       strlen(((VARMAN_VAR_ENTRY*)current->data)->varvalue),
	       1,
	       fd);
	fprintf(fd,"\n");
     }
   ;	
}
;

void varman_savedatabase(varman_database *db,char *filename,char *section)
{
	FILE *f;
	
	f=fopen(filename,"w+");
	if (f!=NULL)
	  {		  
		  fprintf (f,"%s\n",section);
		  varman_savedatabase_fd(f,db);
		  fclose(f);
	  }
	;
}
;

