/* GNOME Transcript
 * Copyright (C) 1999-2000 the Free Software Foundation
 * Authors : Matias Mutchinick
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __GTRANS_TABLE_EDITOR_H__
#define __GTRANS_TABLE_EDITOR_H__


#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <gtrans_ifase/gtrans_ifase.h>


/* STATE */
enum {
	GTRANS_TABLE_EDITOR_INTERRUPT = 1 << 0,
	GTRANS_TABLE_EDITOR_COMMITING = 1 << 1
};





#define GTRANS_TABLE_EDITOR_FLAGS(obj)             (GTRANS_TABLE_EDITOR(obj)->flags)
#define GTRANS_TABLE_EDITOR_SET_FLAGS(obj,flag)    (GTRANS_TABLE_EDITOR_FLAGS(obj)\
                                                    |= (flag))
#define GTRANS_TABLE_EDITOR_UNSET_FLAGS(obj,flag)  (GTRANS_TABLE_EDITOR_FLAGS (obj)\
                                                    &= ~(flag))

#define GTRANS_TABLE_EDITOR_INTERRUPT(obj)         (GTRANS_TABLE_EDITOR_FLAGS(obj)\
                                                    & GTRANS_TABLE_EDITOR_INTERRUPT)
#define GTRANS_TABLE_EDITOR_COMMITING(obj)         (GTRANS_TABLE_EDITOR_FLAGS(obj)\
                                                    & GTRANS_TABLE_EDITOR_COMMITING)





#define GTRANS_TABLE_EDITOR(obj)            GTK_CHECK_CAST(obj,\
                                            gtrans_table_editor_get_type(),\
                                            GTransTableEditor)

#define GTRANS_TABLE_EDITOR_CLASS(klass)    GTK_CHECK_CLASS_CAST(klass,\
                                            gtrans_table_editor_get_type(),\
                                            GTransTableEditorClass)

#define GTRANS_IS_TABLE_EDITOR(obj)         GTK_CHECK_TYPE(obj,\
                                            gtrans_table_editor_get_type())


typedef struct _GTransTableEditor        GTransTableEditor;
typedef struct _GTransTableEditorClass   GTransTableEditorClass;



struct _GTransTableEditor {
	
	/* The parent window */
	GtkWindow        window;
	
	/* The owner, aka "the parent table editor" */
	GtkWidget       *owner;

	/* The name of the table */
	gchar           *tname;
	
	/* A GtkMatrix for the data */
	GtkWidget       *matrix;

	/* The popup menu for the row buttons */
	GtkWidget       *row_menu; 
	
	/* The connection to a database backend */
	GTransIFaseConn   *conn;
	
	/* The tuples */
	GTransIFaseResult *res;
	
	/* The list for modification records (GTE_Record's) */
	GList             *mod;
      	
	/* Flags */
	guint16            flags;
};


struct _GTransTableEditorClass {
	
	GtkWindowClass parent_class;
	void (* commit_all)    (GTransTableEditor *gte);
	void (* commit_next)   (GTransTableEditor *gte);
	void (* stop)          (GTransTableEditor *gte);
	void (* close)         (GTransTableEditor *gte);
	
};



guint
gtrans_table_editor_get_type(void);



/*
 * gtrans_table_editor_new
 * @conn  : The GTransIFaseConn to the database we are working on.
 * @res   : The GtransIFaseResult of the "SELECT *" query.
 * @owner : The widget who will be the owner of the editor,
 *          should be the GTransDbEditor who poped it.
 *
 * Create a new GTransTableEditor which will commit the design
 * to @conn and signal to @owner that should update itself.
 * A GTransTableEditor allows us to create new tables in the database.
 */
GtkWidget *
gtrans_table_editor_new(GTransIFaseConn   *conn,
			GTransIFaseResult *res,
			gchar             *tname,
			GtkWidget         *owner);





/**
 * gtrans_table_editor_pop_query:
 * @gte : The GTransTableEditor
 *
 * Return the query that will commit to the server the changes
 * made to the row standing next in the mod/new lists.
 * Once this changes have been commited we can flush the index
 * of the row from the mod/new lists and pop the next query.
 */
gchar *
gtrans_table_editor_pop_query(GTransTableEditor *gte);





/**
 * gtrans_table_editor_sync:
 * @gte  : The GTransTableEditor
 *
 * Syncronizes the matrix widget and the GTransIFaseResult standing in the back,
 * this is, updates the changes made to the matrix widget.
 * Also removes from @gte->mod the record of the modification
 * standing in line.
 * @gte->mod is a GList * of all the modification records appended.
 * The records are GTE_Record structs.
 */
gint
gtrans_table_editor_sync(GTransTableEditor *gte);




/**
 * gtrans_table_editor_next_row:
 * @gte : The GTransTableEditor
 *
 * Return the number of the row standing next in the
 * modification list (@gte->mod).
 * Return -1 if there is not any.
 */
gint 
gtrans_table_editor_next_row(GTransTableEditor *gte);




/**
 * gtrans_table_editor_can_next:
 * @gte : The GTransTableEditor
 *
 * Return 1 if there are changes to be done,
 * return 0 otherwise.
 */
gint 
gtrans_table_editor_can_next(GTransTableEditor *gte);




/**
 * gtrans_table_editor_interrupt:
 * @gte : The GTransTableEditor
 *
 * Return 1 and unset the interrupt flag if it is already set.
 * Return 0 otherwise.
 */
gint
gtrans_table_editor_interrupt(GTransTableEditor *gte);



#endif /* __GTRANS_TABLE_EDITOR_H__ */







