/* GNOME Transcript
 * Copyright (C) 1999-2000 the Free Software Foundation
 * Authors : Matias Mutchinick
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <gnome.h>
#include "main.h"
#include "gtrans_conn_list.h"
#include "gtrans_about_dialog.h"
#include "gtrans_help.h"
#include "gtrans_conn.h"
#include "gtrans_edit_db.h"


/* Main app */
GtkWidget         *app;
GtkWidget         *conn_list;


/*
 * prog_menu
 */
static GnomeUIInfo prog_menu[]= {
	{ 
		GNOME_APP_UI_ITEM,
		N_("_Quit"),
		N_("Quit Gnome Transcript"),
		gtrans_main_quit,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_STOCK,
		GNOME_STOCK_MENU_QUIT,
		'Q',
		GDK_CONTROL_MASK,
		NULL
	},
	GNOMEUIINFO_END
};


/*
 * database_menu
 */
static GnomeUIInfo database_menu[]= {
	{ 
		GNOME_APP_UI_ITEM,
		N_("Connect"),
		N_("Connect to Database"),
		gtrans_conn_connect,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_STOCK,
		GNOME_STOCK_MENU_LINE_IN,
		0,
		(GdkModifierType)0,
		NULL
	},
	{ 
		GNOME_APP_UI_ITEM,
		N_("Disconnect"),
		N_("Disconnect from Database"),
		gtrans_conn_disconnect,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_STOCK,
		GNOME_STOCK_MENU_STOP,
		0,
		(GdkModifierType)0,
		NULL
	},
	GNOMEUIINFO_SEPARATOR,
	{ 
		GNOME_APP_UI_ITEM,
		N_("Open"),
		N_("Open a Database"),
		gtrans_edit_db,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_STOCK,
		GNOME_STOCK_MENU_OPEN,
		0,
		(GdkModifierType)0,
		NULL
	},
	GNOMEUIINFO_END
};




/*
 * help_menu
 */
static GnomeUIInfo help_menu[]=
{
	{
		GNOME_APP_UI_ITEM,
		N_("About..."),
		N_("Info about the Author"),
		gtrans_about, 
		NULL, 
		NULL,
		GNOME_APP_PIXMAP_STOCK, 
		GNOME_STOCK_MENU_ABOUT,
		0, 
		(GdkModifierType)0, 
		NULL
	}, 
	{
		GNOME_APP_UI_ITEM,
		N_("Help..."),
		N_("GNOME Transcript Tutorial"),
		gtrans_help_tutorial, 
		NULL, 
		NULL,
		GNOME_APP_PIXMAP_STOCK, 
		GNOME_STOCK_MENU_BLANK,
		0, 
		(GdkModifierType)0, 
		NULL
	}, 
	GNOMEUIINFO_END
};



static GnomeUIInfo main_menu[]= 
{
	GNOMEUIINFO_SUBTREE(N_("_Program"), prog_menu),
	GNOMEUIINFO_SUBTREE(N_("_Database"), database_menu),
	GNOMEUIINFO_SUBTREE(N_("_Help"), help_menu),
	GNOMEUIINFO_END
};


static GnomeUIInfo toolbar[]= {
	{ 
		GNOME_APP_UI_ITEM,
		N_("Connect"),
		N_("Connect to Database"),
		gtrans_conn_connect,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_STOCK,
		GNOME_STOCK_MENU_LINE_IN,
		0,
		(GdkModifierType)0,
		NULL
	},
	GNOMEUIINFO_SEPARATOR,
	{ 
		GNOME_APP_UI_ITEM,
		N_("Open"),
		N_("Open a Database"),
		gtrans_edit_db,
		NULL,
		NULL,
		GNOME_APP_PIXMAP_STOCK,
		GNOME_STOCK_MENU_OPEN,
		0,
		(GdkModifierType)0,
		NULL
	},
	GNOMEUIINFO_SEPARATOR,
	{
		GNOME_APP_UI_ITEM,
		N_("Quit"),
		N_("Quit Gnome Transcript"),
		gtrans_main_quit,
		NULL, NULL,
		GNOME_APP_PIXMAP_STOCK,
		GNOME_STOCK_MENU_QUIT,
		'Q',
		GDK_CONTROL_MASK,
		NULL
	},
	GNOMEUIINFO_END
};




/*
 * gtrans_main_quit
 * Quit. Very Simple and Incomplete
 */
void 
gtrans_main_quit(GtkWidget      *widget, 
		 gpointer        data)
{
	gtk_main_quit ();
}





/**
 * gtrans_main_open_db:
 * Handle double-click selection for the Open Connections List 
 * (conn_list).
 */
void
gtrans_main_open_db (GtkWidget *widget,
		     gint       row,
		     gint       col,
		     GdkEvent  *event,
		     gpointer   data)
{
       	if (event->type == GDK_2BUTTON_PRESS)
		gtrans_edit_db (NULL, NULL);
}




/*
 * gtrans_main_prepare_app
 * prepare the application, create the menus and toolbars.
 */
void
gtrans_main_prepare_app()
{
	GtkWidget *frame;
	GtkWidget *scrolled;
	
	app = gnome_app_new("GNOME","Gnome Transcript");
	gnome_app_create_menus(GNOME_APP(app),main_menu);
	gnome_app_create_toolbar(GNOME_APP(app),toolbar);
	gtk_widget_realize(app);
	
	gtk_signal_connect (GTK_OBJECT (app),"delete-event",
			    GTK_SIGNAL_FUNC (gtrans_main_quit), NULL);
	gtk_signal_connect (GTK_OBJECT (app),"destroy",
			    GTK_SIGNAL_FUNC (gtrans_main_quit), NULL);
	
	frame = gtk_frame_new("Open Connections");
	gtk_container_set_border_width(GTK_CONTAINER(frame),5);
	gnome_app_set_contents(GNOME_APP(app),frame);
	
	scrolled = gtk_scrolled_window_new(NULL,NULL);
	gtk_container_set_border_width(GTK_CONTAINER(scrolled),8);
	gtk_widget_set_usize(scrolled,200,230);
	gtk_container_add(GTK_CONTAINER(frame),scrolled);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled),
				       GTK_POLICY_AUTOMATIC,
				       GTK_POLICY_AUTOMATIC); 
	
	
	/* The conn_list */
	conn_list = gtrans_conn_list_new();
	gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrolled),conn_list);
	gtk_signal_connect (GTK_OBJECT(conn_list),"select_row",
			    GTK_SIGNAL_FUNC(gtrans_main_open_db),NULL);
	
	gtk_widget_show(conn_list);
	gtk_widget_show(scrolled);
	gtk_widget_show(frame);
	gtk_widget_show(app);
}



/*
 * main
 * Start-up GNOME and Gtk.
 */
int 
main (int      argc, 
      char    *argv[])
{
	gnome_init (PACKAGE, VERSION, argc, argv);
	gtrans_main_prepare_app ();
	gtk_main ();
	return 0;
}




