//$Id: argumentsink.h,v 1.1 2001/04/17 17:23:28 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 *
 * This portion of the code is written by Martin Schulze <MHL.Schulze@t-online.de>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_ARGUMENT_SINK_H
#define GUIKACHU_ARGUMENT_SINK_H

namespace SigC
{

    template <class R, class C1>
    struct AdaptorHideSlot1_1: public AdaptorSlot_
    {
#ifdef SIGC_CXX_PARTIAL_SPEC
	typedef R RType;
#else
	typedef typename Trait<R>::type RType;
#endif
	typedef Slot1<R,C1> SlotType;
	typedef Slot0<R> InSlotType;
	
	typedef CallDataObj2<typename SlotType::Func,AdaptorNode> CallData;
	
	static RType callback (void* d, C1 c1)
	    {
		CallData* data = (CallData*)d;
		AdaptorNode* node = data->obj;
		return ((typename InSlotType::Callback&)(node->data_))();
	    };
	
	static SlotData* create (SlotData *s)
	    {
		SlotData* tmp = (SlotData*)s;
		AdaptorNode* node = new AdaptorNode();
		copy_callback (tmp, node);
		CallData& data = reinterpret_cast<CallData&> (tmp->data_);
		data.callback = &callback;
		data.obj = node;
		return tmp;
	    }
    };
    
    template <class R, class C1>
    inline Slot1<R, C1> hide (const SigC::Slot0<R> &s)
    {
	return AdaptorHideSlot1_1<R,C1>::create(s.data());
    }
}

#endif /* !GUIKACHU_ARGUMENT_SINK_H */
