// ****************************************************************************
//  Project:        GUYMAGER
// ****************************************************************************
//  Programmer:     Guy Voncken
//                  Police Grand-Ducale
//                  Service de Police Judiciaire
//                  Section Nouvelles Technologies
// ****************************************************************************
//  Module:         Different message boxes we need all the time
// ****************************************************************************


#ifndef __DLGMESSAGE_H__
#define __DLGMESSAGE_H__

#include <QtGui> //lint !e537 Repeated include

#ifndef __COMMON_H__
   #include "common.h"
#endif

class t_DlgMessageLocal;

class t_DlgMessage: public QDialog
{
   Q_OBJECT

   public:
      t_DlgMessage ();
      t_DlgMessage (const QString &Title, const QString &Message, bool Monospaced=false, QWidget *pParent=NULL, Qt::WFlags Flags=0);
     ~t_DlgMessage ();

      void AdjustGeometry (void);

      static APIRET Show (const QString &Title, const QString &Message, bool Monospaced=false);

   private:
      t_DlgMessageLocal *pOwn;
};

enum
{
   ERROR_DLGMESSAGE_CONSTRUCTOR_NOT_SUPPORTED = ERROR_BASE_DLGMESSAGE + 1,
};

#endif

