 /*  -*-objc-*-
 *  DefaultXTerm.m: Implementation of the DefaultXTermView Class 
 *  of the GNUstep GWorkspace application
 *
 *  Copyright (c) 2001 Enrico Sersale <enrico@imago.ro>
 *  
 *  Author: Enrico Sersale
 *  Date: August 2001
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#include "DefaultXTerm.h"
#include "GWorkspace.h"
#include "Functions.h"
#include "GNUstep.h"

@implementation DefaultXTermView

- (void)dealloc
{
  RELEASE (xtermLabel);
  RELEASE (argsLabel);
  RELEASE (fieldsBox);
	RELEASE (setButt);
  TEST_RELEASE (defXTerm);
  TEST_RELEASE (defXTermArgs);
  [super dealloc];
}

- (id)init
{
  self = [super init];
  if (self) {  
	  NSUserDefaults *defaults;
    id label;
    
    defaults = [NSUserDefaults standardUserDefaults];      
    gw = [GWorkspace gworkspace];    

    fieldsBox = [[NSBox alloc] initWithFrame: NSMakeRect(68, 86, 257, 113)];
    [fieldsBox setBorderType: NSGrooveBorder];
		[fieldsBox setTitle: @"XTerminal"];
    [fieldsBox setTitlePosition: NSAtTop];
		[fieldsBox setContentViewMargins: NSZeroSize]; 

		label = [[NSTextField alloc] initWithFrame: NSMakeRect(8, 71, 238, 17)];	
		[label setAlignment: NSCenterTextAlignment];
		[label setBackgroundColor: [NSColor windowBackgroundColor]];
		[label setBezeled: NO];
		[label setEditable: NO];
		[label setSelectable: NO];
		[label setStringValue: @"xterm"];
    [fieldsBox addSubview: label]; 
    RELEASE (label);

		xtermLabel = [[NSTextField alloc] initWithFrame: NSMakeRect(77, 50, 100, 20)];	    
	  defXTerm = [defaults stringForKey: @"defxterm"];
    if (defXTerm != nil) {
      RETAIN (defXTerm);
		  [xtermLabel setStringValue: defXTerm];
    }
    [fieldsBox addSubview: xtermLabel]; 
    
		label = [[NSTextField alloc] initWithFrame: NSMakeRect(8, 29, 238, 17)];	
		[label setAlignment: NSCenterTextAlignment];
		[label setBackgroundColor: [NSColor windowBackgroundColor]];
		[label setBezeled: NO];
		[label setEditable: NO];
		[label setSelectable: NO];
		[label setStringValue: @"arguments"];
    [fieldsBox addSubview: label]; 
    RELEASE (label);
      
		argsLabel = [[NSTextField alloc] initWithFrame: NSMakeRect(8, 8, 238, 20)];	
	  defXTermArgs = [defaults stringForKey: @"defaultxtermargs"];
    if (defXTermArgs != nil) {
      RETAIN (defXTermArgs);
		  [argsLabel setStringValue: defXTermArgs];
    }
    [fieldsBox addSubview: argsLabel]; 
 
		[self addSubview: fieldsBox];     

		setButt = [[NSButton alloc] initWithFrame: NSMakeRect(138, 55, 118, 24)];
		[setButt setButtonType: NSMomentaryLight];
		[setButt setTitle: NSLocalizedString(@"Set", @"")];	
    [setButt setTarget: self];
    [setButt setAction: @selector(setXTerm:)];	
		[self addSubview: setButt]; 
  }
  
  return self;
}

- (NSString *)prefsname
{
  return @"XTerminal";
}

- (void)setXTerm:(id)sender
{
  NSUserDefaults *defaults;
  NSString *xterm, *xtermargs;
  
  xterm = [xtermLabel stringValue];
  xtermargs = [argsLabel stringValue];
  
  if (([defXTerm isEqualToString: xterm] == YES)
            && ([defXTermArgs isEqualToString: xtermargs] == YES)) { 
    return;
  }
  
  ASSIGN (defXTerm, xterm);
  ASSIGN (defXTermArgs, xtermargs);

  defaults = [NSUserDefaults standardUserDefaults];      
	[defaults setObject: defXTerm forKey: @"defxterm"];
	[defaults setObject: defXTermArgs forKey: @"defaultxtermargs"];
	[defaults synchronize];
  
  [gw changeDefaultXTerm: defXTerm arguments: defXTermArgs];
}

@end
