/*-
 * Copyright (c) 1991 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)unistd.h	5.13 (Berkeley) 6/17/91
 */

#ifndef _UNISTD_H_
#define	_UNISTD_H_

#include <sys/cdefs.h>
#include <sys/types.h>
#include <sys/unistd.h>

#define	 STDIN_FILENO	0	/* standard input file descriptor */
#define	STDOUT_FILENO	1	/* standard output file descriptor */
#define	STDERR_FILENO	2	/* standard error file descriptor */

#ifndef macintosh
/* fnmatch(3) defines */
#define	FNM_PATHNAME	0x01	/* match pathnames, not filenames */
#ifndef _POSIX_SOURCE
#define	FNM_QUOTE	0x02	/* escape special chars with \ */
#endif
#endif

#ifndef NULL
#define	NULL		0	/* null pointer constant */
#endif

typedef	int ssize_t;		/* count of bytes or error indication */

__BEGIN_DECLS
void	 _exit __P((int));
int	 access __P((const char *, int));
u_int	 alarm __P((u_int));
int	 chdir __P((const char *));
#ifndef macintosh
int	 chown __P((const char *, uid_t, gid_t));
#endif
int	 close __P((int));
#ifndef macintosh
char	*cuserid __P((char *));
#endif
int	 dup __P((int));
int	 dup2 __P((int, int));
#ifndef macintosh
int	 execl __P((const char *, const char *, ...));
int	 execle __P((const char *, const char *, ...));
int	 execlp __P((const char *, const char *, ...));
int	 execv __P((const char *, char * const *));
int	 execve __P((const char *, char * const *, char * const *));
int	 execvp __P((const char *, char * const *));
pid_t	 fork __P((void));
long	 fpathconf __P((int, int));		/* not yet */
#endif
char	*getcwd __P((char *, size_t));
#ifndef macintosh
gid_t	 getegid __P((void));
uid_t	 geteuid __P((void));
gid_t	 getgid __P((void));
int	 getgroups __P((int, int *));		/* XXX (gid_t *) */
char	*getlogin __P((void));
pid_t	 getpgrp __P((void));
pid_t	 getpid __P((void));
pid_t	 getppid __P((void));
uid_t	 getuid __P((void));
#endif
int	 isatty __P((int));
#ifndef macintosh
int	 link __P((const char *, const char *));
#endif
off_t	 lseek __P((int, off_t, int));
#ifdef macintosh
#ifdef __MWERKS__
int  read(int, char*, int);
#else
int  read(int, char*, unsigned);
#endif
#else
long	 pathconf __P((const char *, int));	/* not yet */
int	 pause __P((void));
ssize_t	 read __P((int, void *, size_t));
#endif
int	 pipe __P((int *));
int	 rmdir __P((const char *));
#ifdef macintosh
int  unlink(char*);
#ifdef __MWERKS__
int  write(int, const char*, int);
#else
int  write(int, const char*, unsigned);
#endif
u_int	 sleep __P((u_int));
#else
int	 setgid __P((gid_t));
int	 setpgid __P((pid_t, pid_t));
pid_t	 setsid __P((void));
int	 setuid __P((uid_t));
long	 sysconf __P((int));			/* not yet */
pid_t	 tcgetpgrp __P((int));
int	 tcsetpgrp __P((int, pid_t));
char	*ttyname __P((int));
int	 unlink __P((const char *));
ssize_t	 write __P((int, const void *, size_t));
#endif

#ifndef	_POSIX_SOURCE

/* structure timeval required for select() */
#include <sys/time.h>

#ifndef macintosh
int	 acct __P((const char *));
int	 async_daemon __P((void));
char	*brk __P((const char *));
int	 chflags __P((const char *, long));
int	 chroot __P((const char *));
char	*crypt __P((const char *, const char *));
int	 des_cipher __P((const char *, char *, long, int));
int	 des_setkey __P((const char *key));
int	 encrypt __P((char *, int));
void	 endusershell __P((void));
int	 exect __P((const char *, char * const *, char * const *));
int	 fchdir __P((int));
int	 fchflags __P((int, long));
int	 fchown __P((int, int, int));
int	 fnmatch __P((const char *, const char *, int));
int	 fsync __P((int));
#endif
int	 ftruncate __P((int, off_t));
int	 getdtablesize __P((void));
long	 gethostid __P((void));
int	 gethostname __P((char *, int));
#ifndef macintosh
mode_t	 getmode __P((const void *, mode_t));
int	 getpagesize __P((void));
char	*getpass __P((const char *));
char	*getusershell __P((void));
char	*getwd __P((char *));			/* obsoleted by getcwd() */
int	 initgroups __P((const char *, int));
int	 mknod __P((const char *, mode_t, dev_t));
int	 mkstemp __P((char *));
char	*mktemp __P((char *));
int	 nfssvc __P((int));
int	 nice __P((int));
void	 psignal __P((u_int, const char *));
extern char *sys_siglist[];
int	 profil __P((char *, int, int, int));
int	 rcmd __P((char **, int, const char *,
		const char *, const char *, int *));
char	*re_comp __P((const char *));
int	 re_exec __P((const char *));
#endif
int	 readlink __P((const char *, char *, int));
#ifndef macintosh
int	 reboot __P((int));
int	 revoke __P((const char *));
int	 rresvport __P((int *));
int	 ruserok __P((const char *, int, const char *, const char *));
char	*sbrk __P((int));
#endif
int	 select __P((int, fd_set *, fd_set *, fd_set *, struct timeval *));
#ifndef macintosh
int	 setegid __P((gid_t));
int	 seteuid __P((uid_t));
int	 setgroups __P((int, const int *));
void	 sethostid __P((long));
int	 sethostname __P((const char *, int));
int	 setkey __P((const char *));
int	 setlogin __P((const char *));
void	*setmode __P((const char *));
int	 setpgrp __P((pid_t pid, pid_t pgrp));	/* obsoleted by setpgid() */
int	 setregid __P((int, int));
int	 setreuid __P((int, int));
int	 setrgid __P((gid_t));
int	 setruid __P((uid_t));
void	 setusershell __P((void));
int	 swapon __P((const char *));
#endif
int	 symlink __P((const char *, const char *));
#ifndef macintosh
void	 sync __P((void));
int	 syscall __P((int, ...));
#endif
int	 truncate __P((const char *, off_t));
void	 usleep __P((u_int));
#ifndef macintosh
u_int	 ualarm __P((u_int, u_int));
int	 ttyslot __P((void));
void	*valloc __P((size_t));			/* obsoleted by malloc() */
int	 vfork __P((void));
#endif

#endif /* !_POSIX_SOURCE */
__END_DECLS

#endif /* !_UNISTD_H_ */
