/* 
 * File: wejpvolume.h
 *
 * A gtk2 volume control widget
 * Copyright (c) 2006 Johannes Heimansberg
 *
 * Released under the GNU General Public License v2
 */

#ifndef __WEJPVOLUME_H__
#define __WEJPVOLUME_H__

#include <glib.h>
#include <gtk/gtk.h>
G_BEGIN_DECLS

#define WEJPVOLUME_TYPE            (wejpvolume_get_type ())
#define WEJPVOLUME(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), WEJPVOLUME_TYPE, WejpVolume))
#define WEJPVOLUME_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass),  WEJPVOLUME_TYPE, WejpVolumeClass))
#define IS_WEJPVOLUME(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WEJPVOLUME_TYPE))
#define IS_WEJPVOLUME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),  WEJPVOLUME_TYPE))

struct _WejpVolume {
	GtkEventBox  dummy;

	GtkWidget   *image_status;
	GdkPixbuf   *icon_volume[4];

	guint        max_volume;
	gint         current_volume;
	gint         volume_step;
};

typedef struct _WejpVolume      WejpVolume;
typedef struct _WejpVolumeClass WejpVolumeClass;

struct _WejpVolumeClass
{
	GtkEventBoxClass parent_class;
	void (* wejpvolume) (WejpVolume *wv);
};

GType        wejpvolume_get_type  (void);
GtkWidget   *wejpvolume_new       (guint max_volume,
                                   guint initial_volume,
                                   gint  volume_step);
void         wejpvolume_clear     (WejpVolume *wv);

void         wejpvolume_draw      (WejpVolume *wv);
guint        wejpvolume_get_volume(WejpVolume *wv);
void         wejpvolume_set_volume(WejpVolume *wv, guint volume);

G_END_DECLS
#endif
