#ifndef K3DSDK_SHADER_COLLECTION_H
#define K3DSDK_SHADER_COLLECTION_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Provides an implementation of k3d::ishader_collection
		\author Tim Shead (tshead@k-3d.com)
*/

#include <k3dsdk/ishader_collection.h>

#include <k3dsdk/signal_system.h>

namespace k3d
{

// Forward declarations
class ioptions;

/////////////////////////////////////////////////////////////////////////////
// shader_collection

class shader_collection :
	public ishader_collection
{
public:
	shader_collection();

	/// Defines a signal emitted to display human-readable progress messages while loading shaders
	typedef SigC::Signal1<void, std::string> message_signal_t;
	message_signal_t& message_signal();

	void load_shaders(ioptions& Options, const std::string SourcePaths);

	const sdpsl::shaders_t& shaders();

private:
	message_signal_t m_message_signal;
	sdpsl::shaders_t m_shaders;
};

} // namespace k3d

#endif // K3DSDK_SHADER_COLLECTION_H

