#ifndef K3DSDK_GLUTILITY_H
#define K3DSDK_GLUTILITY_H

#include "algebra.h"
#include "glutility_private.h"

namespace k3d
{

/// Pushes a matrix onto the OpenGL matrix stack
inline void push_opengl_matrix(const matrix4& Matrix)
{
	double glmatrix[16];
	Matrix.Transpose().CopyArray(glmatrix);
	glMultMatrixd(glmatrix);
}

inline void glLoadName(const iunknown* const Name)
{
	implementation_private::gl_load_name(Name);
}

inline void glPushName(const iunknown* const Name)
{
	implementation_private::gl_push_name(Name);
}

inline void glPopName()
{
	implementation_private::gl_pop_name();
}

inline iunknown* glGetName(GLuint*& Names)
{
	return implementation_private::gl_get_name(Names);
}

} // namespace k3d
			
#endif // !K3DSDK_GLUTILITY_H

