#ifndef K3DSDK_SCRIPTING_H
#define K3DSDK_SCRIPTING_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Declares convenience objects for working with scripts
		\author Tim Shead (tshead@k-3d.com)
*/

#include "iscript_engine.h"
#include "iunknown.h"

#include <iosfwd>
#include <string>

namespace k3d
{

// Forward declarations
class idocument;
class iobject;
class iplugin_factory;
class uuid;

/// Attempts to determine which language a script is written in; could return 0 on failure
iplugin_factory* recognize_script_language(const std::string& Script);
/// Executes the contents of a string as a script, using a specific language
bool execute_script(const std::string& Script, const std::string& ScriptName, const iscript_engine::context_t& Context, const uuid& Engine);
/// Executes the contents of a string as a script, attempting to automatically recognize the language
void execute_script(const std::string& Script, const std::string& ScriptName, const iscript_engine::context_t& Context, bool& Recognized, bool& Executed);
/// Executes the contents of a stream as a script, attempting to automatically recognize the language
void execute_script(std::istream& Script, const std::string& ScriptName, const iscript_engine::context_t& Context, bool& Recognized, bool& Executed);

} // namespace k3d

#endif // K3DSDK_SCRIPTING_H

