// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\author Tim Shead (tshead@k-3d.com)
*/

#include "bounding_box.h"
#include "idocument.h"
#include "iobject.h"
#include "iobject_collection.h"
#include "viewport.h"

#include <sdpgl/sdpgl.h>

namespace k3d
{

namespace viewport
{

namespace detail
{

class redraw
{
public:
	redraw(const iviewport::redraw_type_t RedrawType) :
		m_redraw_type(RedrawType)
	{
	}

	void operator()(iobject* const Object)
	{
		iviewport* const viewport = dynamic_cast<iviewport*>(Object);
		if(viewport)
			viewport->redraw_request_signal().emit(m_redraw_type);
	}

protected:
	const iviewport::redraw_type_t m_redraw_type;
};

} // namespace detail

void draw_bounding_box(const k3d::bounding_box& Box)
{
	glBegin(GL_LINE_LOOP);
	glVertex3d(Box.nx, Box.ny, Box.nz);
	glVertex3d(Box.px, Box.ny, Box.nz);
	glVertex3d(Box.px, Box.ny, Box.pz);
	glVertex3d(Box.nx, Box.ny, Box.pz);
	glEnd();

	glBegin(GL_LINE_LOOP);
	glVertex3d(Box.nx, Box.py, Box.nz);
	glVertex3d(Box.px, Box.py, Box.nz);
	glVertex3d(Box.px, Box.py, Box.pz);
	glVertex3d(Box.nx, Box.py, Box.pz);
	glEnd();

	glBegin(GL_LINES);
	glVertex3d(Box.nx, Box.ny, Box.nz);
	glVertex3d(Box.nx, Box.py, Box.nz);

	glVertex3d(Box.px, Box.ny, Box.nz);
	glVertex3d(Box.px, Box.py, Box.nz);

	glVertex3d(Box.px, Box.ny, Box.pz);
	glVertex3d(Box.px, Box.py, Box.pz);

	glVertex3d(Box.nx, Box.ny, Box.pz);
	glVertex3d(Box.nx, Box.py, Box.pz);
	glEnd();

	glBegin(GL_LINE_STRIP);
	glVertex3d(Box.nx, Box.ny, Box.nz);
	glVertex3d(0.5 * (Box.nx + Box.px), Box.ny, Box.pz);
	glVertex3d(Box.px, Box.ny, Box.nz);
	glEnd();
}

void redraw_all(idocument& Document, const iviewport::redraw_type_t RedrawType)
{
	std::for_each(Document.objects().collection().begin(), Document.objects().collection().end(), detail::redraw(RedrawType));
}

void setup_material(k3d::iunknown* const Material)
{
	static GLubyte stipple_halftone[] = {
		0xaa, 0xaa, 0xaa, 0xaa, 0x55, 0x55, 0x55, 0x55,
		0xaa, 0xaa, 0xaa, 0xaa, 0x55, 0x55, 0x55, 0x55,
		0xaa, 0xaa, 0xaa, 0xaa, 0x55, 0x55, 0x55, 0x55,
		0xaa, 0xaa, 0xaa, 0xaa, 0x55, 0x55, 0x55, 0x55,
		0xaa, 0xaa, 0xaa, 0xaa, 0x55, 0x55, 0x55, 0x55,
		0xaa, 0xaa, 0xaa, 0xaa, 0x55, 0x55, 0x55, 0x55,
		0xaa, 0xaa, 0xaa, 0xaa, 0x55, 0x55, 0x55, 0x55,
		0xaa, 0xaa, 0xaa, 0xaa, 0x55, 0x55, 0x55, 0x55,
		0xaa, 0xaa, 0xaa, 0xaa, 0x55, 0x55, 0x55, 0x55,
		0xaa, 0xaa, 0xaa, 0xaa, 0x55, 0x55, 0x55, 0x55,
		0xaa, 0xaa, 0xaa, 0xaa, 0x55, 0x55, 0x55, 0x55,
		0xaa, 0xaa, 0xaa, 0xaa, 0x55, 0x55, 0x55, 0x55,
		0xaa, 0xaa, 0xaa, 0xaa, 0x55, 0x55, 0x55, 0x55,
		0xaa, 0xaa, 0xaa, 0xaa, 0x55, 0x55, 0x55, 0x55,
		0xaa, 0xaa, 0xaa, 0xaa, 0x55, 0x55, 0x55, 0x55,
		0xaa, 0xaa, 0xaa, 0xaa, 0x55, 0x55, 0x55, 0x55
		};

	static GLfloat color_black[4] = { 0, 0, 0, 1 };
	static GLfloat color_white[4] = { 1, 1, 1, 1 };

	imaterial* const material = dynamic_cast<imaterial*>(Material);
	if(material) // Editor material provided, so use it ...
		{
			material->setup_viewport_material();
			glDisable(GL_POLYGON_STIPPLE);
		}
	else // No material assigned, so create a default stippled effect ...
		{
			glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT, color_black);
			glMaterialfv(GL_FRONT_AND_BACK, GL_DIFFUSE, color_white);
			glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR, color_black);
			glMaterialfv(GL_FRONT_AND_BACK, GL_EMISSION, color_black);

			glPolygonStipple(stipple_halftone);
			glEnable(GL_POLYGON_STIPPLE);
		}
}

} // namespace viewport

} // namespace k3d


