#ifndef K3DUI_BUTTON_H
#define K3DUI_BUTTON_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Declares the k3dScriptButton class
		\author Anders Dahnielson (anders@dahnielson.com)
*/

#include "hotkey.h"
#include "k3duserinterfaceelement.h"

#include <k3dsdk/signal_system.h>

#include <sdpgtk/sdpgtkobjectcontainer.h>

#include <boost/utility.hpp>

namespace k3d
{

// Forward declarations
class idocument;
class iobject;

namespace button
{

/////////////////////////////////////////////////////////////////////////////
// control

class control :
        public k3dUserInterfaceElement,
	public boost::noncopyable
{
	typedef k3dUserInterfaceElement base;

public:
	control(k3d::iunknown* CommandNodeParent, const std::string& CommandNodeName);
	control(k3d::iunknown* CommandNodeParent, const std::string& CommandNodeName, const std::string& Label, const std::string& Pixmap = std::string());
	~control();

	/// Makes the button visible
	void show();
	/// Hides the button
	void hide();
	/// Controls button sensitivity
	void set_sensitive(const bool Sensitive);

	/// Signal emitted whenever the button is activated
	typedef SigC::Signal0<void> activate_signal_t;
	/// Signal emitted whenever the button is activated
	activate_signal_t& signal_activate();

	// Ugly internal stuff ...
	bool Create(sdpGtkIObjectContainer* ObjectContainer, sdpxml::Document& Document, sdpxml::Element& Element);
	const std::string CustomType() const;
	bool execute_command(const std::string& Command, const std::string& Arguments);

private:
	/// Called to handle SDPGTK events
	void OnEvent(sdpGtkEvent* Event);
	/// Called when the button is activated
	void on_activate();

	/// Hotkey object for (optionally) responding to hotkey events
	k3d::hotkey m_hotkey;
	/// Signal emitted whenever the button is activated
	activate_signal_t m_signal_activate;

	/// Private storage for the button state
	class state;
	state* const m_state;
};

} // namespace button

} // namespace k3d

#endif // K3DUI_BUTTON_H


