#ifndef K3DWINDOWGEOMETRYSTORE_H
#define K3DWINDOWGEOMETRYSTORE_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Declares the k3d::window_geometry_store interface and implementations, which encapsulate persisting window geometry (position & size) to various storage types
		\author Timothy M. Shead (tshead@k-3d.com)
*/

#include <memory>

namespace k3d
{

/////////////////////////////////////////////////////////////////////////////
// window_geometry_store

/// Abstract interface for objects that can store/retrieve window geometry
class window_geometry_store
{
public:
	virtual ~window_geometry_store() {}
	
	virtual void set_window_geometry(const std::string& WindowName, const int Left, const int Top, const unsigned int Width, const unsigned int Height) = 0;
	virtual bool get_window_geometry(const std::string& WindowName, int& Left, int& Top, unsigned int& Width, unsigned int& Height) = 0;

protected:
	window_geometry_store() {}
	window_geometry_store(const window_geometry_store&) {};
	window_geometry_store& operator=(const window_geometry_store&) { return *this; }
};

/////////////////////////////////////////////////////////////////////////////
// options_window_geometry_store

/// Implementation of window_geometry_store that persists geometry in user preferences
class options_window_geometry_store :
	public window_geometry_store
{
public:
	void set_window_geometry(const std::string& WindowName, const int Left, const int Top, const unsigned int Width, const unsigned int Height);
	bool get_window_geometry(const std::string& WindowName, int& Left, int& Top, unsigned int& Width, unsigned int& Height);
};

} // namespace k3d

#endif // !K3DWINDOWGEOMETRYSTORE_H


