//javascript

/// Boilerplate to determine which document to modify ...
function FindDocument(ScriptName)
{
	if(Document)
			return Document;
	else
			{
					if(Application.documents.length == 1)
							return Application.documents[0];
					else if(Application.documents.length == 0)
							Application.ui.ErrorMessage("You must have an open document to run this script!", ScriptName + ":");
					else
							Application.ui.ErrorMessage("Not sure which document to use ... try using the desired document's Document Window > Tools > Play Script.", ScriptName + ":");
			}
			
	return null;
}

document = FindDocument("dag_test2");
if(document)
	{
		// Start recording changes for undo-purposes ...
		document.StartChangeSet();

		sphere1 = document.CreateObject("Sphere");
		sphere2 = document.CreateObject("Sphere");
		channel = document.CreateObject("ScalarBezierChannel");

		// Finish recording undos ...
		document.FinishChangeSet("DAG Test 2");

		// Link the spheres' radii to the channel ...
		document.SetDependency(channel.Property("input"), document.Object("TimeSource").Property("time"));
		document.SetDependency(sphere1.Property("radius"), channel.Property("output"));
		document.SetDependency(sphere2.Property("radius"), channel.Property("output"));

		sphere1.name = "Sphere1";
		sphere2.name = "Sphere2";
		channel.name = "Radii";

		sphere1.position = [-6, 0, 0];
		sphere2.position = [6, 0, 0];
		var curve = channel.curve;
		curve.control_points[0][1] = 5.0;

		channel.curve = curve;

		document.RedrawAll();

		Application.ui.Show(channel);
		Application.ui.Message("Modify the channel radius to see that both spheres' radii are linked", "dag_test2:");
	}


