/***************************************************************************
    begin                : Tue Oct 16 19:03:20 EEST 2001
    copyright            : (C) 2001, 2006 by Mantia Andras
    email                : amantia@kdewebdev.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KALLERY_H
#define KALLERY_H

#include <kwizard.h>

/*Forward QT and KDE class declaration. Header files are included in the .cpp file*/
class QProgressDialog;
namespace KIO
{
  class Job;
}

/** 
 * @short 
 * Kallery is the base class of the project, a wizard widget. 
*/
class Kallery : public KWizard
{
  Q_OBJECT
      
public:
  /** construtor */
  Kallery(QWidget* parent=0, const char *name=0);
  /** destructor */
  ~Kallery();

private: // Private methods
  
  /**
    * Add the first page to the wizard.
    */
  void addFirstPage();
  
  /**
    * Add the "Select Image Sources page" to the wizard.
    */
  void addSelectSourcesPage();
  
  /**
    * Add the folder selection page.
    */
  void addTargetPathPage();
  
  /**
    * Add the image matching with thumbnails page.
    */
  void addImageThumbPage();
  
  /**
    * Add the options page for the main HTML file.
    */
  void addHtmlOptionsPage();
  
  /**
    * Add the last page to the wizard.
    */
  void addLastPage();
  
  /**
    * Add the thumbnail options page.
    */
  void addThumbSourcePage();
  
  /**
    * Add the image description page.
    */
  void addDescSourcePage();
  
  /**
    * Add the conversion options page.
    */
  void addImageOptionsPage();
  
  /**
    * Add page for fine tuning the individual image html files.
    */
  void addImageHtmlPage();
  
  /** 
    * Initialize ImageMagick and load the supported filter list. 
  */
  void initFilters();

protected slots: // Protected slots
  
  /** Called when the user presses Next. Save the options set on the current page, 
  * make a check and if everything is ok, go to the next page. 
  */
  virtual void next();
  /** 
    * Called when Finish is pressed. Starts the generation, saves the project and 
    * exists the application.
  */
  virtual void accept();
  
  /** Called when the wizard is aborted with Cancel. */
  virtual void reject();

private slots: // Private slots
  /**
   * Called when a new project was loaded.
   */
  void slotProjectLoaded();
  
  /**
   * Called just before a new page appears.
   * @param title The title of the upcoming page 
   */
  void slotPageHasChanged(const QString & title);
  
  /**
   * Called when the user presses the Help button.
   */
  void slotShowHelp();

public slots:
    /**
     * Called when a KIO job (copy/move/delete) finished
     * @param  job pointer to the job object
     */
    void slotResult(KIO::Job *job);
  
private: // Private attributes
    QProgressDialog* progress; ///< used to display progress information in a dialog
};

#endif
