/*
    kamefuemulatorconfig.h - Emulator configuration

    Copyright (c) 2005      by Michaël Larouche       <michael.larouche@kdemail.net>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/
#ifndef KAMEFUEMULATORCONFIG_H
#define KAMEFUEMULATORCONFIG_H

#include <kcmodule.h>

/**
 * Basic Emulator Configuration module. List all available systems and for each system, 
 * display two lineedit for emulation path and arguments.
 *
 * @author Michaël Larouche
 */
class KamefuEmulatorConfig : public KCModule
{
	Q_OBJECT
public:
	KamefuEmulatorConfig(QWidget* parent, const char* name, const QStringList& args);
	~KamefuEmulatorConfig();

public slots:
	virtual void save();
	virtual void load();

private slots:
	void settingsChanged();

private:
	class Private;
	Private *d;
};

#endif
