/*
    rommetadatafactory.h - Singleton factory classes that create correct RomMetaData.

    Copyright (c) 2005      by Michaël Larouche       <michael.larouche@kdemail.net>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/
#ifndef KAMEFUROMMETADATAFACTORY_H
#define KAMEFUROMMETADATAFACTORY_H

#include <qstring.h>

namespace Kamefu {

class RomMetaData;
/**
 * Singleton factory classes that create correct RomMetaData class based on file mime type.
 *
 * @author Michaël Larouche <michael.larouche@kdemail.net>
*/
class RomMetaDataFactory
{
public:
	~RomMetaDataFactory();
	
	static RomMetaDataFactory *self();

	/**
	 * Return the good RomMetaData depending of mimetype.
	 * Do not delete the returned object.
	 * @param romPath ROM path. Used to test if the registred RomMetaData can handle it.
	 * @param mimeType Asked mimetype
	 */
	RomMetaData *createRomMetaData(const QString &romPath, const QString &mimeType);
	void addRomMetaDataFactory(const QString &mimeType, RomMetaData *newRomMetaData);

private:
	RomMetaDataFactory();

	bool hasMimeType(const QString &mimeType);
	/**
	 * Find a suitable RomMetaData for the given path.
	 * Most of the file, the given path is a ZIP file.
	 *
	 * @param path File to check for a suitable RomMetaData
	 * @return Pointer to the suitable RomMetaData. Else return null.
	 */
	RomMetaData *findSuitableRomMetaData(const QString &path);

private:
	static RomMetaDataFactory *s_self;
	class Private;
	Private *d;
};

}

#endif
